/*
** $Header: omupi.h,v 1.7 96/07/24 14:21:45 sgans: Stab $
**
**  Copyright (c) Oracle Corporation 1990.  All Rights Reserved.
*/

/*===========================================================================*\
NAME
    omupi.h  (Header file for UPI inclusions)
NOTES
    This file is to be included instead of all the separate UPI inclusion files
    This presumes that orastd.h (i.e., s.h) has already been included.
MODIFIED
    sgans      07/15/96 -  add new fatal-class Oracle errors 
    sgans      04/23/96 -  add OERR_MPARAM 
    sgans      03/05/96 -  add OERR_2MNYVALS 
    sgans      03/21/94 -  add OERR_INVNUM error constant 
    sgans      02/04/94 -  add error code for missing PL/SQL package 
    nakumar    05/25/93 -  Remove include of hstdef.h 
    Gans       12/18/91 -  added #ifndef for uadset and uadseti
    Gans	9/19/91 -  renamed to omupi.h from mupi.h 
    Gans	3/22/91 -  created
\*===========================================================================*/

#ifndef OMUPI
#define OMUPI

/*-----------------*\
|  Includes	    |
\*-----------------*/

#ifndef  S
#include <s.h>
#endif									/* S */

#ifndef  UPIDEF
#include <upidef.h>
#endif								   /* UPIDEF */

#ifndef  OERDEF
#include <oerdef.h>
#endif								   /* OERDEF */

#ifndef  SQLDEF
#include <sqldef.h>
#endif								   /* SQLDEF */

/*-----------------*\
|  Macros	    |
\*-----------------*/

/* macro for doing array bind/define */
#ifndef uadset
#define	uadset(uad, b, bl, t)\
    (uad).uadbufp = (dvoid *)(b); (uad).uadbufl = (bl); (uad).uaddtype =(t)
#endif  /* uadset */

/* macro for doing array bind/define w/ indicator */
#ifndef uadseti
#define	uadseti(uad, b, bl, t, i)\
    (uad).uadbufp = (dvoid *)(b); (uad).uadbufl = (bl); (uad).uaddtype =(t);\
    (uad).uadindp = (b2 *)(i);
#endif  /* uadseti */

/* macro for fetching action count */
#define numsofar(hst) ((upih2o(hst))->oercnt)

/* macro for fetching action count (w/ an aiORASTD name) */
#define omxcount(hst) ((upih2o(hst))->oercnt)

/*-----------------*\
|  Constants	    |
\*-----------------*/

#define SQLB_SIZE	(size_t)-1	  /* default 'size' of upi SQL stmts */
#define SQLBUFSIZE	512		      /* generic size of SQL buffers */
#define SQLBUFSIZES	256	      /* generic size of SQL buffers - small */
#define SQLBUFSIZEL    1024	      /* generic size of SQL buffers - large */

/* Oracle Error codes */
#define OERR_NODATA      OER(1403)	       /* Oracle error: end of fetch */
#define OERR_DUP	 OER(1)	   /* Oracle error: duplicate value in index */
#define OERR_LOCKED	 OER(54)	       /* Oracle error: table locked */
#define OERR_NOCOL	 OER(904)	/* Oracle error: unknown column name */
#define OERR_2MNYVALS	 OER(913) 	    /* Oracle error: too many values */
#define OERR_NOTABLE	 OER(942)     /* Oracle error: unknown table or view */
#define OERR_KNOWN	 OER(955)     /* Oracle error: object already exists */
#define OERR_FOOSQ	 OER(1002)    /* Oracle error: fetch out of sequence */
#define OERR_MPARAM	 OER(1009)  /* Oracle error: missing mandatory param */
#define OERR_PASSWD	 OER(1017)	 /* Oracle error: incorrect password */
#define OERR_SHTDWN	 OER(1089) 		   /* Oracle error: shutdown */
#define OERR_DUPCOL	 OER(1430)    /* Oracle error: column already exists */
#define OERR_NULL	 OER(1451)	/* Oracle error: column already null */
#define OERR_INVNUM	 OER(1722) 	     /* Oracle error: invalid number */
#define OERR_EOFCC	 OER(3113) /* Oracle error: end-of-file on comm chnl */
#define OERR_NOCONN	 OER(3114) 	      /* Oracle error: not connected */
#define OERR_TCPDISC	 OER(6111) 	    /* Oracle error:  TCP disconnect */
#define OERR_PLSERR	 OER(6550) 	    /* Oracle error:  PL/SQL problem */

#define DIFF_TIME	(100*60*60)    /* one hour in 1/100 of sec intervals */

/* Column sizes */
#define TAB_NUMBER	(sizeof(ub4))			 /* coltype = NUMBER */
#define TAB_STRING	(240 + 1) 		  /* coltype = VARCHAR2(240) */
#define TAB_FLAG	(1 + 1)			    /* coltype = VARCHAR2(1) */
#define TAB_STRMED	(128 + 1) 		  /* coltype = VARCHAR2(128) */
#define TAB_STRSHT	(80 + 1) 		   /* coltype = VARCHAR2(80) */
#define TAB_STRMIN	(30 + 1) 		   /* coltype = VARCHAR2(30) */
#define TAB_STRSML	(5 + 1)			    /* coltype = VARCHAR2(5) */
#define TAB_STRFULL	(255 + 1) 		  /* coltype = VARCHAR2(255) */
#define TAB_DATE	(30 + 1)			   /* coltype = DATE */
#define TAB_RAW		(240)			       /* coltype = RAW(240) */
#define TAB_GLOBAL	(40)			 /* coltype = max sql NUMBER */

#endif								    /* OMUPI */
