# $Header: dgupdown.tcl 12-mar-99.09:32:27 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  dgupdown.tcl : Event definition of the Oracle Data Gatherer updown event. 
#
# ARGUMENTS:
#           None
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           None 
#
# $Log:  $
# Revision 1.1  1997/09/17 16:54  jriel
# Initial revision
#

# Event definition

oradefine event /oracle/host/fault/dgupdown description=VOC-01295 \
report=VOC-01296
oradefine end

# Initialize global variables

#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""     
# Is this the first time the script has run since agent initialization?  
set first_run 1
   

# The main event checking functions

proc EvalEvent {} {

    # Declare globals we will use
    global last_report output first_run
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set err ""

    # Get the data gatherer status

    if {[catch {append getdgstatus [ORACLE_HOME] "\/bin\/vppcntl"} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    
    if {[catch {set status [catch {exec $getdgstatus "-ping"} temp]} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

# CSF: check the return string because all platforms do not return
#      similar status codes for success/failure.
#
#    if {$status == 1} {
#	      set ret_code $ALERT_EVENT
#    }
    ORATCL_DEBUG "dgupdown : [oratime] : MESSAGE status = $status, temp = $temp"

# xxu: bug 1082357
#      to ignore "child process exited abnormally"

    set failMsg "The Oracle Data Gatherer is not running."
    set failMsgLen [string length $failMsg]
    set ret_string [string range $temp 0 [expr $failMsgLen - 1]]
    if { $ret_string == $failMsg } {
	      set ret_code $ALERT_EVENT
    }

    # return
    if {($last_report == $ret_code) && !($first_run == 1)} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "dgupdown : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code"
        set last_report $ret_code
        set first_run 0
        return $ret_code 
    }

}

