# $Header: paging.tcl 29-mar-99.18:13:54 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  paging.tcl : Event tcl file that checks if the paging rate has exceeded
#               the thresholds. This script uses vmstat to obtain the paging
#               rate.
#
# ARGUMENTS:
#           argv(0) == no of occurrence
#           argv(1) == threshold value for alert
#           argv(2) == threshold value for warning
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           the current cpu load
#
# $Log:  $
# Revision 1.4  1998/02/12  groyal
# improved error messages issued for script evaluation failures
#
# Revision 1.3  1996/08/22  20:29:34  yliu
# use tempdir
#
# Revision 1.2  1995/10/27  19:55:26  yliu
# change it for Solaris
#
# Revision 1.1  1995/10/26  22:15:23  yliu
# Initial revision
#
##########################################################################
#
# Porting note :
# vmstat may not exist on some of the platforms. Please make appropriate
# change for your port (e.g. use sar command). Make sure you parse the
# output correctly.
#
##########################################################################


# Event definition
oradefine event /oracle/host/perf/paging description=VOC-01251 \
report=VOC-01252
oraarguments no_occurrence alert_threshold warning_threshold
oravardesc no_occurrence int default=3 message=VOC-01253
oravardesc alert_threshold int message=VOC-01254
oravardesc warning_threshold int message=VOC-01255
oraresults current
oravardesc current int
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
set no_occurrence 0
set initial 1


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output no_occurrence initial
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    
    # calculate paging activity
    if { [catch {getpaging} paging] } {
        lappend output [format [msgtxt [NETWORK] nms 1005] paging.tcl]
        lappend output [msgtxt [NETWORK] nms 1076]
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        } 
    } 

 
    # print out event trace info 
    ORATCL_DEBUG "paging : $oramsg(oraobject) : [oratime] : $paging"

    set num_occur ""
    catch {expr [lindex $argv 0]-1} num_occur

    # Check for alert and warning threshold
    if {$paging > [lindex $argv 1]} {
        if {$no_occurrence < $num_occur} {
            incr no_occurrence
        } else {
            set ret_code $ALERT_EVENT
            set output $paging
        }
    } elseif {$paging > [lindex $argv 2]} {
        if {$no_occurrence < $num_occur} {
            incr no_occurrence
        } else {
            set ret_code $WARNING_EVENT
            set output $paging
        }
    } else {
        set no_occurrence 0
    } 


    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "paging : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code 
    }
}

