# $Header: brknjob.tcl 29-mar-99.02:12:23 xxu Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  brknjob.tcl : Event tcl file that checks if any jobs are broken
#
# ARGUMENTS:
#           argv(0) == connect string
#           argv(1) == threshold value for alert
#           
#
# RETURN:
#           $SCRIPT_FAIL
#           $CLEAR_EVENT
#           $NO_EVENT
#           $WARNING_EVENT
#           $ALERT_EVENT 
#
# OUTPUT:
#           A list of jobs that are broken
#
# $Log:  $
# Revision 1.5  12/12/97  18:28:59  rposham
# initial
#

# Event definition
#
#
#
oradefine event /oracle/rdbms/fault/brknjob description=VOC-01900 \
report=VOC-01901
oraarguments connect_str alert_threshold
oravardesc connect_str oracle_signon
oravardesc alert_threshold unsigned default=0 message=VOC-01902
oraresults jobs
oravardesc jobs string
oradefine end
#


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
oraeventpersist last_output {}

# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg last_output

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # connect to the database and open a cursor
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(oraobject)]
    if {[catch {oralogon $connect} lda]} {
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set cur [oraopen $lda]} err]} {
	lappend output $err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    # get job ids of broken jobs
    set sql "select job from sys.dba_jobs where broken='Y'"
    if { [catch { orasql $cur $sql }] } {
        lappend output [convertout $oramsg(db_characterset) \
            $oramsg(errortxt)] $sql
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set jobs ""

    if {[catch {set row [orafetch $cur]} err]} {
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }


    while {$oramsg(rc) == 0} {
        lappend jobs [lindex $row 0]
        if {[catch {set row [orafetch $cur]} err]} {
            lappend output $err
            catch {oraclose $cur} err
            catch {oralogoff $lda} err
	    if {$last_report == $SCRIPT_FAIL} {
        	return $NO_EVENT
            } else {
                set last_report $SCRIPT_FAIL
                return $SCRIPT_FAIL
            }
        }
    }


    # log off
    catch {oraclose $cur} err
    catch {oralogoff $lda]} err
            
    # print out event trace info 
    ORATCL_DEBUG "brknjob : $oramsg(oraobject) : [oratime] : number of broken jobs: [llength $jobs]"

    # check number of broken jobs against alert threshold 
    if {[llength $jobs] > [lindex $argv 1]} {
        set ret_code $ALERT_EVENT
        lappend output $jobs
    } 
    
    # return
    if {$last_report == $ret_code && ![string compare $last_output $output]} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "brknjob : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        set last_output $output
        return $ret_code 
    }

}


