# $Header: Deftran.tcl 29-mar-99.02:15:23 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  deftran.tcl : Event tcl file that checks if the number of rows 
#                in sys.DefTran table is within limits
#
# ARGUMENTS:
#           argv(0) == connect string
#           argv(1) == threshold value for alert
#           
#
# RETURN:
#           $SCRIPT_FAIL
#           $CLEAR_EVENT
#           $NO_EVENT
#           $WARNING_EVENT
#           $ALERT_EVENT
#
# OUTPUT:
#           Number of Rows in the deferred transaction queue ( count(*) of DefTran )
#
# $Log:  $
# Revision 1.5  12/12/97  18:28:59  rposham
# initial
#

# Event definition
#
#
#
oradefine event /oracle/rdbms/fault/deftran description=VOC-01910 \
report=VOC-01911
oraarguments connect_str alert_threshold
oravardesc connect_str oracle_signon
oravardesc alert_threshold unsigned default=100 message=VOC-01912
oraresults count
oravardesc count unsigned
oradefine end
#


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg 

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # connect to the database and open a cursor
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(oraobject)]
    if {[catch {oralogon $connect} lda]} {
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set cur [oraopen $lda]} err]} {
	lappend output $err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }


    # get count of deferred transactions
    set sql "select count(*) from sys.deftran"
    if { [catch { orasql $cur $sql }] } {
        lappend output [convertout $oramsg(db_characterset) \
            $oramsg(errortxt)] $sql
        catch {oraclose $cur} err
        catch {oralogoff $lda} err

        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set count [orafetch $cur]} err]} {
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }


    # log off
    catch {oraclose $cur} err
    catch {oralogoff $lda} err

    # print out event trace info 
    ORATCL_DEBUG "deftran : $oramsg(oraobject) : [oratime] : $count"


    # check number of deferred transactions against the alert threshold 
    if { $count > [lindex $argv 1] } { 
        set ret_code $ALERT_EVENT
        set output $count
    } 

     
    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
	      ORATCL_DEBUG "deftran : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code 
    }

}
