# $Header: probe.tcl 29-mar-99.13:19:09 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  probe.tcl : Event script which checks if a new connection can be 
#              established.
#
# ARGUMENTS:
#           argv(0) == connect string
#
#
# RETURN:
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $ALERT_EVENT
#
# $Log:  $
# Revision 1.5  1996/08/22  20:45:16  yliu
# use tempfile and rmfile verbs
#
# Revision 1.4  1996/03/07  00:39:30  yliu
# change temporary file name
#
# Revision 1.3  1996/01/10 00:03:46  yliu
# use oramsg(orahome)
#
# Revision 1.2  1995/10/25 18:56:10  yliu
# append service name to the connect string
#
# Revision 1.1  1995/10/11  00:38:55  yliu
# Initial revision
#


# Event definition
oradefine event /oracle/rdbms/fault/probe description=VOC-01191 \
report=VOC-01192 frequency=600
oraarguments connect_str 
oravardesc connect_str oracle_signon message=VOC-01193
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
oraeventpersist last_output {}

proc matcherror { alert_error_list catched_error } {

    set error_found ""

    foreach error $alert_error_list {
        if {[regexp -nocase $catched_error $error]} {
            set error_found $error 
            break
        }
    }
    lappend result $error_found

    return $result
}


# The main event checking functions
proc EvalEvent {} {
    

    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg env last_output

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""
    set catched_err ""
    set result ""

# ORA-00018 maximum number of sessions exceeded
# ORA-00019 maximum number of session licenses exceeded
# ORA-00020 maximum number of processes (string) exceeded
# ORA-01012 not logged on
# ORA-01033 ORACLE initialization or shutdown in progress
# ORA-01034 ORACLE not available
# ORA-01089 immediate shutdown in progress - no operations are permitted
# ORA-01090 shutdown in progress - connection is not permitted
# ORA-01219 database not open: queries allowed on fixed tables/views only
# ORA-03114 not connected to ORACLE
# ORA-12203 TNS:unable to connect to destination
# ORA-12541 TNS:no listener
# ORA-12571 TNS:packet writer failure

#    set alert_errors {ORA-01012 ORA-01033 ORA-01034 ORA-01089 ORA-01090 ORA-01219 ORA-03114 ORA-12571 ORA-00018 ORA-00019 ORA-00020 ORA-12203}
    set alert_error_numbers {00018 00019 00020 01012 01033 01034 01089 01090 01219 03114 12203 12541 12571} 

    set error_found "00000"
 
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(db_remoteaddress)]
    if {[catch {oralogon_uncached $connect} lda]} {
        set catched_err $oramsg(rc)
        ORATCL_DEBUG "probe: catched oralogon_uncached error = $catched_err"
        set result [matcherror $alert_error_numbers $catched_err]
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {[string compare $result ""] == 0} {
            if {$last_report == $SCRIPT_FAIL} {
                return $NO_EVENT
            } else {
                set last_report $SCRIPT_FAIL
                return $SCRIPT_FAIL
            }
        }
    } else {
        if {[catch {set cur [oraopen $lda]} err]} {
            set catched_err $oramsg(rc)
            ORATCL_DEBUG "probe: catched oraopen error = $catched_err"
            set result [matcherror $alert_error_numbers $catched_err]
            lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
            lappend output $err
            catch {oralogoff_uncached $lda} err
            if {[string compare $result ""] == 0} {
                if {$last_report == $SCRIPT_FAIL} {
                    return $NO_EVENT
                } else {
                    set last_report $SCRIPT_FAIL
                    return $SCRIPT_FAIL
                }
            }
        } else {
            set sql {select count(*) from all_users}
            if {[catch {orasql $cur $sql} err]} {
                set catched_err $oramsg(rc)
                ORATCL_DEBUG "probe: catched orasql error = $catched_err"
                set result [matcherror $alert_error_numbers $catched_err]
                lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
                lappend output [convertout $oramsg(db_characterset) \
                    $oramsg(errortxt)] $sql
                catch {oraclose $cur} err
                catch {oralogoff_uncached $lda} err
                if { [string compare $result ""] == 0 } {
                    if {$last_report == $SCRIPT_FAIL} {
                        return $NO_EVENT
                    } else {
                        set last_report $SCRIPT_FAIL
                        return $SCRIPT_FAIL
                    }
                }
            }
            if { [catch {oraclose $cur} err] } {
                ORATCL_DEBUG "probe: [oratime]: oraclose failed. $err"
            }
        }
        if { [catch {oralogoff_uncached $lda} err] } {
            ORATCL_DEBUG "probe: [oratime]: oralogoff_uncached failed. $err"
        }
    }

    if { [string compare $result ""] != 0 } {
        set ret_code $ALERT_EVENT
        set error_found $result
    }

    # print out event trace info 
    ORATCL_DEBUG "probe : $oramsg(oraobject) : [oratime] : error found ORA-$error_found, $output"

    # return
    if {$last_report == $ret_code && ![string compare $last_output $output]} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "probe : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"

        set last_report $ret_code
        set last_output $output
        return $ret_code
    }
}


