# $Header: sessterm.tcl 29-mar-99.03:44:05 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  sessterm.tcl : Event tcl file that checks for session terminated
#                 unexpectedly errors that exist in the alert file
#
# ARGUMENTS:
#           None    
#
# RETURN:
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           The error messages from the alert files.
# $Log:  $
# Revision 1.1  1998/01/22  groyal
# Initial revision
#


# Event definition
oradefine event /oracle/rdbms/fault/sessterm description=VOC-01301 \
report=VOC-01302
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $NO_EVENT
set output ""
oraeventpersist last_alert_size -1


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global last_report output last_alert_size 
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg env


    # initialize the return code and output
    set ret_code $NO_EVENT
    set output ""
    set err ""

    # set alert error to watch for the session terminated error
    set alert_error "ORA-00603"
    set alertfile ""
    
    # get the location of the alert file
    if {[catch {set alertfile [ALERTFILE]} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
        } else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
        }
    }

    # during initialization, set the alert file size
    if {$last_alert_size == -1} {
        if { [file exists $alertfile] } {
	    if {[catch {set last_alert_size [file size $alertfile]} err]} {
	        lappend output [format [msgtxt [NETWORK] nms 1005] Sessterm.tcl] 
	        lappend output $err
	        if {$last_report == $SCRIPT_FAIL} {
		    return $NO_EVENT
       	        } else {
		    set last_report $SCRIPT_FAIL
		    return $SCRIPT_FAIL
	        }
	    }
        } else {
            set last_alert_size 0
        }
        return $NO_EVENT
    }


    # check for the existence of the alert file
    if { ![file exists $alertfile] } {
        ORATCL_DEBUG "sessterm : $oramsg(oraobject) : [oratime] : $alertfile does not exist"
        return $NO_EVENT
    }


    # get the new alert file size
    if {[catch {set current_alert_size [file size $alertfile]} err]} {
        lappend output [format [msgtxt [NETWORK] nms 1005] Sessterm.tcl] 
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
        } else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
        }
    }

    # print out event trace info 
    ORATCL_DEBUG "sessterm : $oramsg(oraobject) : [oratime] : $alertfile, $current_alert_size"


    # must be a new alert log
    if {$last_alert_size > $current_alert_size} {
        ORATCL_DEBUG "alert : $oramsg(oraobject) : [oratime] : $alertfile looks new : $last_alert_size, $current_alert_size"
        set last_alert_size 0
    }


    # check for new errors
    if {$last_alert_size != $current_alert_size} {
 	if {[catch {set fd [open $alertfile r]} err]} {
            lappend output [format [msgtxt [NETWORK] nms 1005] sessterm.tcl] 
	    lappend output $err
	    if {$last_report == $SCRIPT_FAIL} {
	        return $NO_EVENT
            } else {
	        set last_report $SCRIPT_FAIL
	        return $SCRIPT_FAIL
	    }
    	} else {		        
            if {[catch {seek $fd $last_alert_size start} err]} {
                lappend output [format [msgtxt [NETWORK] nms 1005] sessterm.tcl] 
		lappend output $err
                catch {close $fd} err
	    	if {$last_report == $SCRIPT_FAIL} {
	            return $NO_EVENT
	        } else {
		    set last_report $SCRIPT_FAIL
	            return $SCRIPT_FAIL
	    	}
    	    }
	}

       while {[gets $fd line] >= 0} {
            if {[string first $alert_error $line] >= 0} {
                set ret_code $ALERT_EVENT
                break
            }
        }
        catch {close $fd} err
    }
    set last_alert_size $current_alert_size


    # return
    # this event triggers even if it's already triggered if new errors
    # are present in the alert file
    if { $ret_code != $NO_EVENT } {
        ORATCL_DEBUG "sessterm : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code"
    }
    return $ret_code


}

