# $Header: alertlrg.tcl 29-mar-99.13:44:25 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  alertlrg.tcl : Event tcl file that checks if the ALERT log is too large
#
# ARGUMENTS:
#           argv(0) == threshold value for alert
#           argv(1) == threshold value for warning
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           The current size of the ALERT log
#
# $Log:  $
#

# Event definition
oradefine event /oracle/rdbms/space/alertlrg description=VOC-01324 \
report=VOC-01325 frequency=600
oraarguments alert_threshold warning_threshold
oravardesc alert_threshold unsigned default=100000 message=VOC-01326
oravardesc warning_threshold unsigned default=50000 message=VOC-01327
oraresults size
oravardesc size unsigned
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg env


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""
    set alertfile ""

    # get the location of the alert file
    if {[catch {set alertfile [ALERTFILE]} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
        } else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
        }
    }

    # check for the existence of the alert file
    if { [file exists $alertfile] } {
        # get the alert file size
        if {[catch {set alert_size [file size $alertfile]} err]} {
	    lappend output [format [msgtxt [NETWORK] nms 1005] alertlrg.tcl] 
	    lappend output $err
	    if {$last_report == $SCRIPT_FAIL} {
	        return $NO_EVENT
       	    } else {
		set last_report $SCRIPT_FAIL
		return $SCRIPT_FAIL
	    }
	}
        set alert_size [expr $alert_size / 1024]

        ORATCL_DEBUG "alertlrg : $oramsg(oraobject) : [oratime] : $alertfile : $alert_size"


        # check for thresholds
        if {$alert_size > [lindex $argv 0]} {
            set ret_code $ALERT_EVENT
            set output $alert_size
        } elseif {$alert_size > [lindex $argv 1]} {
            set ret_code $WARNING_EVENT
            set output $alert_size
        }
    } else {
        ORATCL_DEBUG "alertlrg : $oramsg(oraobject) : [oratime] : $alertfile does not exist"
    }

    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "alertlrg : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code
    }


}

