# $Header: dmpfulpct.tcl 29-mar-99.05:33:10 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  dmpfulpct.tcl : Event tcl file that checks if the dump area is full
#
# ARGUMENTS:
#           argv(0) == threshold value for alert
#           argv(1) == threshold value for warning
#
# RETURN:
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           Dump area and Percentage of free space left in the dump area.
#
# $Log:  $
#

# Event definition
oradefine event /oracle/rdbms/space/dmpfulpct description=VOC-01365 \
report=VOC-01366 frequency=600
oraarguments alert_threshold warning_threshold
oravardesc alert_threshold int minimum=0 default=30 message=VOC-01367
oravardesc warning_threshold int minimum=0 default=50 message=VOC-01368
oraresults dump_area space_left
oravardesc dump_area string
oravardesc space_left int
orafixit /oracle/rdbms/space/movedump
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg env

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # Get the background_dump_dest and user_dump_dest location
   if {[catch {set dest [BACKGROUND_DUMP_DEST]} err]} {
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set avail [lindex [pctdiskusage $dest] 2]} err]} {
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set dest [USER_DUMP_DEST]} err]} {
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    
    if {[catch {set dest [lindex [pctdiskusage $dest] 2]} err]} {
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
   
    lappend avail $dest
     
    # print out event trace info 
    ORATCL_DEBUG "dmpfulpct : $oramsg(oraobject) : [oratime] : BACKGROUND_DUMP_DEST : [lindex $avail 0]"
    ORATCL_DEBUG "dmpfulpct : $oramsg(oraobject) : [oratime] : USER_DUMP_DEST : [lindex $avail 1]"

  
    # Check thresholds
    if {[lindex $avail 0] < [lindex $argv 0]} {  
        set ret_code $ALERT_EVENT
        lappend dump_area BACKGROUND_DUMP_DEST
        lappend space_left [lindex $avail 0]
    } else {    
        if {[lindex $avail 0] < [lindex $argv 1]} {  
            if {$ret_code == $CLEAR_EVENT} {
                set ret_code $WARNING_EVENT
            }
            lappend dump_area BACKGROUND_DUMP_DEST
            lappend space_left [lindex $avail 0]
        }
    } 
    
    if {[lindex $avail 1] < [lindex $argv 0]} {  
        set ret_code $ALERT_EVENT
        lappend dump_area USER_DUMP_DEST
        lappend space_left [lindex $avail 0]
    } else {
        if {[lindex $avail 1] < [lindex $argv 1]} {  
            if {$ret_code == $CLEAR_EVENT} {
                set ret_code $WARNING_EVENT
            }
            lappend dump_area USER_DUMP_DEST
            lappend space_left [lindex $avail 0]
        }
    }


    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        if {($ret_code == $ALERT_EVENT) ||
            ($ret_code == $WARNING_EVENT)} {
            lappend output $dump_area $space_left
        }
        ORATCL_DEBUG "dmpfulpct : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code
    }
}