#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrccc.tcl - Trace CLI cancel (stop) collection script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home 
#      argv(1) = job ID
#
# INPUT FILES:
#
#      file(0) = parameter file
#


oradefine job /oracle/otrace/general/otrccc

global oramsg

set epc_s_begclijob	  87
set epc_s_inv_col_name   121
set epc_s_nojobid        147
set epc_s_nohompar       156
set epc_s_nocliexe       175

set agent_addr [lindex [orainfo] 2]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_begclijob]]} cstat


#Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

set jobid [lindex $argv 1]
if { $jobid == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nojobid]]
}

set inp_file [lindex $oramsg(orainput) 0]
set col_status "Undefined"

### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}

# Normal stop status is success ...
if {[catch { exec $cliexe _stop $jobid $inp_file} col_status] } {
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} 

puts [convertout $oramsg(agent_characterset) $col_status]
catch {orajobstat $agent_addr "$col_status"} cstat

