#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrcccs.tcl - Trace CLI check collection status script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#      argv(1) = collection name
#
# INPUT FILES:
#
#      none
#

oradefine job /oracle/otrace/general/otrcccs

global oramsg

set epc_s_begclijob       87
set epc_s_inv_col_name   121
set epc_s_nohompar       156
set epc_s_nocliexe       175

set agent_addr [lindex [orainfo] 2]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_begclijob]]} cstat


#Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

set col_name [lindex $argv 1]
if { $col_name == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_inv_col_name]]
}

### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}

if {[catch { exec $cliexe _check $col_name } col_status] } {
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} 

puts [convertout $oramsg(agent_characterset) $col_status]
catch {orajobstat $agent_addr "$col_status"} cstat

