#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrcdfd.tcl - Trace CLI delete formatted data (from database) script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#      argv(1) = collection name
#      argv(2) = username
#      argv(3) = password
#      argv(4) = service name
#
# INPUT FILES:
#
#      none
#

oradefine job /oracle/otrace/general/otrcdfd

global oramsg

set epc_s_inv_col_name   121
set epc_s_nohompar       156
set epc_s_invconstr      159
set epc_s_nocliexe       175
set epc_s_delfmtstart    180
set epc_s_delfmtdone     181

set agent_addr [lindex [orainfo] 2]

# Display starting message, and send back as intermediate status ...
puts [msgtxt otrace EPC [format "%05d" $epc_s_delfmtstart]]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_delfmtstart]]} cstat

#Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

# Set job user/pw env variables ...
set env(EPC_JOB_USER) $SMP_USER
set env(EPC_JOB_PW)   $SMP_PASSWORD

set col_name [lindex $argv 1]
if { $col_name == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_inv_col_name]]
}

set user [lindex $argv 2]
if { $user == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_invconstr]]
}

set pw [lindex $argv 3]
if { $pw  == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_invconstr]]
}

set service [lindex $argv 4]
if { $service == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_invconstr]]
}

# Allow optional dfd by coll ID ...
set col_id [lindex $argv 5]
if { $col_id == "" } {
    set col_id "0"
}

# As of 816, pick up options flag arg ...
set opt_flag [lindex $argv 6]
if { $opt_flag == "" } {
    set opt_flag "0"
}

### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}


if {[catch { exec $cliexe _dfd $col_name $user $pw $service $col_id $opt_flag } del_result] } {
    puts " "
    puts [convertout $oramsg(agent_characterset) $del_result]
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} 

puts [convertout $oramsg(agent_characterset) $del_result]
catch {orajobstat $agent_addr "$del_result"} cstat

