#
# Copyright (c) 1996, 1997 by Oracle Corporation
#
# NAME: otrcvers.tcl - Trace CLI get version script
#
# VERSION: 804 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#
# INPUT FILES:
#
#      none
#

oradefine job /oracle/otrace/general/otrcvers

global oramsg

set epc_s_nohompar  156
set epc_s_nocliexe  175

# Set Oracle home based on input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}

### Normal version return is success ...
if {[catch {exec $cliexe _version} vers_ret ] } {
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} else {
    puts "$vers_ret"
}
