# $Header: sqlexec.tcl 26-may-97.11:14:25 dnakos Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  sqlexec.tcl : Run a Sql statement
#
# ARGUMENTS:
#        
#           argv(0) == database connect string
#           argv(1) == sql statement
#
# $Log:  $
# Revision 1.2  1995/09/26  00:35:09  yliu
# use message file
#
# Revision 1.1  1995/09/07  00:40:30  yliu
# Initial revision
#

oradefine job /oracle/rdbms/general/sqlexec description=VOC-02071
oraarguments connect_str sql
oravardesc connect_str oracle_signon message=VOC-02072
oravardesc sql string message=VOC-02073
oradefine end

# print out trace info
ORATCL_DEBUG "sqlexec : [lindex [split [lindex $argv 0] "@"] 1] : [oratime] : [lindex $argv 1]"

set connect_str [lindex $argv 0]
set sql_statement [lindex $argv 1]
set lda  [oralogon $connect_str]
set cur1 [oraopen $lda]
if {[catch {orasql $cur1 $sql_statement}] != 0} {
    puts $oramsg(errortxt)
}
set result_row [orafetch $cur1]
while {$oramsg(rc) == 0} {
  puts $result_row
  set result_row [orafetch $cur1]
}
oraclose $cur1
oralogoff $lda


