# $Header: shutdown.tcl 03-jun-97.09:56:30 dnakos Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  shutdown.tcl : Script to shutdown listener
#
# ARGUMENTS:
#           argv(0) == listener name, If '*' is specified,
#                      then stop the default listener LISTENER.
#           argv(1) == password, If '*' is specified,
#                      then do not set the password.
#       
#  None 
#
# $Log:  $
# Revision 1.5  1996/08/22  22:02:50  yliu
# use tempfile
#
# Revision 1.4  1996/01/19  01:10:58  yliu
# added listener name
#
# Revision 1.3  1996/01/11 00:42:18  yliu
# use message file
#
# Revision 1.2  1995/10/30 22:55:40  yliu
# took out oraobject
#
# Revision 1.1  1995/09/25  23:10:54  yliu
# Initial revision
#

oradefine job /oracle/sqlnet/general/shutdown description=VOC-02011
oraarguments listener_name password
oravardesc listener_name string default=*
oravardesc password string default=*
oradefine end

set listener_name [lindex $argv 0] 
if {[string compare $listener_name *] == 0} {
    # NT LISTENER CONTROL UTILITY DOES NOT SUPPORT * TO BE THE DEFAULT LISTENER
    orafail [msgtxt [NETWORK] nms 1002] 
}

if {[catch {StopListener $listener_name} outx]} {
    puts $outx
    orafail [format [msgtxt [NETWORK] nms 915] "" ""]
} else {
    puts [msgtxt1 [NETWORK] nms 1101]
}

