# $Header: startup.tcl 03-jun-97.09:56:26 dnakos Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  startup.tcl : Script to startup listener
#
# ARGUMENTS:
#           argv(0) == listener name, If default '*' is specified,
#                      then start the default listener LISTENER.
#       
#  None 
#
# $Log:  $
# Revision 1.3  1996/08/22  22:07:07  yliu
# use tempfile and rmfile
#
# Revision 1.2  1996/01/19  01:11:25  yliu
# added listener name
#
# Revision 1.1  1996/01/11 00:44:43  yliu
# Initial revision
#

oradefine job /oracle/sqlnet/general/startup description=VOC-02001
oraarguments listener_name
oravardesc listener_name string default=*
oradefine end

set listener_name [lindex $argv 0] 
if {[string compare $listener_name *] == 0} {
	# NT LISTENER CONTROL UTILITY DOES NOT SUPPORT * TO BE THE DEFAULT LISTENER
    orafail [msgtxt [NETWORK] nms 1002]  
}

if {[catch {StartListener $listener_name} outx]} {
	puts $outx
	orafail [format [msgtxt [NETWORK] nms 915] "" ""]
} else {
	if {[catch {getlsnrstatus $listener_name} status]} {
		set status 0
	}
}

if { $status } {
	puts [msgtxt1 [NETWORK] nms 1101]
} else {
	orafail [format [msgtxt [NETWORK] nms 915] "" ""]
}