#
# copyright (c) 1998 by the Oracle Corporation
#
# NAME:
#
#  frminit.tcl -- platform specific init file
#
# ARGUMENTS:
#
#  none
#
# RETURNS:
#
#  none
#
# MODIFIED     (MM/DD/YY)
#  vtummala     03/22/00 -
#  ayu          02/29/00 -  added frmSet/RestoreOracleEnvironment wrapper
#  ayu          03/04/98 -  Creation
#

#
# debug flag (0 or 1)
#
set frm_debug_flag 0

#
# set Forms60_home
#
source [AGENT_ORACLE_HOME]/[NETWORK]/agent/tcl/frmhome.tcl

#
# set some platform-specific variables
#
set _lnrexename "ifsrv60"
set _frmexename "ifweb60"
set _msexename "d2ls60"
set _mcexename "d2lc60"
set _lnr45exename "f45srv32"
set _f45exename "f45web32"
set _ms45exename "d2ls1032"
set _mc45exename "d2lc1032"
set _f60path "$Forms60_home\\bin\\"
set _f45path "$Forms45_home\\bin\\"
set _src ""
set _setenv_format "set %s=%s"
set _start "start"
set _listen "-listen"
set _killcommand "ifctrl60 -k"
set _logcommand "ifctrl60 -s"
set _rti_ps_command "ifctrl60 -c"
set _getmemusage "ifctrl60 -p"
set _getcpuusage "ifctrl60 -c"


#
# returns a list of running processes whose name matches the argument
#
proc frm_getpidlist { pat } {
    set ps_command "ifctrl60 -p"
    set pidlist {}
    set tmpf [tempfile tmp]
    # run pulist command to get a list of runtime instances
    eval exec $ps_command > $tmpf
    set fid [open $tmpf r]
    while {[gets $fid line] >= 0} {
      if [regexp -nocase $pat $line] {
          lappend pidlist [lindex $line 1]
      }
    }
    close $fid
    rmfile $tmpf

    return $pidlist
}

#
# log an entry to a pre-defined log file
#
proc frmdebug { entry } {
    global frm_debug_flag

    if { $frm_debug_flag } {
        set frm_logfile "c:\\temp\\tcl.log"
        set logfid [open $frm_logfile a]
        puts $logfid $entry
        close $logfid
    }
}

proc frmSetOracleEnvironment {} {
}

proc frmRestoreOracleEnvironment {} {
}

