/*
 *Copyright (c) 1996 by Oracle Corporation. All Rights Reserved. \
  $Header: cmdgetpu.c 23-aug-96.12:39:51 aswang Exp $
*/

#ifndef TFTPDEF
# include "tftpdef.h"
#endif

extern FILE *file_open();
extern void file_close();
extern double t_getrtime();

void err_ret();
void t_start();
void send_RQ();
void t_stop();
int fsm_loop();

void do_get(remfname, locfname)
char *remfname;
char *locfname;
{
  if ( (localfp = file_open(locfname, "w", 1)) == NULL)
  {
    err_ret("can't fopen %s for writing", locfname); 
    return;
  }

  totnbytes = 0;
  
  t_start();      /* start timer for statistics collecting */
  
  send_RQ(OP_RRQ, remfname, modetype);
  fsm_loop(OP_RRQ);
  
  t_stop();       /* stop timer for statistics collecting */

  file_close(localfp);

  printf("Received %ld bytes in %.6f seconds\n", totnbytes, t_getrtime());
}

void do_put(remfname, locfname)
char *remfname;
char *locfname;
{
  if ((localfp = file_open(locfname, "r", 0)) == NULL)
  {
    err_ret("can't fopen %s for reading", locfname); 
    return;
  }

  totnbytes = 0;
  t_start();

  lastsend = MAXDATA;
  send_RQ(OP_WRQ, remfname, modetype);
  fsm_loop(OP_WRQ);

  t_stop();

  file_close(localfp);
  printf("Sent %ld bytes in %.6f seconds\n", totnbytes, t_getrtime());
}
