
------------------------------------------------------------------------------
--
--  Create or replace procedures that provide access to OTrace API ...
--
------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE OTracePls AS

    FUNCTION StartColl (col_name      IN  STRING,
                        fdf_list      IN  STRING,
                        regid_list    IN  STRING,
                        prores_list   IN  STRING,
                        max_size      IN  PLS_INTEGER,
                        cache_size    IN  PLS_INTEGER,
                        resubmit      IN  PLS_INTEGER,
                        scheduled_by  IN  STRING) RETURN PLS_INTEGER;

    FUNCTION StopColl (col_name  IN  STRING) RETURN PLS_INTEGER;

    FUNCTION FormatColl (cdf_name  IN STRING,
                         username  IN STRING,
                         pw        IN STRING,
                         db        IN STRING,
                         cmtfreq   IN PLS_INTEGER,
                         flag      IN PLS_INTEGER) RETURN PLS_INTEGER;

END OTracePls;
/


CREATE OR REPLACE PACKAGE BODY OTracePls AS


    -- StartColl function ---------------------------------------------------

    FUNCTION StartColl (col_name      IN  STRING,
                        fdf_list      IN  STRING,
                        regid_list    IN  STRING,
                        prores_list   IN  STRING,
                        max_size      IN  PLS_INTEGER,
                        cache_size    IN  PLS_INTEGER,
                        resubmit      IN  PLS_INTEGER,
                        scheduled_by  IN  STRING) RETURN PLS_INTEGER
        AS LANGUAGE C
        LIBRARY OTracePlsLib 
        NAME   "otrcpsc_plsql_start_coll"
        PARAMETERS (col_name,
                    fdf_list,
                    regid_list,
                    prores_list,
                    max_size sb4, 
                    cache_size sb4,
                    resubmit sb4,
                    scheduled_by,
                    RETURN sb4);


    -- Stop collection function ---------------------------------------------

    FUNCTION StopColl (col_name  IN  STRING) RETURN PLS_INTEGER
        AS LANGUAGE C
        LIBRARY OTracePlsLib 
        NAME   "otrcpcc_plsql_cancel_coll"
        PARAMETERS (col_name,
                    RETURN sb4);

    -- Format collection function -------------------------------------------

    FUNCTION FormatColl (cdf_name  IN STRING,
                         username  IN STRING,
                         pw        IN STRING,
                         db        IN STRING,
                         cmtfreq   IN PLS_INTEGER,
                         flag      IN PLS_INTEGER) RETURN PLS_INTEGER
        AS LANGUAGE C
        LIBRARY OTracePlsLib 
        NAME   "otrcpfc_plsql_format_coll"
        PARAMETERS (cdf_name,
                    username,
                    pw,
                    db,
                    cmtfreq sb4,
                    flag    sb4,
                    RETURN  sb4);

END OTracePls;
/

