/*
 * $Header: epc.h 15-may-00.14:58:25 jmcdonal Exp $
 */

/* Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000 by Oracle Corporation */

/* NOTE:  See 'header_template.doc' in the 'doc' dve under the 'forms'
      directory for the header file template that includes instructions.
*/

/*
   NAME
     epc.h - <one-line expansion of the name>
   DESCRIPTION
     <short description of component this file declares/defines>
   RELATED DOCUMENTS

   INSPECTION STATUS
     Inspection date:
     Inspection status:
     Estimated increasing cost defects per page:
     Rule sets:

   ACCEPTANCE REVIEW STATUS
     Review date:
     Review status:
     Reviewers:

   PUBLIC FUNCTION(S)
     <list of external functions declared/defined - with one-line descriptions>
   PRIVATE FUNCTION(S)
     <list of static functions defined in .c file - with one-line descriptions>

   EXAMPLES

   NOTES
       DO NOT INCLUDE S.H 
       we can only include PUBLIC .h files

   MODIFIED   (MM/DD/YY)
    jmcdonal   05/15/00 -  817: fix olint problems with epc_reg_cf_cb, etc prot
    jmcdonal   03/22/00 -  817: move API version definition here from epcdef.h
    jmcdonal   03/19/99 -  806: remove tabs re bug 708695 (and trim lines)
    glavash    09/01/98 -  add socket messages
    jmcdonal   09/01/98 -  Restore missing public Trace API prototypes
    xxu        01/05/98 -  added new error code for cf callbacks
                           took out cf routines (now in epccf.h)
    glavash    09/10/97 -  update c++ epc_get_cf_items
    jmcdonal   11/25/96 -  Don't use err 152 and 154 for CLI job status
    jmcdonal   11/05/96 -  Add new CLI errors, eg for LRM errors
    glavash    10/22/96 -  change cf_items to ub4
    glavash    09/13/96 -  EPCFAC changes
    glavash    09/13/96 -  remove s.h
    mjlamber   08/01/96 -  FDF comment field
    jmcdonal   07/23/96 -  Add couple more CLI epc_s_xxx conditions,
                             eg for CLI image not found 
    jmcdonal   07/18/96 -  Add initial CLI errors/conditions.
    glavash    05/21/96 -  copy typedef stuff from oratypes.h to here 
                           make it more robust
    cmrozien   04/18/96 -  move CATALOG errors here.
                           make "text" unsigned for 8 bit
    glavash    04/18/96 -  remove s.h add test of sx_oracle
    CMROZIEN   04/17/96 -  add EPCLOADRESDLL error
    jmcdonal   02/01/96 -  add errors for delete collection files 
    gwood      12/21/95 -  formatter performance enhancements
    cmrozien   12/02/95 -  add EPCESVR* errors.
    gwood      11/30/95 -  fix file full handling
    gwood      11/20/95 -  Creation
*/

/* DO NOT INCLUDE S.H 
 * we can only include PUBLIC .h files
 */

/* include file for Oracle TRACE return codes and constants */
/* Copyright (c) Oracle Corporation 1995, 1996, 1997, 1998, 1999, 2000.
   All Rights Reserved. */

/*                                                                
* Abstract:
*
* Module:  epc.h
*
* This header file contains the success and error constants used by Oracle
* TRACEtrace, as well as caller visible constants.
*
* Instructions: When adding error codes, you need to add the #define in this
*               file and then add the error text to epcmsg.msg matching the
*               numbers appropriately.
*/
#ifndef EPC_ORACLE  
#define EPC_ORACLE 

#define EPC_API_VERSION   2

#define EPC_K_LOCAL  1
#define EPC_K_ALLOC  2
#define EPC_K_SHMEM  3
#define EPC_K_MMAP   4
#define EPC_K_GBLSEC 5

#define EPC_K_RETURN_EVENT 1

#define EPC_K_STAREC_SIZE  32
#define EPC_K_ENDREC_SIZE  32
#define EPC_K_POIREC_SIZE  28

#define EPC_K_MAXCFITEM 14

/* 
 * Service return status
*/


#define epc_s_success            0     /* The call was successful   */        

#define epc_s_msg_start          0
#define epc_s_badevntflgs        1     /* Bad event flags passed    */
#define epc_s_badfac             2     /* Bad facility id passed    */
#define epc_s_badfacver          3     /* Bad facility version passed   */
#define epc_s_badregid           4     /* Bad facility registration id  */
#define epc_s_badvendor          5     /* Bad vendor id passed      */
#define epc_s_disabled           6     /* Collection(s) has been disabled*/
#define epc_s_facverreq          7     /* Facility version required */
#define epc_s_init2              8     /* epc_init called twice for */
                                      /* this facility             */
#define epc_s_nodcfexists        9     /* No data capture file exists */
#define epc_s_noregexists       10    /* No registrar process exists */
                                      /* on this node              */
#define epc_s_notinstall        11    /* Oracle trace software not installed*/
#define epc_s_regtimeout        12    /* Registrar did not respond */
                                      /* within the time set by the*/
                                      /* env variable EPC_BE_REGTIMEOUT*/
#define epc_s_nomsglist         13    /* No message list.          */
#define epc_s_nofac             14    /* facility not defined in reg FBL*/
#define epc_s_noheap            15    /* not enough heap space     */
#define epc_s_badminevent       16    /* bad minimum event         */
#define epc_s_badmaxevent       17    /* bad maximum event         */
#define epc_s_facadded          18    /* facility added to the list */
#define epc_s_badattach         19    /* could not attach to shared mem*/
#define epc_s_badget            20    /* could not get access to mem */
#define epc_s_badopen           21    /* could not open semaphore   */
#define epc_s_facfound          22    /* facility found in registrar's */
                                      /* FBL.                       */
#define epc_s_facnotcol         23    /* facility not collecting    */
#define epc_s_baddettach        24    /* could not detach the sharedmem*/
#define epc_s_badclose          25    /* could not release semaphore */
#define epc_s_colfound          26    /* collection list found for a */
                                      /* given facility number       */
#define epc_s_metricfound       27    /* metric found in Reg's FBL   */
#define epc_s_metricnotfound    28    /* metric not found in Reg's FBl*/
#define epc_s_facnotfound       29    /* facility not found in Prc FBL*/
#define epc_s_colnotfound       30    /* collection not found        */
#define epc_s_coladded          31    /* collection added to col block*/
#define epc_s_dcfexists         32    /* data capture file exists          */
#define epc_s_mutex_init        33    /* Global Mutex created for DCf */
#define epc_s_mutex_initerror   34    /* Error while creating mutex   */
#define epc_s_illbuflen         35    /* illegal record length        */
#define epc_s_badevnt           36    /* bad event passed             */
#define epc_s_noevnt            37    /* No event specified           */
#define epc_s_nohandl           38    /* NO handle specified          */
#define epc_s_evntnotcol        39    /* Event specified not collecting*/
#define epc_s_writdcf           40    /* Error writing to DCF         */
#define epc_s_badthdcreate      41    /* Error creating Thread        */
#define epc_s_badthddetach      42    /* Error detaching Thread       */
#define epc_s_mutexlck_error    43    /* Error obtaining mutex lock   */
#define epc_s_mutexunlck_error  44    /* Error unlocking mutex        */
#define epc_s_itmnotcol         45    /* Item not collecting          */
#define epc_s_fail              46    /* General Error Message        */
#define epc_s_badthread         47    /* bad thread                   */
#define epc_s_nothread          48    /* no thread                    */
#define epc_s_thread_not_cur    49    /* thread_id not current thread */
#define epc_s_badevntrec        50    /* Bad event record arg passed  */
#define epc_s_regid_notexists   51    /* Regid does not exists        */
#define epc_s_regid_limit_exd   52    /* Regid limit exceeded         */
#define epc_s_regid_exists      53    /* Regid already exists         */
#define epc_s_fac_limit_exd     54    /* facilit limit exceeded       */
#define epc_s_opedcf            55    /* error opening dcf            */
#define epc_s_opecdf            56    /* error opening cdf            */
#define epc_s_badcfitem         57    /* bad cf item number           */
#define epc_s_initreq           58    /* epc_init call required       */
#define epc_s_eflgsreq          59    /* eventflgs required           */
#define epc_s_datafilereq       60    /* datafile required            */
#define epc_s_fdffilereq        61    /* fdffile  required            */
#define epc_s_colactive         62    /* collection already active    */
#define epc_s_fdfrderr          63    /* error reading fdf file */
#define epc_s_credcf            64    /* error creating dcf */
#define epc_s_crecdf            65    /* error creating cdf */
#define epc_s_wrtcdf            66    /* error writing cdf */
#define epc_s_opefdf            67    /* error opening fdf            */
#define epc_s_cdfseek           68    /* seek error in cdf */
#define epc_s_ogetmach          69    /* get os name, machine name err */
#define epc_s_ogethost          70    /* get host name err */
#define epc_s_maxevent          71    /* max_event must be > 0 */
#define epc_s_ret_eflagsreq     72    /* returned_eflags required */
#define epc_s_badoffset         73    /* bad offset value */
#define epc_s_shmemreq          74    /* shmem id or filename req */
#define epc_s_filnamreq         75    /* filename required */
#define epc_s_preeflagsreq      76    /* predefined_eventflags required */
#define epc_s_badoption         77    /* bad option value */
#define epc_s_not_impl          78    /* not yet implemented */
#define epc_s_appendfail        79    /* file append failed */
#define epc_s_appendseek        80    /* file append seek failed */
#define epc_s_appendwrt         81    /* append write failed */
#define epc_s_appendrd          82    /* append write failed */
#define epc_s_crefdf            83    /* error creating fdf */
#define epc_s_memmap            84    /* memory mapping failed */
#define epc_s_unmap             85    /* memory unmapping failed */ 
#define epc_s_mmapreq           86    /* memory map req before unmap */
#define epc_s_begclijob         87    /* Generic beginning CLI job */
#define epc_s_lsffail           88    /* lsf failure */
#define epc_s_excdmaxeve        89    /* event_id exceeds max on epc_init */
#define epc_s_wrtver            90    /* error writing version record */
#define epc_s_badminute         91    /* 0 to 59 required */
#define epc_s_badhour           92    /* 0 to 23 required */
#define epc_s_interrarg         93    /* internal error: invalid argument */
#define epc_s_timefail          94    /* failure on system timestamp call */

/* Add new errors for Reg ID routines in epcrid.c; JMc, 8/21/95 */

#define  epc_s_add_regid        95    /* error adding new Reg ID record */
#define  epc_s_clo_regid        96    /* error closing Reg ID file */
#define  epc_s_cre_regid        97    /* error creating new Reg ID file */
#define  epc_s_del_regid        98    /* Reg ID delete error */
#define  epc_s_del_regid_det    99    /* error deleting Reg ID details */
#define  epc_s_find_free_slot  100    /* error finding free Reg ID rec slot */
#define  epc_s_find_regid_fac  101    /* error finding facility primary rec */
#define  epc_s_get_regid       102    /* error finding facility Reg ID data */
#define  epc_s_inv_regid_cxt   103    /* invalid Reg ID context error */
#define  epc_s_inv_regid_data  104    /* invalid/inconsistent Reg ID data */
#define  epc_s_inv_regid_str   105    /* invalid Reg ID string, eg too long */
#define  epc_s_next_regid      106    /* error finding next Reg ID record */
#define  epc_s_next_regid_det  107    /* error finding next Reg details rec */
#define  epc_s_ope_regid       108    /* error opening Reg ID file */
#define  epc_s_read_regid      109    /* error reading a Reg ID record */
#define  epc_s_read_regid_hdr  110    /* error reading Reg ID file header */
#define  epc_s_regid_env       111    /* Reg ID environment variable error */
#define  epc_s_set_regid_ext   112    /* error setting file extend_count */

/* Add new errors for COL file routines in epccol.c; JMc, 8/30/95 */

#define  epc_s_add_col         113    /* error during add of new COL record */
#define  epc_s_clo_col         114    /* error during close of COL file */
#define  epc_s_col_env         115    /* bad/missing COL file env variable */
#define  epc_s_col_exists      116    /* collection already exists in file */
#define  epc_s_cre_col         117    /* error creating COL file */
#define  epc_s_del_col         118    /* error deleting COL record */
#define  epc_s_find_col        119    /* error finding specified COL record */
#define  epc_s_inv_col_cxt     120    /* invalid/undefined COL context */
#define  epc_s_inv_col_name    121    /* invalid/undefined collection name */
#define  epc_s_next_col        122    /* error getting next COL record */
#define  epc_s_ope_col         123    /* error during open of COL file */
#define  epc_s_read_col        124    /* error reading COL record */
#define  epc_s_read_col_hdr    125    /* error reading COL file header */
#define  epc_s_set_col_ext     126    /* error setting COL file extend_count */
#define  epc_s_upd_fac_ef      127    /* facility eventflag update error */
#define  epc_s_upd_pro_ef      128    /* process eventflag update error */

/* Add new errors for PRO file routines in epcpro.c; JMc, 9/1/95 */

#define  epc_s_pro_add         129    /* error adding PRO record */
#define  epc_s_pro_clo         130    /* error closing PRO file */
#define  epc_s_pro_cre         131    /* error creating PRO file */
#define  epc_s_pro_del         132    /* error in delete/free of PRO rec */
#define epc_s_comclijob        133    /* Generic completed CLI job status */
#define  epc_s_pro_fac_add_regid 134  /* error adding PRO_REGID to PRO_FAC */
#define  epc_s_pro_fac_del_regid 135  /* error deleting PRO_REGID */
#define  epc_s_pro_get_regpid  136    /* get registrar PID from PRO failed */
#define  epc_s_pro_inv_cxt     137    /* invalid/undefined PRO file context */
#define  epc_s_pro_next        138    /* fetch of next PRO record failed */
#define  epc_s_pro_ope         139    /* error during open of PRO file */
#define  epc_s_pro_read        140    /* read of PRO file record failed */
#define  epc_s_pro_read_hdr    141    /* error during read (map) of PRO hdr */
#define  epc_s_pro_set_ext     142    /* set of PRO file extend_count failed */
#define  epc_s_pro_upd         143    /* update of PRO record failed */
#define  epc_s_pro_upd_regpid  144    /* error updating registrar PID in PRO */

#define epc_s_stop_col         145    /* error stopping collection */

/* Add new errors for use with Trace CLI; JMc, 7/15/96 */

#define epc_s_clisuccess       146  /* generic CLI success */
#define epc_s_nojobid          147  /* No Job ID was specified */
#define epc_s_colstatact       148  /* Collection status is: Active */
#define epc_s_colstatnotact    149  /* Collection status is: Not active */
#define epc_s_colstatundef     150  /* Collection status is: Undefined */
#define epc_s_delcolfil        151  /* Deleted collection cdf and dat files */
#define epc_s_opeparfil        152  /* Error opening input parameter file */
#define epc_s_invclicom        153  /* Invalid/ambiguous CLI command */
#define epc_s_invprores        154  /* Invalid/missing restriction */
#define epc_s_res_limit_exd    155  /* Max # of restrictions exceeded */
#define epc_s_nohompar         156  /* Oracle home parameter not supplied */
#define epc_s_started          157  /* Started collection */
#define epc_s_stopped          158  /* Stopped collection */
#define epc_s_invconstr        159  /* User/pw (or service) not supplied */

#define epc_s_scolact          160   /* error activating collection */
#define epc_s_scolmod          161   /* error modifying collection file */
#define epc_s_scolfdf          162   /* fdf file error in act col */
#define epc_s_orahome          163   /* error translating ORACLE_HOME */
#define epc_s_fadmindir        164   /* error in admin directory routine */
#define epc_s_fproddir         165   /* error in product directory routine */
#define epc_s_colcan           166   /* error cancelling col */
#define epc_s_colfull          167   /* collection file reached limit */
#define epc_s_forafpath        168   /* error getting filepath off */
                                      /* ORACLE_HOME */
#define epc_s_delcdf           169   /* error deleting cdf file */
#define epc_s_deldat           170   /* error deleting collection dat file */

/* Additional errors for Trace CLI use; JMc, 7/17/96 */

#define epc_s_tclscan          171  /* Tcl scan error */
#define epc_s_lrmfail          172  /* CORE LRM param mgr failure */
#define epc_s_lrmpaa           173  /* LRM cmd line arglist parse failed */
#define epc_s_lrmpfi           174  /* LRM input param file parse failed */
#define epc_s_nocliexe         175  /* CLI image not found/not executable */
#define epc_s_fmtdone          176  /* Format to database completed */
#define epc_s_fmtstart         177  /* Format operation has started */
#define epc_s_notcljob         178  /* No Tcl job name was specified */
#define epc_s_errstop          179  /* Stopped coll due to cdf max filesize */
#define epc_s_delfmtstart      180  /* Delete of fmt data started */
#define epc_s_delfmtdone       181  /* Delete of fmt data completed */
#define epc_s_ocierr           182  /* OCI database error */
#define epc_s_epcfctx          183   /* EPCFCTX invalid */
#define epc_s_cdfinvalid       184   /* invalid CDF file ptr */
#define epc_s_filever          185  /* Wrong file version MJL 1 Aug 1996 */
#define epc_s_colstart         186   /* error marking collection started */
#define epc_s_collmtexcd       189   /* active colleciton limit exceeded */

#define epc_s_fac_inv_cxt      190   /* invalid facility file context */
#define epc_s_fac_add          191   /* error adding facility record */
#define epc_s_fac_cre          192   /* error creating facility file */
#define epc_s_fac_set_ext      193   /* error setting extent in fac file */
#define epc_s_fac_upd          194   /* error updating facility record */
#define epc_s_fac_next         195   /* error finding next facility */
#define epc_s_fac_read_hdr     196   /* error reading header in fac file */
#define epc_s_fac_read         197   /* error reading fac file */
#define epc_s_fac_del          198   /* error deleting facility record */
#define epc_s_fac_clo          199   /* error closing facility file */
#define epc_s_fac_ope          200   /* error opening facility file */

#define EPC__MSG_START 200
#define EPC__PAGE 201 
#define EPC__FACDEF_STITLE 202 
#define EPC__SUP_DATE_FORMAT 203 
#define EPC__RPQU_DATE_DISABLED 204 
#define EPC__PRODUCT_NAME 205 
#define EPC__RPQU_VERSION_DISABLED 6 
#define EPC__RPQU_EVENT 207 
#define EPC__RPQU_FACILITY 208 
#define EPC__RPQU_VERSION 209 
#define EPCREPCOLLECTION 210 
#define EPCREPEPID 211 
#define EPCREPUNAME 212 
#define EPCREPCPU 213 
#define EPCREPOSFVER 214 
#define EPCREPNODENAME 215 
#define EPCREPTIME 216 
#define EPCREPTIME_FORMAT 217 
#define EPCREPFACILITY 218 
#define EPCREPVERSION 219 
#define EPCREPITMNTFND 220 
#define EPCREPREGID 221 
#define EPCREPSTIME 222 
#define EPCREPETIME 223 
#define EPCREPERRPUT 224 
#define EPCREPERRTIME 225 
#define EPCREPERRLOCALTIME 226 
#define EPCREPFACREGID_NF 227 
#define EPCREPFAC_NF 228 
#define EPCREPERR_ADDEITE 229 
#define EPCREPEVE_NF 230 
#define EPCREPSTART_ORPH 231 
#define EPCREPEND_ORPH 232 
#define EPC__MEM_MALLOC 233 
#define EPC__MEM_CALLOC 234 
#define EPCDCF_FNF 235 
#define EPCCDFFNF 236 
#define EPCCDFRNK 237 
#define EPCCDFERF 238 
#define EPC__ERR_HUH 239 
#define EPCLBJUST 240 
#define EPCLBINSB 241 
#define EPC__OPEN 242 
#define EPC__CREATE 243 
#define EPC__ENV_NF 244 
#define EPC__MAP 245 
#define EPC__EVNTFLG_UPD 246 
#define EPCFDFERF 247 
#define EPCFDFRNK 248 
#define EPC__HIST_BUF 249 
#define EPC__HIST_WRT 250 
#define EPC__IO_APPSEEK 251 
#define EPC__IO_APPREAD 252 
#define EPC__IO_APPWRT 253 
#define EPC__IO_CLR 254 
#define EPC__IO_SET 255 
#define EPC__IO_STAT 256 
#define EPC__IO_READ 257 
#define EPC__IO_WRT 258 
#define EPC__IO_SEEK 259 
#define EPC__IO_EXTEND 260 
#define EPC__IO_MAPRD 261 
#define EPC__IO_MAPWRT 262 
#define EPC__IO_MAPLCK 263 
#define EPC__IO_BADFP 264 
#define EPC__THREAD_ERR 265 
#define EPC__MUTEXUNLCK 266 
#define EPC__FLUSH_ERR 267 
#define EPC__LOCK 268 
#define EPC__LOCK_TST 269 
#define EPC__IO_UNMAP 270 
#define EPC__REG_UPD 271 
#define EPC__REG_QUEUE 272 
#define EPC__REG_UNKMSG 273 
#define EPC__REG_PROERR 274 
#define EPC__RGMSG_EXISTS 275 
#define EPC__RGMSG_CREATE 276 
#define EPC__RGMSG_DESTROY 277 
#define EPC__RGMSG_OPEN 278 
#define EPC__RGMSG_READ 279 
#define EPC__RGMSG_SEND 280 
#define EPC__SCHED_ERR 281 
#define EPC__RGSCHED_COL 282 
#define EPC__RGSCHED_START 283 
#define EPC__RGSCHED_FDF 284 
#define EPC__RGSCHED_FDFEMP 285 
#define EPC__RGSCHED_APP2 286 
#define EPC__RGSCHED_UNXFDF 287 
#define EPC__RGSCHED_PROEMP 288 
#define EPC__RGSCHED_PROSEND 289 
#define EPC__GETHOSTNAME 290 
#define EPCPRO_FIND 291 
#define EPC__CONDINIT 292 
#define EPC__MUTEXINIT 293 
#define EPC__THREADCRE 294295 
#define EPC__UNAME 296 
#define EPC__WRITDCF 297 
#define EPC__MUTEXLCK 298 
#define EPCCOLNOTFOUND 299 
#define EPCCOLNOTFOUNDA 300 
#define EPCCOLNOTACTIVE 301 
#define EPC__CONDSIG 302 
#define EPC__THDDELAYNP 303 
#define EPC__HST_WRT 304 
#define EPCCOLFILFULL 305 
#define EPCREPNOTEXT 306 
#define EPCFMTCOMMIT_ERR 307 
#define EPCFMTORACLE_ERR 308 
#define EPCFMTORASQL_ERR 309 
#define EPCERRMSB 310 
#define EPCCREPROCESS 311 
#define EPCCRESCHEDULE 312 
#define EPCCRECOLLECTION 313 
#define EPCREADDCF 314 
#define EPCCRESTARTHDL 315 
#define EPCFINDPROCREC 316 
#define EPCSTRTOOLONG 317 
#define EPCCREDATAFILE 318 
#define EPCMISSCHEDINFO 319 
#define EPCFINDSCHEDREC 320 
#define EPCCOLLSTART 321 
#define EPCREPPRO_ERR 322 
#define EPCREPREGPRO 323 
#define EPCNOTFREE 324325 
#define EPCSTILLFREE 326 
#define EPCFILEEMPTY 327 
#define EPCFREEERR 328 
#define EPCPRONXT  329 
#define EPCESDIA_INVARGS_ERR  330 
#define EPCESDOD_OPENDIR_ERR 331 
#define EPCESDFA_FINFOALLOC_ERR 332 
#define EPCESDRD_READDIR_ERR 333 
#define EPCESDLA_LISTALLOC_ERR 334 
#define EPCESDDA_FDFALLOC_ERR 335 
#define EPCESDNM_NOMATCH_ERR 336 
#define EPCREPUSAGE 337 
#define EPCPRODELERR 338 
#define EPCCOLDELERR 339 
#define EPCN_INV_CCX 340 
#define EPCN_INV_SCX 341 
#define EPCFMTNOCOL 342 
#define EPCFMTUSAGE 343 
#define EPCFMTNONEWDATA 344 
#define EPCESVRAAO_FDFERR 345 
#define EPCESVRAEO_FDFERR 346 
#define EPCESVRAAS_FDFERR 347 
#define EPCESVRAAA_FDFERR 348 
#define EPCESVR_ORADBERR 349 
#define EPCFMTABORT_ERR 350 /* Error during format */
#define EPCFMTCANCEL_ERR 351 /* Cancel during format */
#define EPCFILEEXISTS  352 /* File already exists */
#define EPCLOADRESDLL 353 
#define epc_s_fac_del_regid 355 /* error deleting regid from fac */
#define epc_s_apiver        356   /* incompatabile api versions */
#define epc_s_reg_cb_duplicate  357  /* add a duplicate callback routine */
#define epc_s_unreg_cb_nonexist 358  /* remove a non-exist callback routine */
#define epc_s_socket 359 /* socket system call failed */
#define epc_s_connect 360 /* socket connect system call failed */
#define epc_s_select 361 /* select on socket failed */
#define epc_s_send   362 /* send on socket failed */
#define epc_s_sockclose 363 /* error closing socket */
#define epc_s_invldrectype 364 /* invalid record type */
#define epc_s_sockbuflen 365 /* record too large for socket collection */

/* Put next server error here */

/* Put catalog errors below this line */
#define EPCCATALOG_SUCCESS 0
#define EPCCAT__MSG_START 500 
#define EPCCATALOG_ERROR 501 
#define EPCCATALOG_EOF 502 
#define EPCCATALOG_NO_DB_ACCESS 503 
#define EPCCATALOG_DUP_COLL_NM 504 
#define EPCCATALOG_DUP_CDF 505 
#define EPCCATALOG_FMT_COLL_NOT_FOUND 506 
#define EPCCATALOG_NO_ID_STR 507 
#define EPCCATALOG_NO_DB_STR 508 
#define EPCCATALOG_ORA_NOT_AVAIL_STR 509 
#define EPCCATALOG_NO_COLL_SUM_STR 510 
#define EPCCATALOG_LOGON_DENIED 511 
#define EPCCATALOG_NO_FMT_FOUND 512 
#define EPCCATALOG_COLL_NOT_FOUND 513 
#define EPCCATALOG_INCONSISTENT 514 
#define EPCCATALOG_SUMMARY_NOT_FOUND 515 
#define EPCCATALOG_NO_EVENT_DEL 516 


/* CORE datatype definitions for non-CORE users  KLC 10/03/95 */
/* glavash 04/18/96 change test of S_ORACLE to SX_ORACLE */

/* DO NOT INCLUDE S.H or any other NON-PUBLIC .h file */

#ifndef SX_ORACLE
#if defined(A_OSF)

#ifndef lint
typedef unsigned int  ub4;
typedef   signed int  sb4;
#else
#define ub4 unsigned int
#define sb4 signed int
#endif

#else 


#ifndef lint
typedef unsigned long  ub4;
typedef   signed long  sb4;
#else
#define ub4 unsigned long
#define sb4 signed long
#endif

#ifdef lint
# define dvoid void
#else

# ifdef UTS2
#  define dvoid char
# else
# define dvoid void
# endif

#endif
#endif

typedef unsigned char text;

#endif

typedef ub4 EPCFCTX;

/* routine prototypes */
#ifdef __cplusplus
extern "C"
{
sb4 epc_check_ef(
    sb4 api_version,
    sb4 event_id,
    EPCFCTX *epcfctx_ptr);

sb4 epc_init(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text* version,
    text* registration,
    sb4* predefined_eventflgs,
    sb4** returned_evenflgs,
    sb4 max_event,
    sb4 eventflg_option,
    ub4 offset,
    sb4 shmem_id,
    text* filename,
    dvoid (*cb_rout)(),
    EPCFCTX *epcfctx_ptr );

sb4 epc_start_event(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 *handle,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr );

sb4 epc_end_event(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 *handle,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr );

sb4 epc_event(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr );

sb4 epc_context(
    sb4 api_version,
    sb4 *context);

sb4 epc_delete_context(
    sb4 api_version,
    sb4 *context );

sb4 epc_cancel(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text* collection,
    sb4* eventflags,
    EPCFCTX *epcfctx_ptr );

sb4 epc_collect(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    sb4 *eventflgs,
    text *data_file_ptr,
    text *fdf_file_ptr,
    sb4 *eventflags,
    ub4 max_col_size,
    EPCFCTX *epcfctx_ptr );

sb4 epc_bind(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *data_file );

sb4 epc_flush(
    sb4 api_version );

sb4 epc_add_reg_id(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *registration_id,
    ub4  cf_item_number,
    EPCFCTX *epcfctx_ptr );

sb4 epc_remove_reg_id(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *registration_id,
    ub4 cf_item_number,
    EPCFCTX *epcfctx_ptr );

sb4
epc_drop_fac(
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    EPCFCTX *epcfctx_ptr );

sb4 epc_get_cf_items(
    sb4 api_version,
    ub4* cf_item_ptr,
    sb4 context,
    ub4** ret_items_ptr );
 
sb4 epc_set_cf_items(
    sb4 api_version,
    ub4* cf_item_ptr,
    sb4 context );
 
sb4 epc_cf_value(
    sb4 api_version,
    sb4 item_number,
    ub4 item_value,
    sb4 context,
    ub4  **cf_item_ptr );
 
sb4 epc_reg_cf_cb(
    sb4 api_version,
    sb4 item_number,
    sb4 context,
    void (*cb_routine)(void *param),
    void *param );
 
sb4 epc_unreg_cf_cb(
    sb4 api_version,
    sb4 item_number,
    sb4 context,
    void (*cb_routine)(void *param),
    void *param );

}
#else
sb4 epc_check_ef(/*_
    sb4 api_version,
    sb4 event_id,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_init(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text* version,
    text* registration,
    sb4* predefined_eventflgs,
    sb4** returned_evenflgs,
    sb4 max_event,
    sb4 eventflg_option,
    ub4 offset,
    sb4 shmem_id,
    text* filename,
    dvoid (*cb_rout)() ,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_start_event(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 *handle,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr _*/);


sb4 epc_end_event(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 *handle,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_event(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    sb4 event_id,
    sb4 context,
    text *event_rec,
    sb4 event_rec_size,
    sb4 option,
    ub4 *cf_items,
    sb4 *eventflags,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_context(/*_
    sb4 api_version,
    sb4 *context _*/);

sb4 epc_delete_context(/*_
    sb4 api_version,
    sb4 *context _*/);

sb4 epc_cancel(/*_

    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text* collection,
    sb4* eventflags,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_collect(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    sb4 *eventflgs,
    text *data_file_ptr,
    text *fdf_file_ptr,
    sb4 *eventflags,
    ub4 max_col_size,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_bind(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *data_file _*/);

sb4 epc_flush(/*_
    sb4 api_version _*/);

sb4 epc_add_reg_id(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *registration_id,
    ub4  cf_item_number,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_remove_reg_id(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    text *registration_id,
    ub4 cf_item_number,
    EPCFCTX *epcfctx_ptr _*/);

sb4
epc_drop_fac(/*_
    sb4 api_version,
    sb4 vendor,
    sb4 facility,
    text *version,
    EPCFCTX *epcfctx_ptr _*/);

sb4 epc_get_cf_items(/*_
    sb4 api_version,
    ub4* cf_item_ptr,
    sb4 context,
    ub4** ret_items_ptr _*/);
 
sb4 epc_set_cf_items(/*_
    sb4 api_version,
    ub4* cf_item_ptr,
    sb4 context _*/);
 
sb4 epc_cf_value(/*_
    sb4 api_version,
    sb4 item_number,
    ub4 item_value,
    sb4 context,
    ub4  **cf_item_ptr _*/);
 
sb4 epc_reg_cf_cb(/*_
    sb4 api_version,
    sb4 item_number,
    sb4 context,
    void (*cb_routine)(void *param),
    void *param _*/);
 
sb4 epc_unreg_cf_cb(/*_
    sb4 api_version,
    sb4 item_number,
    sb4 context,
    void (*cb_routine)(void *param),
    void *param _*/);

#endif

#endif
