connect internal;

create or replace package sqljutl as
      function has_default(oid number,
                           proc char,
                           seq number,
                           ovr number) return number;
end sqljutl;
/
create or replace package body sqljutl is
      function has_default(oid number,
                           proc char,
                           seq number,
                           ovr number) return number is
               def number;
      begin
         if proc IS NULL
         then
            select DEFAULT# INTO def FROM ARGUMENT$
                   WHERE PROCEDURE$ IS NULL AND OBJ# = oid
                         AND SEQUENCE# = seq AND OVERLOAD# = ovr;
         else 
            select DEFAULT# INTO def FROM ARGUMENT$
                   WHERE PROCEDURE$ = proc AND OBJ# = oid
                         AND SEQUENCE# = seq AND OVERLOAD# = ovr;
         end if;

         if def IS NULL
         then return 0;
         else return 1;
         end if;
      end has_default;
end sqljutl;
/

grant execute on sqljutl to public ;

