rem
rem  $Header: /plus/v4/spam/precious/files/ACTIVE/pupbld.sql,v 1.2 1996/06/21 02:25:41 cjones Exp $
rem  Copyright (c) Oracle Corporation 1988, 1994, 1996.  All Rights Reserved.
rem
rem  +---------------------------------------------------------------------+
rem  |  PUPBLD.SQL -- CREATE PRODUCT AND USER PROFILE TABLES               |
rem  |                                                                     |
rem  |  Connect as SYSTEM before running this script                       |
rem  |                                                                     |
rem  |  This script is used by the DBA to create the product_user_profile  |
rem  |  synonym in the SYSTEM account                                      |
rem  +---------------------------------------------------------------------+
rem
rem  +---------------------------------------------------------------+
rem  |  If PRODUCT_USER_PROFILE existed, use its values and drop it  |
rem  +---------------------------------------------------------------+

drop synonym product_user_profile;

create table sqlplus_product_profile as
  select product, userid, attribute, scope, numeric_value, char_value,
  date_value from product_user_profile;

drop table product_user_profile;
alter table sqlplus_product_profile add (long_value long);

rem  +---------------------------------------+
rem  |  Create SQLPLUS_PRODUCT_PROFILE from scratch  |
rem  +---------------------------------------+

create table sqlplus_product_profile
(
  product        varchar2 (30) not null,
  userid         varchar2 (30),
  attribute      varchar2 (240),
  scope          varchar2 (240),
  numeric_value  decimal (15,2),
  char_value     varchar2 (240),
  date_value     date,
  long_value     long
);

rem
rem  Remove SQL*Plus V3 name for sqlplus_product_profile
rem
drop table product_profile;


rem  +------------------------------------------------------------------+
rem  |  Create the view PRODUCT_PRIVS and grant access to that  |
rem  +------------------------------------------------------------------+

drop view product_privs;
create view product_privs as
  select product, userid, attribute, scope,
         numeric_value, char_value, date_value, long_value
  from sqlplus_product_profile
  where userid = 'PUBLIC' or user like userid;

grant select on product_privs to public;
drop public synonym product_profile;
create public synonym product_profile for system.product_privs;
drop synonym product_user_profile;
create synonym product_user_profile for system.sqlplus_product_profile;
drop public synonym product_user_profile;
create public synonym product_user_profile for system.product_privs;

rem  +--------------------+
rem  |  End of pupbld.sql |
rem  +--------------------+
