import oracle.xml.classgen.*;
import oracle.xml.parser.v2.*;

public class TestWidl
{
   public static void main (String args[]) 
   {
      try 
      {
         WIDL w1 = new WIDL();
         DTD dtd = w1.getDTDNode();

         w1.setNAME("WIDL1");
         w1.setVERSION(WIDL.VERSION_1_0);
         
         SERVICE s1 = new SERVICE("Service1", "Service_URL");
         s1.setINPUT("File");
         s1.setOUTPUT("File");

         BINDING b1 = new BINDING("Binding1");
         b1.setTYPE(BINDING.TYPE_INPUT);

         BINDING b2 = new BINDING("Binding2");
         b2.setTYPE(BINDING.TYPE_OUTPUT);

         VARIABLE v1 = new VARIABLE("Variable1", VARIABLE.NULLOK_FALSE);
         v1.setTYPE(VARIABLE.TYPE_STRING);
         v1.setUSAGE(VARIABLE.USAGE_INTERNAL);
         v1.setVALUE("value");

         VARIABLE v2 = new VARIABLE("Variable2", VARIABLE.NULLOK_TRUE);
         v2.setTYPE(VARIABLE.TYPE_STRING1);
         v2.setUSAGE(VARIABLE.USAGE_HEADER);

         VARIABLE v3 = new VARIABLE("Variable3", VARIABLE.NULLOK_FALSE);
         v3.setTYPE(VARIABLE.TYPE_STRING2);
         v3.setUSAGE(VARIABLE.USAGE_FUNCTION);
         v3.setMASK("mask");

         CONDITION c1 = new CONDITION("CRef1", "CMatch1");
         c1.setSERVICE("Service1");
         c1.setTYPE(CONDITION.TYPE_SUCCESS);

         CONDITION c2 = new CONDITION("CRef2", "CMatch2");
         c2.setTYPE(CONDITION.TYPE_RETRY);

         CONDITION c3 = new CONDITION("CRef3", "CMatch3");
         c3.setSERVICE("Service3");
         c3.setTYPE(CONDITION.TYPE_FAILURE);

         REGION r1 = new REGION("Region1", "Start", "End");


         b1.addNode(r1);
         b1.addNode(v1);
         b1.addNode(c1);
         b1.addNode(v2);

         b2.addNode(c2);
         b2.addNode(v3);

         w1.addNode(s1);
         w1.addNode(b1);
         w1.addNode(b2);

         w1.validateContent();
         w1.print(System.out);
      }
      catch (Exception e)
      {
         System.out.println(e.toString());
         e.printStackTrace();
      }
   }
}
