
/**Installer for module  */
package oracle.jaccelerator.server;

import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ResourceHandle;

import java.io.*;
import java.util.Date;
import java.sql.*;
import oracle.jdbc.driver.*;


/** 
 * Little SQL helpers
 */
public class SQL {

  public static String makeValues (String[] values) {
    return makeValues(values, " (", ") ", "'", ", ");
  }

  public static String makeColumns (String[] values) {
    return makeValues(values, " (", ") ", "", ", ");
  }

  static String makeValues (String[] values, String begin, String end, String wrapper, String separator) {
    int length = values.length;
    StringBuffer result = new StringBuffer(begin);
    for (int i = 0; i < length; i++) {
      if (i > 0) result.append(separator);
      result.append(wrapper);
      result.append(values[i]);
      result.append(wrapper);
    }
    result.append(end);

    return result.toString();
  }

  public static String makeVarchar2Column (String name, int length) {
    return name + " VARCHAR2(" + length + ")";
  }

  static String makeBinopExpr (String op, String lhs, String rhs) {
    return " (" + lhs + " " + op + " " + rhs + ") ";
  }

  static String makeBinopValueExpr (String op, String lhs, String value) {
    return makeBinopExpr(op, lhs, "'" + value + "'");
  }

  public static String makeEqlValueExpr (String lhs, String value) {
    return makeBinopValueExpr("=", lhs, value);
  }

  public static String makeLikeValueExpr (String lhs, String value) {
    return makeBinopValueExpr("like", lhs, value);
  }

}

