/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;

public class AQOracleAdmin {
    private AQOracleAdmin() {
    }

    public static void grantSystemPrivilege(AQSession aq_sess, String privilege, String grantee) throws AQException {
        AQOracleAdmin.grantSystemPrivilege(aq_sess, privilege, grantee, false);
    }

    public static void grantSystemPrivilege(AQSession aq_sess, String privilege, String grantee, boolean admin_option) throws AQException {
        Connection db_conn = null;
        Statement grant_stmt = null;
        String admin_flag = "false";
        try {
            try {
                db_conn = ((AQOracleSession)aq_sess).getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(194);
            }
            if (admin_option) {
                admin_flag = "true";
            }
            grant_stmt = db_conn.prepareCall("begin dbms_aqadm.grant_system_privilege(privilege => ?, grantee => ?, admin_option => " + admin_flag + "); end;");
            grant_stmt.setString(1, privilege);
            grant_stmt.setString(2, grantee);
            grant_stmt.execute();
            try {
                grant_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                grant_stmt.close();
            }
            catch (Exception exception) {}
            AQOracleDebug.traceEx(3, "AQOracleAdmin.grantSystemPrivilege", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public static void revokeSystemPrivilege(AQSession aq_sess, String privilege, String grantee) throws AQException {
        Connection db_conn = null;
        Statement revoke_stmt = null;
        try {
            try {
                db_conn = ((AQOracleSession)aq_sess).getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(194);
            }
            revoke_stmt = db_conn.prepareCall("begin dbms_aqadm.revoke_system_privilege(privilege => ?, grantee => ?); end;");
            revoke_stmt.setString(1, privilege);
            revoke_stmt.setString(2, grantee);
            revoke_stmt.execute();
            try {
                revoke_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            try {
                revoke_stmt.close();
            }
            catch (Exception exception) {}
            AQOracleDebug.traceEx(3, "AQOracleAdmin.revokeSystemPrivilege", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }
}

