/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.sql.BLOB;
import oracle.sql.CustomDatumFactory;

public class AQjmsBytesMessage
extends AQjmsMessage
implements BytesMessage {
    byte[] bytes_data;
    AQjmsBytesMessage_C bytes_msg_cont;
    ByteArrayInputStream bytes_instream;
    DataInputStream bytes_datainstream;
    ByteArrayOutputStream bytes_outstream;
    DataOutputStream bytes_dataoutstream;

    AQjmsBytesMessage() throws JMSException {
        this.bytes_data = null;
        try {
            this.bytes_msg_cont = new AQjmsBytesMessage_C();
            this.bytes_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsBytesMessage(AQjmsBytesMessage_C msg_cont) throws JMSException {
        this.bytes_data = null;
        try {
            this.bytes_msg_cont = msg_cont;
            this.header_ext = this.bytes_msg_cont.getHeader();
            this.readBytesMessageContainer();
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_datainstream = new DataInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsBytesMessage(byte[] bdata) throws JMSException {
        this.bytes_data = bdata;
        this.bytes_instream = new ByteArrayInputStream(bdata);
        this.bytes_datainstream = new DataInputStream(this.bytes_instream);
        this.bytes_outstream = new ByteArrayOutputStream();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
        this.access_mode = 0;
    }

    public void clearBody() throws JMSException {
        this.bytes_data = null;
        this.setAccessMode(1);
        this.setPropReadOnly(false);
        this.bytes_outstream.reset();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.bytes_msg_cont != null) {
                this.bytes_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    byte[] getBytesData() {
        if (this.bytes_data == null) {
            this.bytes_data = this.bytes_outstream.toByteArray();
        }
        return this.bytes_data;
    }

    AQjmsBytesMessage_C getBytesMessageCont() {
        return this.bytes_msg_cont;
    }

    void populateBytesMessageContainer() throws JMSException {
        Object bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.populateBytesMessageContainer", "entry");
        try {
            this.bytes_msg_cont.setHeader(this.header_ext);
            b_data = this.getBytesData();
            bytes_len = this.bytes_data.length;
            this.reset();
            this.bytes_msg_cont.setBytesLen(new Integer(bytes_len));
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.populateBytesMessageContainer", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                this.bytes_msg_cont.setBytesRaw(null);
            } else {
                this.bytes_msg_cont.setBytesRaw(b_data);
                this.bytes_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.populateBytesMessageContainer", "exit");
    }

    public boolean readBoolean() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return false;
        }
        try {
            return this.bytes_datainstream.readBoolean();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return false;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return false;
        }
    }

    public byte readByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readByte();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.read(value, 0, value.length);
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return -1;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.read(value, 0, length);
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return -1;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    void readBytesMessageContainer() throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.readBytesMessageContainer", "entry");
        try {
            bytes_len = this.bytes_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.readBytesMessageContainer", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                bytes_lob = this.bytes_msg_cont.getBytesLob();
                if (bytes_lob != null) {
                    b_data = bytes_lob.getBytes(1L, bytes_len);
                }
                this.bytes_data = b_data;
            } else {
                b_data = this.bytes_msg_cont.getBytesRaw();
                this.bytes_data = b_data;
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.readBytesMessageContainer", "exit");
    }

    public char readChar() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return '\u0000';
        }
        try {
            return this.bytes_datainstream.readChar();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return '\u0000';
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return '\u0000';
        }
    }

    public double readDouble() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0;
        }
        try {
            return this.bytes_datainstream.readDouble();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0.0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0.0;
        }
    }

    public float readFloat() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0f;
        }
        try {
            return this.bytes_datainstream.readFloat();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0.0f;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0.0f;
        }
    }

    public int readInt() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readInt();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public long readLong() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        try {
            return this.bytes_datainstream.readLong();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0L;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0L;
        }
    }

    public short readShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readShort();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public String readUTF() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        try {
            return this.bytes_datainstream.readUTF();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return null;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return null;
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readUnsignedByte();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readUnsignedShort();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
            return 0;
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, io_ex.getMessage());
            return 0;
        }
    }

    public void reset() throws JMSException {
        byte[] bdata = null;
        bdata = this.getBytesData();
        this.setAccessMode(0);
        this.setPropReadOnly(true);
        this.bytes_instream = new ByteArrayInputStream(bdata);
        this.bytes_datainstream = new DataInputStream(this.bytes_instream);
        this.bytes_outstream.reset();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeBoolean(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeByte(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.write(value, 0, value.length);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.write(value, offset, length);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeChar(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeDouble(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeFloat(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeInt(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeLong(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(((String)value).toString());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeShort(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeUTF(value);
            }
            catch (IOException io_ex) {
                AQjmsError.throwEx(157, io_ex.getMessage());
            }
        }
    }

    void write_blob(Connection db_conn, String q_table, byte[] msg_id) throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        int b_len = 0;
        OracleCallableStatement blob_stmt = null;
        ResultSet rset = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.write_blob", "entry");
        try {
            b_data = this.getBytesData();
            bytes_len = b_data.length;
            if (q_table == null) {
                AQjmsOracleDebug.trace(1, "AQjmsBytesMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.write_blob", "- bytes_len: " + bytes_len + "   qtable: " + q_table);
            if (bytes_len > 2000) {
                CustomDatumFactory payload_fact = AQjmsBytesMessage_C.getFactory();
                blob_stmt = (OracleCallableStatement)db_conn.prepareCall("SELECT user_data FROM " + q_table + " where msgid = ?");
                blob_stmt.setBytes(1, msg_id);
                rset = blob_stmt.executeQuery();
                if (rset.next()) {
                    AQjmsBytesMessage_C bytes_msg_c = (AQjmsBytesMessage_C)((OracleResultSet)rset).getCustomDatum(1, payload_fact);
                    bytes_lob = bytes_msg_c.getBytesLob();
                }
                if (bytes_lob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsBytesMessage.write_blob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                b_len = bytes_lob.putBytes(1L, b_data);
                try {
                    blob_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sql_ex) {
            try {
                if (blob_stmt != null) {
                    blob_stmt.close();
                }
            }
            catch (Exception exception) {}
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.write_blob", "exit");
    }
}

