/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsDeqSelConstants;
import oracle.jms.AQjmsDeqSelTokenManager;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.ASCII_CharStream;
import oracle.jms.ParseException;
import oracle.jms.Token;

class AQjmsDeqSel
implements AQjmsDeqSelConstants {
    public byte[] msg_id = null;
    public String corr_id = null;
    public AQjmsDeqSelTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[2];
    private final int[] jj_la1_0 = new int[]{96, 0x100080};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public AQjmsDeqSel(InputStream stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new AQjmsDeqSelTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public AQjmsDeqSel(Reader stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new AQjmsDeqSelTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public AQjmsDeqSel(AQjmsDeqSelTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public final String DequeueCorrelationID() throws ParseException {
        String rs = new String("");
        Token tok = null;
        this.jj_consume_token(6);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        tok = this.jj_consume_token(17);
        this.setCorrelationID(tok);
        return "JMSCorrelationID";
    }

    public final String DequeueMessageID() throws ParseException {
        String rs = new String("");
        Token tok = null;
        this.jj_consume_token(5);
        this.jj_consume_token(20);
        tok = this.jj_consume_token(17);
        this.setMessageID(tok);
        return "JMSMessageID";
    }

    public final String DequeueSelector() throws ParseException {
        String rs = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                rs = this.DequeueMessageID();
                break;
            }
            case 6: {
                rs = this.DequeueCorrelationID();
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("DequeueSelector: \n" + rs);
        return rs;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(AQjmsDeqSelTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 2) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    String checkForEscapeChars(String quoted_input) {
        int start_idx = 0;
        int idx = 0;
        boolean str_len = false;
        boolean retry = true;
        StringBuffer sbuf = new StringBuffer();
        String input = null;
        String new_str = null;
        AQjmsOracleDebug.trace(5, "AQjmsDeqSel.checkForEscapeChars", "QuotedInput:  " + quoted_input);
        if (quoted_input == null || quoted_input.length() <= 2) {
            return quoted_input;
        }
        input = quoted_input.substring(1, quoted_input.length() - 1);
        sbuf.append("'");
        if (input != null && input.length() > 0) {
            while (retry) {
                idx = input.indexOf("\\", start_idx);
                if (idx == -1) {
                    retry = false;
                    if (start_idx == 0) {
                        sbuf.append(input);
                        continue;
                    }
                    sbuf.append(input.substring(start_idx));
                    continue;
                }
                if (idx < input.length() - 1 && input.charAt(idx + 1) == '\'') {
                    sbuf.append(input.substring(start_idx, idx));
                    sbuf.append("'");
                    sbuf.append(input.charAt(idx + 1));
                    start_idx = idx + 2;
                } else {
                    sbuf.append(input.substring(start_idx, idx + 1));
                    start_idx = idx + 1;
                }
                retry = start_idx < input.length();
            }
        } else {
            sbuf.append(input);
        }
        sbuf.append("'");
        new_str = sbuf.toString();
        AQjmsOracleDebug.trace(5, "AQjmsDeqSel.checkForEscapeChars", "New String:  " + new_str);
        return new_str;
    }

    public final void disable_tracing() {
    }

    public final void enable_tracing() {
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[21];
        int i = 0;
        while (i < 21) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 2) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 21) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, AQjmsDeqSelConstants.tokenImage);
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public static void main(String[] args) throws ParseException {
        AQjmsDeqSel p = null;
        String expr = null;
        if (args.length < 1) {
            System.out.println("Reading from stdin");
            p = new AQjmsDeqSel(System.in);
        } else {
            try {
                p = new AQjmsDeqSel(new DataInputStream(new FileInputStream(args[0])));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File " + args[0] + " not found. Reading from stdin");
                p = new AQjmsDeqSel(System.in);
            }
        }
        if (args.length > 0) {
            System.out.println("Reading from file: " + args[0]);
        }
        expr = p.DequeueSelector();
        System.out.println("Parse Successful");
        if (expr.equals("JMSCorrelationID")) {
            System.out.println("Expression: " + expr + " " + p.corr_id);
        }
        if (expr.equals("JMSMessageID")) {
            System.out.println("Expression: " + expr + " " + p.msg_id);
        }
    }

    void setCorrelationID(Token tok) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setCorrelationID - entry");
        String old_corr_id_str = tok.image;
        String corr_id_str = this.checkForEscapeChars(old_corr_id_str);
        corr_id_str = corr_id_str.substring(1, corr_id_str.length() - 1);
        AQjmsOracleDebug.println("AQjmsDeqSel.MessageID:" + corr_id_str);
        this.corr_id = corr_id_str;
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setCorrelationID - exit");
    }

    void setMessageID(Token tok) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setMessageID - entry");
        String msg_id_str = tok.image;
        msg_id_str = msg_id_str.substring(1, msg_id_str.length() - 1);
        AQjmsOracleDebug.println("AQjmsDeqSel.MessageID:" + msg_id_str);
        if (!msg_id_str.startsWith("ID:")) {
            AQjmsOracleDebug.trace(3, "AQjmsDeqSel", "setMessageID - parse exception");
            throw new ParseException("Invalid JMSMessageID in selector");
        }
        msg_id_str = msg_id_str.substring(3);
        this.msg_id = RepConversion.nibbles2bArray((byte[])msg_id_str.getBytes());
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setMessageID - exit");
    }
}

