/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.Session;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.sql.CustomDatumFactory;

public class AQjmsQueueBrowser
implements QueueBrowser,
Enumeration {
    QueueReceiver receiver;
    byte[] next_msg_id;
    int dequeue_mode;
    int browse_counter;
    boolean sel_msgid_flag = false;
    AQjmsSession jms_sess;
    AQjmsSelector b_selector;
    AQjmsDestination jms_dest;
    AQjmsMessage msg = null;
    AQjmsMessage new_msg = null;

    AQjmsQueueBrowser(Session session, Destination destination, int dest_type, int deq_mode, String consumer_name, AQjmsSelector selector, CustomDatumFactory payload_factory) throws JMSException {
        this.jms_sess = (AQjmsSession)session;
        this.dequeue_mode = deq_mode;
        this.jms_dest = (AQjmsDestination)destination;
        this.b_selector = selector;
        this.receiver = new AQjmsConsumer(this.jms_sess, destination, dest_type, deq_mode, consumer_name, payload_factory, selector);
    }

    public void close() {
        try {
            AQjmsOracleDebug.trace(5, "AQjmsQueueBrowser.close", "closing receiver");
            this.receiver.close();
        }
        catch (Exception exception) {}
        try {
            AQjmsOracleDebug.trace(5, "AQjmsQueueBrowser.close", "closing the browser");
            this.jms_sess.closeQueueBrowser(this.jms_dest.getCompleteName());
        }
        catch (Exception exception) {}
    }

    public Enumeration getEnumeration() throws JMSException {
        return this;
    }

    public String getMessageSelector() throws JMSException {
        return this.receiver.getMessageSelector();
    }

    public Queue getQueue() throws JMSException {
        if (this.jms_dest != null) {
            return this.jms_dest;
        }
        AQjmsError.throwEx(143);
        return null;
    }

    public boolean hasMoreElements() {
        if (this.sel_msgid_flag) {
            AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "null message returned from receive-deq by msgid");
            return false;
        }
        if (this.msg != null) {
            AQjmsOracleDebug.trace(5, "AQjmsQueueBrowser.hasMoreElements", "message already exists");
            return true;
        }
        try {
            this.msg = (AQjmsMessage)this.receiver.receiveNoWait();
            if (this.msg == null) {
                AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "null message returned from receive");
                return false;
            }
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.hasMoreElements - no message", (Exception)((Object)ex));
            return false;
        }
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "received message");
        if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
            this.sel_msgid_flag = true;
        }
        return true;
    }

    public Object nextElement() throws NoSuchElementException {
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "entry");
        try {
            if (this.msg != null) {
                this.new_msg = this.msg;
                this.msg = null;
            } else {
                if (this.sel_msgid_flag) {
                    AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "no such element exception - deq by msgid");
                    throw new NoSuchElementException();
                }
                this.new_msg = (AQjmsMessage)this.receiver.receiveNoWait();
                if (this.new_msg == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsQueueBrowser.nextElement", "No such element exception");
                    throw new NoSuchElementException();
                }
            }
            AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "exit");
            if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
                this.sel_msgid_flag = true;
            }
            return this.new_msg;
        }
        catch (JMSException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.nextElement", (Exception)((Object)aq_ex));
            throw new NoSuchElementException();
        }
    }
}

