/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandler;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLDocHandler;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPageRequest;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XSQLActionHandlerImpl
implements XSQLActionHandler {
    private static String XSQL_ERROR_ELT = "xsql-error";
    private static String XSQL_STATUS_ELT = "xsql-status";
    private static String XSQL_ACTION_ATTR = "action";
    private static String XSQL_MESSAGE_ELT = "message";
    private static String XSQL_STMT_ELT = "statement";
    private XSQLPageRequest env = null;
    private XMLElement actionElement = null;

    protected XSQLPageRequest getPageRequest() {
        return this.env;
    }

    protected Element getActionElement() {
        return this.actionElement;
    }

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        this.env = xSQLPageRequest;
        this.actionElement = (XMLElement)element;
        element.normalize();
    }

    protected void reportFatalError(String string) throws SQLException {
        XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(string, this.env);
        xSQLErrorWriter.print();
        throw new SQLException();
    }

    protected void reportErrorIncludingStatement(Node node, String string, String string2) {
        node.appendChild(this.makeErrorElement(string2, string));
    }

    protected void addResultElement(Node node, String string, String string2) {
        Document document = this.actionElement.getOwnerDocument();
        Element element = null;
        try {
            element = document.createElement(string);
            if (string2 != null) {
                Text text = document.createTextNode(string2);
                element.appendChild(text);
            }
            node.appendChild(element);
        }
        catch (DOMException dOMException) {
            this.reportError(node, String.valueOf(String.valueOf("Result element name '").concat(String.valueOf(string))).concat(String.valueOf("' is not a valid XML Element name.")));
        }
    }

    protected boolean requiredConnectionProvided(Node node) {
        if (this.getPageRequest().getJDBCConnection() == null) {
            this.reportError(node, "No connection attribute specified on document element.");
            return false;
        }
        return true;
    }

    protected int getDefaultFetchSize() {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        return xSQLConfigManager.getDefaultRowPrefetch();
    }

    protected void reportError(Node node, String string) {
        node.appendChild(this.makeErrorElement(string, null));
    }

    protected void reportMissingAttribute(Node node, String string) {
        node.appendChild(this.makeErrorElement(Res.format(20, string), null));
    }

    protected void reportStatus(Node node, String string, String string2) {
        node.appendChild(this.makeStatusElement(string, string2));
    }

    private Element makeStatusElement(String string, String string2) {
        Document document = this.actionElement.getOwnerDocument();
        Element element = document.createElement(XSQL_STATUS_ELT);
        element.setAttribute(XSQL_ACTION_ATTR, String.valueOf("xsql:").concat(String.valueOf(this.actionElement.getLocalName())));
        if (string != null) {
            element.setAttribute(string, string2 != null ? string2 : "");
        }
        return element;
    }

    private Element makeErrorElement(String string, String string2) {
        Text text;
        Element element;
        Document document = this.actionElement.getOwnerDocument();
        Element element2 = document.createElement(XSQL_ERROR_ELT);
        element2.setAttribute(XSQL_ACTION_ATTR, String.valueOf("xsql:").concat(String.valueOf(this.actionElement.getLocalName())));
        if (string2 != null) {
            element = document.createElement(XSQL_STMT_ELT);
            text = document.createTextNode(string2);
            element.appendChild(text);
            element2.appendChild(element);
        }
        if (string != null) {
            element = document.createElement(XSQL_MESSAGE_ELT);
            text = document.createTextNode(string);
            element.appendChild(text);
            element2.appendChild(element);
        }
        return element2;
    }

    protected String getAttributeAllowingParam(String string, Element element) {
        Attr attr = (Attr)element.getAttributes().getNamedItem(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string2.indexOf("{@")) >= 0 && (n2 = string2.indexOf("}", n)) != 0) {
            string3 = string2.substring(n + 2, n2);
            string2 = String.valueOf(String.valueOf(string2.substring(0, n)).concat(String.valueOf(this.variableValue(string3, element, string)))).concat(String.valueOf(string2.substring(n2 + 1)));
        }
        return string2;
    }

    protected String getAttribute(String string, Element element) {
        Attr attr = (Attr)element.getAttributes().getNamedItem(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    protected String variableValue(String string, Element element) {
        return this.variableValue(string, element, null);
    }

    private String variableValue(String string, Element element, String string2) {
        Object object;
        String string3 = this.env.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        Element element2 = element;
        if (string2 != null && string.equals(string2)) {
            object = element.getParentNode();
            if (object instanceof Document) {
                return "";
            }
            element2 = (Element)object;
        }
        while (true) {
            String string4;
            if ((string3 = (string4 = (object = (XMLElement)element2).getNamespace()).equals(XSQLDocHandler.XSQL_NS_URI) ? this.getAttributeAllowingParam(string, element2) : this.getAttribute(string, element2)) != null) {
                return string3;
            }
            Node node = element2.getParentNode();
            if (node instanceof Document) break;
            element2 = (Element)node;
        }
        return "";
    }

    protected String getActionElementContent() {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        string = this.valueOfFirstNonEmptyTextNodeChildOf((Element)this.actionElement);
        while ((n = string.indexOf("{@")) >= 0 && (n2 = string.indexOf("}", n)) != 0) {
            string2 = string.substring(n + 2, n2);
            string = String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf(this.variableValue(string2, (Element)this.actionElement)))).concat(String.valueOf(string.substring(n2 + 1)));
        }
        return string;
    }

    protected String firstColumnOfFirstRow(Node node, String string) {
        ResultSet resultSet = null;
        Statement statement = null;
        if (string != null && !string.equals("")) {
            if (!this.requiredConnectionProvided(node)) {
                return null;
            }
            try {
                String string2 = null;
                statement = this.getPageRequest().getJDBCConnection().createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                resultSet.close();
                statement.close();
                String string3 = string2 != null ? string2 : "";
                return string3;
            }
            catch (SQLException sQLException) {
                this.reportErrorIncludingStatement(node, string, sQLException.getMessage());
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    statement.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String valueOfFirstNonEmptyTextNodeChildOf(Element element) {
        Node node = element.getFirstChild();
        if (node == null) {
            return "";
        }
        do {
            String string;
            short s;
            if ((s = node.getNodeType()) != 3 && s != 4 || (string = node.getNodeValue().trim()) == null || string.equals("")) continue;
            return string;
        } while ((node = node.getNextSibling()) != null);
        return "";
    }

    public abstract void handleAction(Node var1) throws SQLException;
}

