/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLNamedConnection;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class XSQLConfigManager {
    private static final String CONFIG_FILE_NAME = "/XSQLConfig.xml";
    private Hashtable namedConnections = new Hashtable(5);
    private Hashtable userDefinedHandlers = new Hashtable(5);
    private Hashtable noCharsetMimeTypes = new Hashtable(5);
    private boolean dumpPoolAllowed = false;
    private Integer xsqlResultFragmentCacheSize = new Integer(40);
    private Integer xsqlPageCacheSize = new Integer(20);
    private Integer stylesheetPageCacheSize = new Integer(20);
    private Integer stylesheetPoolInitial = new Integer(1);
    private Integer stylesheetPoolIncrement = new Integer(1);
    private Integer stylesheetPoolTimeout = new Integer(60);
    private Integer connectionPoolInitial = new Integer(1);
    private Integer connectionPoolIncrement = new Integer(1);
    private Integer outputBufferSize = new Integer(0);
    private Integer connectionPoolTimeout = new Integer(60);
    private Integer defaultRowPrefetch = new Integer(50);
    private Boolean reloadConfigFileOnError = null;
    private boolean pageTiming = false;
    private boolean actionTiming = false;
    private static boolean loadedConfig = false;
    private static XSQLConfigManager xcm = null;

    public boolean pageTimingInfo() {
        return this.pageTiming;
    }

    public boolean actionTimingInfo() {
        return this.actionTiming;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getDefaultRowPrefetch() {
        return this.defaultRowPrefetch;
    }

    public int getConnectionPoolTimeout() {
        return this.connectionPoolTimeout * 1000;
    }

    public int getConnectionPoolInitial() {
        return this.connectionPoolInitial;
    }

    public int getConnectionPoolIncrement() {
        return this.connectionPoolIncrement;
    }

    public int getStylesheetPoolTimeout() {
        return this.stylesheetPoolTimeout * 1000;
    }

    public int getStylesheetPoolInitial() {
        return this.stylesheetPoolInitial;
    }

    public int getStylesheetPoolIncrement() {
        return this.stylesheetPoolIncrement;
    }

    public int getXSQLPageCacheSize() {
        return this.xsqlPageCacheSize;
    }

    public int getXSQLResultFragmentCacheSize() {
        return this.xsqlResultFragmentCacheSize;
    }

    public int getStylesheetPageCacheSize() {
        return this.stylesheetPageCacheSize;
    }

    public static XSQLConfigManager getManager() {
        if (xcm == null) {
            xcm = new XSQLConfigManager();
        }
        return xcm;
    }

    public static void insureConfigurationIsLoaded(XSQLPageRequest xSQLPageRequest) {
        if (!loadedConfig) {
            XSQLConfigManager.getManager().reloadConfigFile(xSQLPageRequest);
        }
    }

    public boolean dumpPoolAllowed() {
        return this.dumpPoolAllowed;
    }

    public boolean ignoreCharsetForMime(String string) {
        return this.noCharsetMimeTypes.get(string) != null;
    }

    public Hashtable getNamedConnections() {
        return this.namedConnections;
    }

    public XSQLNamedConnection getNamedConnection(XSQLPageRequest xSQLPageRequest, String string) {
        XSQLNamedConnection xSQLNamedConnection = (XSQLNamedConnection)this.namedConnections.get(string);
        if (xSQLNamedConnection == null && (this.reloadConfigFileOnError.equals(Boolean.TRUE) || !loadedConfig)) {
            this.reloadConfigFile(xSQLPageRequest);
        }
        return (XSQLNamedConnection)this.namedConnections.get(string);
    }

    public Hashtable getUserDefinedHandlers() {
        return this.userDefinedHandlers;
    }

    private XSQLConfigManager() {
    }

    private synchronized void reloadConfigFile(XSQLPageRequest xSQLPageRequest) {
        Object object;
        Object object2;
        loadedConfig = true;
        Document document = null;
        Object var3_3 = null;
        try {
            object2 = this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
            if (object2 == null) {
                throw new Exception(null);
            }
            object = new BufferedInputStream((InputStream)object2);
            document = XSQLParserHelper.parse((InputStream)object, null, xSQLPageRequest.getErrorWriter());
            ((BufferedInputStream)object).close();
        }
        catch (Exception exception) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(3), xSQLPageRequest);
            xSQLErrorWriter.print();
            return;
        }
        object2 = new Hashtable(5);
        if (document != null) {
            NodeList nodeList;
            String string;
            Object object3;
            Object object4;
            XSQLNamedConnection xSQLNamedConnection;
            String string2;
            String string3;
            Object object5;
            Object object6;
            Hashtable hashtable;
            Properties properties;
            String string4;
            String string5;
            Object object7;
            Integer n;
            object = XSQLUtil.valueOf(document, "/XSQLConfig/processor/reload-connections-on-error");
            this.reloadConfigFileOnError = new Boolean(((String)object).equalsIgnoreCase("yes"));
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/result-cache-size"));
                object7 = this.xsqlResultFragmentCacheSize;
                synchronized (object7) {
                    try {
                        this.xsqlResultFragmentCacheSize = n;
                        string5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_20 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/page-cache-size"));
                object7 = this.xsqlPageCacheSize;
                synchronized (object7) {
                    try {
                        this.xsqlPageCacheSize = n;
                        string4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_26 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-cache-size"));
                object7 = this.stylesheetPageCacheSize;
                synchronized (object7) {
                    try {
                        this.stylesheetPageCacheSize = n;
                        properties = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_30 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/initial"));
                object7 = this.stylesheetPoolInitial;
                synchronized (object7) {
                    try {
                        this.stylesheetPoolInitial = n;
                        hashtable = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_34 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/increment"));
                object7 = this.stylesheetPoolIncrement;
                synchronized (object7) {
                    try {
                        this.stylesheetPoolIncrement = n;
                        object6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_41 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/timeout-seconds"));
                object7 = this.stylesheetPoolTimeout;
                synchronized (object7) {
                    try {
                        this.stylesheetPoolTimeout = n;
                        object5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_50 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/initial"));
                object7 = this.connectionPoolInitial;
                synchronized (object7) {
                    try {
                        this.connectionPoolInitial = n;
                        string3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_55 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/increment"));
                object7 = this.stylesheetPoolIncrement;
                synchronized (object7) {
                    try {
                        this.connectionPoolIncrement = n;
                        string2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_59 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/timeout-seconds"));
                object7 = this.connectionPoolTimeout;
                synchronized (object7) {
                    try {
                        this.connectionPoolTimeout = n;
                        xSQLNamedConnection = null;
                    }
                    catch (Throwable throwable) {
                        Object var25_63 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object7 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/dumpallowed");
            this.dumpPoolAllowed = ((String)object7).equalsIgnoreCase("yes");
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/default-fetch-size"));
                object4 = this.defaultRowPrefetch;
                synchronized (object4) {
                    try {
                        this.defaultRowPrefetch = n;
                        Object var27_66 = null;
                    }
                    catch (Throwable throwable) {
                        Object var27_67 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/servlet/output-buffer-size"));
                object4 = this.outputBufferSize;
                synchronized (object4) {
                    try {
                        this.outputBufferSize = n;
                        Object var29_69 = null;
                    }
                    catch (Throwable throwable) {
                        Object var29_70 = null;
                        throw throwable;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object4 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/action");
            string5 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/page");
            this.actionTiming = object4 != null && (((String)object4).equalsIgnoreCase("y") || ((String)object4).equalsIgnoreCase("yes"));
            this.pageTiming = string5 != null && (string5.equalsIgnoreCase("y") || string5.equalsIgnoreCase("yes"));
            XMLNode xMLNode = (XMLNode)document;
            string4 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyhost");
            if (string4 != null && !xMLNode.equals("")) {
                object3 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyport");
                if (((String)object3).equals("")) {
                    object3 = "80";
                }
                Properties properties2 = properties = System.getProperties();
                synchronized (properties2) {
                    try {
                        ((Hashtable)properties).put("proxySet", "true");
                        ((Hashtable)properties).put("proxyHost", string4);
                        ((Hashtable)properties).put("proxyPort", object3);
                        Object var31_72 = null;
                    }
                    catch (Throwable throwable) {
                        Object var31_73 = null;
                        throw throwable;
                    }
                }
            }
            object3 = XSQLUtil.select(document, "/XSQLConfig/servlet/suppress-mime-charset/media-type");
            properties = new Hashtable(5);
            if (object3 != null && object3.getLength() > 0) {
                int n2 = object3.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    Element element = (Element)object3.item(n3);
                    element.normalize();
                    object6 = element.getFirstChild().getNodeValue();
                    ((Hashtable)properties).put(object6, object6);
                    ++n3;
                }
                hashtable = this.noCharsetMimeTypes;
                synchronized (hashtable) {
                    try {
                        this.noCharsetMimeTypes = properties;
                        Object var33_75 = null;
                    }
                    catch (Throwable throwable) {
                        Object var33_76 = null;
                        throw throwable;
                    }
                }
            }
            NodeList nodeList2 = XSQLUtil.select(document, "/XSQLConfig/actiondefs/action");
            hashtable = new Hashtable(10);
            if (nodeList2 != null && nodeList2.getLength() > 0) {
                int n4 = nodeList2.getLength();
                int n5 = 0;
                while (n5 < n4) {
                    Element element = (Element)nodeList2.item(n5);
                    object5 = XSQLUtil.valueOf(element, "elementname");
                    string = XSQLUtil.valueOf(element, "handlerclass");
                    hashtable.put(object5, string);
                    ++n5;
                }
                object6 = this.userDefinedHandlers;
                synchronized (object6) {
                    try {
                        this.userDefinedHandlers = hashtable;
                        Object var35_78 = null;
                    }
                    catch (Throwable throwable) {
                        Object var35_79 = null;
                        throw throwable;
                    }
                }
            }
            if ((nodeList = XSQLUtil.select(document, "/XSQLConfig/connectiondefs/connection")) != null && nodeList.getLength() > 0) {
                int n6 = nodeList.getLength();
                int n7 = 0;
                while (n7 < n6) {
                    object5 = (Element)nodeList.item(n7);
                    string = XSQLUtil.valueOf((Element)object5, "@name");
                    string3 = XSQLUtil.valueOf((Element)object5, "driver");
                    String string6 = XSQLUtil.valueOf((Element)object5, "dburl");
                    string2 = XSQLUtil.valueOf((Element)object5, "username");
                    String string7 = XSQLUtil.valueOf((Element)object5, "password");
                    xSQLNamedConnection = new XSQLNamedConnection(string3, string6, string2, string7);
                    ((Hashtable)object2).put(string, xSQLNamedConnection);
                    ++n7;
                }
            }
            Hashtable hashtable2 = this.namedConnections;
            synchronized (hashtable2) {
                try {
                    this.namedConnections = object2;
                    Object var37_81 = null;
                }
                catch (Throwable throwable) {
                    Object var37_82 = null;
                    throw throwable;
                }
            }
        }
    }
}

