/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xsql.XSQLActionHandler;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLDOMException;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetPI;
import oracle.xml.xsql.actions.XSQLExtensionActionHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

final class XSQLDocHandler {
    public static String XSQL_NS_URI = "urn:oracle-xsql";
    public static String XSQL_ERR_MSG = "message";
    public static String XSQL_ERR_STM = "operation";
    private static String STYLE_PI = "xml-stylesheet";
    private Document XSQLDoc = null;
    private XSQLPageRequest env = null;
    private Vector topLevelPIs = null;
    private XSQLStylesheetPI requestPI = null;
    private String connectionName = null;
    private boolean allowXSLOverride = true;
    private Element firstInsertTag = null;
    private boolean pageTiming = false;
    private boolean actionTiming = false;
    private long cacheSeconds = 0L;
    private static final int NUMBER_OF_HANDLERS = 15;
    private static final String P = "oracle.xml.xsql.actions.XSQL";
    private static final String H = "Handler";
    private static final String QUERY = "query";
    private static final String QUERY_HANDLER = "oracle.xml.xsql.actions.XSQLQueryHandler";
    private static final String PARAM = "include-param";
    private static final String PARAM_HANDLER = "oracle.xml.xsql.actions.XSQLGetParameterHandler";
    private static final String INSREQ = "insert-request";
    private static final String INSREQ_HANDLER = "oracle.xml.xsql.actions.XSQLInsertRequestHandler";
    private static final String DML = "dml";
    private static final String DML_HANDLER = "oracle.xml.xsql.actions.XSQLDMLHandler";
    private static final String ACTION = "action";
    private static final String ACTION_HANDLER = "oracle.xml.xsql.actions.XSQLExtensionActionHandler";
    private static final String SHEETPARAM = "set-stylesheet-param";
    private static final String SHEETPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLStylesheetParameterHandler";
    private static final String INCXML = "include-xml";
    private static final String INCXML_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeXMLHandler";
    private static final String INCOWA = "include-owa";
    private static final String INCOWA_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeOWAHandler";
    private static final String INCXSQL = "include-xsql";
    private static final String INCXSQL_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeXSQLHandler";
    private static final String INCREQ = "include-request-params";
    private static final String INCREQ_HANDLER = "oracle.xml.xsql.actions.XSQLIncludeRequestHandler";
    private static final String PAGEPARAM = "set-page-param";
    private static final String PAGEPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetPageParamHandler";
    private static final String SESSPARAM = "set-session-param";
    private static final String SESSPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetSessionParamHandler";
    private static final String COOKPARAM = "set-cookie";
    private static final String COOKPARAM_HANDLER = "oracle.xml.xsql.actions.XSQLSetCookieHandler";
    private static final String REFCURSOR = "ref-cursor-function";
    private static final String REFCURSOR_HANDLER = "oracle.xml.xsql.actions.XSQLRefCursorFunctionHandler";
    private static final String INS_PARAM = "insert-param";
    private static final String INS_PARAM_HANDLER = "oracle.xml.xsql.actions.XSQLInsertParameterHandler";
    private static Hashtable builtinActions = new Hashtable(15);

    XSQLDocHandler(XSQLPageRequest xSQLPageRequest, XSQLPage xSQLPage, String string, String string2) throws SAXException {
        Object object;
        this.env = xSQLPageRequest;
        this.XSQLDoc = xSQLPage.getDocument();
        Element element = this.XSQLDoc.getDocumentElement();
        if (element != null) {
            object = element.getAttributeNode("connection");
            if (object != null) {
                this.connectionName = this.resolveConnName(element, (Attr)object);
                element.removeAttributeNode((Attr)object);
            }
            if ((object = element.getAttributeNode("cache")) != null) {
                try {
                    long l;
                    this.cacheSeconds = l = Long.parseLong(object.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                element.removeAttributeNode((Attr)object);
            }
            if ((object = element.getAttributeNode("allow-client-style")) != null) {
                String string3 = object.getNodeValue();
                this.allowXSLOverride = !string3.equalsIgnoreCase("n") && !string3.equalsIgnoreCase("no");
                element.removeAttributeNode((Attr)object);
            }
        }
        object = XSQLConfigManager.getManager();
        this.pageTiming = ((XSQLConfigManager)object).pageTimingInfo();
        this.actionTiming = ((XSQLConfigManager)object).actionTimingInfo();
        if (this.allowXSLOverride && string != null && !string.equals("")) {
            this.requestPI = new XSQLStylesheetPI(string, string2);
        }
        if (this.XSQLDoc == null) {
            System.out.println("Error Parsing the Document");
            return;
        }
    }

    Document getDocument() throws SQLException {
        long l = -1L;
        Element element = null;
        if (this.pageTiming) {
            l = System.currentTimeMillis();
        }
        Vector vector = this.getXSQLActions((XMLDocument)this.XSQLDoc);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            XSQLActionHandler xSQLActionHandler;
            element = (Element)vector.elementAt(n2);
            if (element.getOwnerDocument() != null && (xSQLActionHandler = this.handlerForAction(element)) != null) {
                long l2 = -1L;
                if (this.actionTiming) {
                    l2 = System.currentTimeMillis();
                }
                DocumentFragment documentFragment = this.XSQLDoc.createDocumentFragment();
                xSQLActionHandler.handleAction(documentFragment);
                if (this.actionTiming && documentFragment != null) {
                    try {
                        long l3 = System.currentTimeMillis() - l2;
                        Comment comment = this.XSQLDoc.createComment(new Long(l3).toString());
                        documentFragment.insertBefore(comment, documentFragment.getFirstChild());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Node node = element.getParentNode();
                if (node instanceof Document) {
                    node.removeChild(element);
                    if (!documentFragment.hasChildNodes()) {
                        throw new XSQLDOMException("Empty Document");
                    }
                    node.appendChild(documentFragment);
                } else {
                    node.insertBefore(documentFragment, element);
                    node.removeChild(element);
                }
            }
            ++n2;
        }
        this.removeXSQLNamespaces((XMLElement)this.XSQLDoc.getDocumentElement());
        if (this.pageTiming) {
            Element element2;
            long l4 = System.currentTimeMillis() - l;
            if (this.XSQLDoc != null && (element2 = this.XSQLDoc.getDocumentElement()) != null) {
                element2.setAttribute("xsql-timing", new Long(l4).toString());
            }
        }
        return this.XSQLDoc;
    }

    private void removeXSQLNamespaces(XMLElement xMLElement) {
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = namedNodeMap.item(n2);
                if (node.getNodeValue().equals(XSQL_NS_URI)) {
                    xMLElement.removeAttributeNode((Attr)node);
                    --n2;
                    --n;
                }
                ++n2;
            }
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public long getCacheThreshold() {
        return this.cacheSeconds;
    }

    public boolean getAllowClientStyle() {
        return this.allowXSLOverride;
    }

    public Vector getDocumentPIs() {
        if (this.topLevelPIs != null) {
            return this.topLevelPIs;
        }
        this.topLevelPIs = new Vector();
        if (this.requestPI != null) {
            this.topLevelPIs.addElement(this.requestPI);
        }
        NodeList nodeList = this.XSQLDoc.getChildNodes();
        Node node = null;
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (node.getNodeType() == 7 && node.getNodeName().equals(STYLE_PI)) {
                    this.topLevelPIs.addElement(new XSQLStylesheetPI((ProcessingInstruction)node));
                    this.XSQLDoc.removeChild(node);
                    continue;
                }
                ++n;
            }
        }
        return this.topLevelPIs;
    }

    private XSQLActionHandler handlerForAction(Element element) {
        String string = ((XMLElement)element).getLocalName();
        XSQLActionHandler xSQLActionHandler = null;
        boolean bl = true;
        Class clazz = (Class)builtinActions.get(string);
        if (clazz != null) {
            try {
                xSQLActionHandler = (XSQLActionHandler)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            String string2 = (String)XSQLConfigManager.getManager().getUserDefinedHandlers().get(string);
            if (string2 != null && !string2.equals("")) {
                XSQLExtensionActionHandler xSQLExtensionActionHandler = new XSQLExtensionActionHandler();
                xSQLExtensionActionHandler.init(this.env, element);
                xSQLExtensionActionHandler.setHandlerClass(string2);
                bl = false;
                xSQLActionHandler = xSQLExtensionActionHandler;
            }
        }
        if (xSQLActionHandler != null && bl) {
            xSQLActionHandler.init(this.env, element);
            return xSQLActionHandler;
        }
        return xSQLActionHandler;
    }

    private String resolveConnName(Element element, Attr attr) {
        String string = attr.getNodeValue();
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string2.indexOf("{@")) >= 0 && (n2 = string2.indexOf("}", n)) != 0) {
            string3 = string2.substring(n + 2, n2);
            String string4 = this.env.getParameter(string3);
            Attr attr2 = !string3.equals("connection") ? element.getAttributeNode(string3) : null;
            String string5 = null;
            if (string4 != null) {
                string5 = string4;
            } else if (attr2 != null) {
                string5 = attr2.getNodeValue();
            }
            string2 = String.valueOf(String.valueOf(string2.substring(0, n)).concat(String.valueOf(string5 != null ? string5 : ""))).concat(String.valueOf(string2.substring(n2 + 1)));
        }
        return string2;
    }

    private Vector getXSQLActions(XMLDocument xMLDocument) {
        Vector<XMLElement> vector = new Vector<XMLElement>(10);
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        if (xMLElement.getNamespace().equals(XSQL_NS_URI)) {
            vector.addElement(xMLElement);
        }
        this.getXSQLActions(xMLElement, vector);
        return vector;
    }

    private void getXSQLActions(XMLElement xMLElement, Vector vector) {
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)node;
                if (xMLElement2.getNamespace().equals(XSQL_NS_URI)) {
                    vector.addElement(xMLElement2);
                }
                this.getXSQLActions(xMLElement2, vector);
            }
            ++n2;
        }
    }

    private static void register(String string, String string2) {
        try {
            builtinActions.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static {
        XSQLDocHandler.register(QUERY, QUERY_HANDLER);
        XSQLDocHandler.register(PARAM, PARAM_HANDLER);
        XSQLDocHandler.register(INSREQ, INSREQ_HANDLER);
        XSQLDocHandler.register(DML, DML_HANDLER);
        XSQLDocHandler.register(ACTION, ACTION_HANDLER);
        XSQLDocHandler.register(SHEETPARAM, SHEETPARAM_HANDLER);
        XSQLDocHandler.register(INCXML, INCXML_HANDLER);
        XSQLDocHandler.register(INCOWA, INCOWA_HANDLER);
        XSQLDocHandler.register(INCXSQL, INCXSQL_HANDLER);
        XSQLDocHandler.register(INCREQ, INCREQ_HANDLER);
        XSQLDocHandler.register(PAGEPARAM, PAGEPARAM_HANDLER);
        XSQLDocHandler.register(SESSPARAM, SESSPARAM_HANDLER);
        XSQLDocHandler.register(COOKPARAM, COOKPARAM_HANDLER);
        XSQLDocHandler.register(REFCURSOR, REFCURSOR_HANDLER);
        XSQLDocHandler.register(INS_PARAM, INS_PARAM_HANDLER);
    }
}

