/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.util.Hashtable;

final class XSQLLRUCache {
    private int _cacheSize;
    private Hashtable _nodes;
    private int _currentSize = 0;
    private LRUNode _first;
    private LRUNode _last;

    public XSQLLRUCache(int n) {
        this._cacheSize = n;
    }

    public Object get(Object object) {
        if (this._nodes == null) {
            return null;
        }
        LRUNode lRUNode = (LRUNode)this._nodes.get(object);
        if (lRUNode != null) {
            this._moveToHead(lRUNode);
            return lRUNode._value;
        }
        return null;
    }

    public void put(Object object, Object object2) {
        LRUNode lRUNode;
        if (this._nodes == null) {
            this._nodes = new Hashtable(this._cacheSize);
        }
        if ((lRUNode = (LRUNode)this._nodes.get(object)) == null) {
            if (this._currentSize >= this._cacheSize) {
                if (this._last != null) {
                    this._nodes.remove(this._last._key);
                }
                this._removeLast();
            } else {
                ++this._currentSize;
            }
            lRUNode = null.new LRUNode();
        }
        lRUNode._value = object2;
        lRUNode._key = object;
        this._moveToHead(lRUNode);
        this._nodes.put(object, lRUNode);
    }

    public void clear() {
        if (this._nodes != null) {
            this._nodes.clear();
        }
        this._first = null;
        this._last = null;
    }

    private void _removeLast() {
        if (this._last != null) {
            if (this._last._prev != null) {
                this._last._prev._next = null;
            } else {
                this._first = null;
            }
            this._last = this._last._prev;
        }
    }

    private void _moveToHead(LRUNode lRUNode) {
        if (lRUNode == this._first) {
            return;
        }
        if (lRUNode._prev != null) {
            lRUNode._prev._next = lRUNode._next;
        }
        if (lRUNode._next != null) {
            lRUNode._next._prev = lRUNode._prev;
        }
        if (this._last == lRUNode) {
            this._last = lRUNode._prev;
        }
        if (this._first != null) {
            lRUNode._next = this._first;
            this._first._prev = lRUNode;
        }
        this._first = lRUNode;
        lRUNode._prev = null;
        if (this._last == null) {
            this._last = this._first;
        }
    }

    class LRUNode {
        LRUNode _prev;
        LRUNode _next;
        Object _value;
        Object _key;

        LRUNode() {
        }
    }
}

