/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.Enumeration;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLDocHandler;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageManager;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLStylesheetPI;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLPageProcessor {
    public static final String VERSION = "1.0.0.0";
    public static final String STATUS = "Production";
    public static final String DATE = "27-MAR-2000";
    XSQLPage requestedPage = null;
    XSQLPageRequest env = null;
    XSQLConnection conn = null;
    XSQLConnectionManager mgr = null;
    Document XMLDoc = null;
    String connectionName = null;

    public XSQLPageProcessor(XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
    }

    public XSQLPageProcessor(XSQLPage xSQLPage, XSQLPageRequest xSQLPageRequest) {
        this.requestedPage = xSQLPage;
        this.env = xSQLPageRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() throws FileNotFoundException, SAXParseException {
        block26: {
            Object object;
            block25: {
                String string;
                if (this.requestedPage == null) {
                    try {
                        this.requestedPage = XSQLPageManager.getManager().getPage(this.env.getSourceDocumentURI(), this.env);
                        this.env.setPageEncoding(this.requestedPage.getDocument().getEncoding());
                    }
                    catch (SAXParseException sAXParseException) {
                        throw sAXParseException;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw fileNotFoundException;
                    }
                    catch (RuntimeException runtimeException) {
                        XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(17), runtimeException, this.env);
                        xSQLErrorWriter.print();
                        throw runtimeException;
                    }
                }
                XSQLDocHandler xSQLDocHandler = null;
                String string2 = this.env.getUserAgent();
                String string3 = this.env.getParameter("dumppool");
                String string4 = this.env.getParameter("xml-stylesheet");
                String string5 = this.env.getParameter("transform");
                boolean bl = false;
                if (string3 != null && string3.equalsIgnoreCase("y")) {
                    XSQLConnectionManager.getManager().showStatus(this.env);
                    this.env.requestProcessed();
                    return;
                }
                if (string4 != null && string4.equalsIgnoreCase("none")) {
                    bl = true;
                    string4 = "";
                    string5 = "";
                }
                try {
                    xSQLDocHandler = new XSQLDocHandler(this.env, this.requestedPage, string4, string5);
                }
                catch (SAXParseException sAXParseException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(5), sAXParseException, this.env);
                    xSQLErrorWriter.print();
                    this.env.requestProcessed();
                    return;
                }
                catch (SAXException sAXException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(5), this.env);
                    xSQLErrorWriter.print();
                    this.env.requestProcessed();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(17), runtimeException, this.env);
                    xSQLErrorWriter.print();
                    throw runtimeException;
                }
                try {
                    this.env.setConnectionName(xSQLDocHandler.getConnectionName());
                    this.XMLDoc = xSQLDocHandler.getDocument();
                }
                catch (SQLException sQLException) {
                    this.env.requestProcessed();
                    return;
                }
                catch (DOMException dOMException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(14), this.env);
                    xSQLErrorWriter.print();
                    this.env.requestProcessed();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(17), runtimeException, this.env);
                    xSQLErrorWriter.print();
                    this.env.requestProcessed();
                    return;
                }
                Object object2 = null;
                Enumeration enumeration = xSQLDocHandler.getDocumentPIs().elements();
                boolean bl2 = xSQLDocHandler.getAllowClientStyle();
                if (!bl || !bl2) {
                    while (enumeration.hasMoreElements()) {
                        object = (XSQLStylesheetPI)enumeration.nextElement();
                        string = ((XSQLStylesheetPI)object).getType();
                        if (string == null || !string.equals("text/xsl")) continue;
                        String string6 = ((XSQLStylesheetPI)object).getMedia();
                        if (string6 != null && !string6.equals("")) {
                            if (string2.toUpperCase().indexOf(string6.toUpperCase()) < 0) continue;
                            object2 = object;
                            break;
                        }
                        object2 = object;
                        break;
                    }
                }
                object = ((XMLDocument)this.XMLDoc).getEncoding();
                if (object2 == null) break block25;
                string = ((XSQLStylesheetPI)object2).getHref();
                if (string == null || string.equals("")) break block26;
                boolean bl3 = ((XSQLStylesheetPI)object2).isClient();
                if (bl3) {
                    this.XMLDoc = ((XSQLStylesheetPI)object2).addToProlog(this.XMLDoc);
                    this.env.setContentType(String.valueOf("text/xml; charset=").concat(String.valueOf(object)));
                    break block26;
                } else {
                    String string7 = this.env.translateURL(string);
                    this.env.setStylesheetURI(string);
                    try {
                        XSQLStylesheetProcessor.processToWriter(this.XMLDoc, string7, this.env);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.env.requestProcessed();
                        return;
                    }
                    catch (SAXParseException sAXParseException) {
                        this.env.requestProcessed();
                        return;
                    }
                    catch (XSLException xSLException) {
                        this.env.requestProcessed();
                        return;
                    }
                    catch (Exception exception) {
                        this.env.requestProcessed();
                        return;
                    }
                    this.env.requestProcessed();
                    return;
                }
            }
            this.env.setContentType(String.valueOf("text/xml; charset=").concat(String.valueOf(object)));
        }
        XSQLParserHelper.print(this.XMLDoc, this.env.getWriter());
        this.env.requestProcessed();
    }

    public Document processToXML() throws FileNotFoundException, SAXParseException {
        String string;
        Object object;
        Document document = null;
        if (this.requestedPage == null) {
            try {
                this.requestedPage = XSQLPageManager.getManager().getPage(this.env.getSourceDocumentURI(), this.env);
                this.env.setPageEncoding(this.requestedPage.getDocument().getEncoding());
            }
            catch (SAXParseException sAXParseException) {
                throw sAXParseException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
        }
        XSQLDocHandler xSQLDocHandler = null;
        String string2 = this.env.getUserAgent();
        String string3 = this.env.getParameter("xml-stylesheet");
        String string4 = this.env.getParameter("transform");
        boolean bl = false;
        if (string3 != null && string3.equalsIgnoreCase("none")) {
            bl = true;
            string3 = "";
            string4 = "";
        }
        try {
            xSQLDocHandler = new XSQLDocHandler(this.env, this.requestedPage, string3, string4);
        }
        catch (SAXParseException sAXParseException) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(5), sAXParseException, this.env);
            xSQLErrorWriter.print();
            this.env.requestProcessed();
            Document document2 = null;
            return document2;
        }
        catch (SAXException sAXException) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(5), this.env);
            xSQLErrorWriter.print();
            this.env.requestProcessed();
            Document document3 = null;
            return document3;
        }
        try {
            this.env.setConnectionName(xSQLDocHandler.getConnectionName());
            this.XMLDoc = xSQLDocHandler.getDocument();
        }
        catch (SQLException sQLException) {
            this.env.requestProcessed();
            Document document4 = null;
            return document4;
        }
        catch (DOMException dOMException) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(14), this.env);
            xSQLErrorWriter.print();
            this.env.requestProcessed();
            Document document5 = null;
            return document5;
        }
        catch (RuntimeException runtimeException) {
            XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(17), runtimeException, this.env);
            xSQLErrorWriter.print();
            this.env.requestProcessed();
            Document document6 = null;
            return document6;
        }
        Object object2 = null;
        Enumeration enumeration = xSQLDocHandler.getDocumentPIs().elements();
        boolean bl2 = xSQLDocHandler.getAllowClientStyle();
        if (!bl || !bl2) {
            while (enumeration.hasMoreElements()) {
                object = (XSQLStylesheetPI)enumeration.nextElement();
                String string5 = ((XSQLStylesheetPI)object).getType();
                if (string5 == null || !string5.equals("text/xsl")) continue;
                string = ((XSQLStylesheetPI)object).getMedia();
                if (string != null && !string.equals("")) {
                    if (string2.toUpperCase().indexOf(string.toUpperCase()) < 0) continue;
                    object2 = object;
                    break;
                }
                object2 = object;
                break;
            }
        }
        if (object2 != null && (object = ((XSQLStylesheetPI)object2).getHref()) != null && !((String)object).equals("")) {
            boolean bl3 = ((XSQLStylesheetPI)object2).isClient();
            if (bl3) {
                this.XMLDoc = ((XSQLStylesheetPI)object2).addToProlog(this.XMLDoc);
            } else {
                string = this.env.translateURL((String)object);
                this.env.setStylesheetURI((String)object);
                try {
                    document = XSQLStylesheetProcessor.processToDocument(this.XMLDoc, string, this.env);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.env.requestProcessed();
                    Document document7 = null;
                    return document7;
                }
                catch (SAXParseException sAXParseException) {
                    this.env.requestProcessed();
                    Document document8 = null;
                    return document8;
                }
                catch (XSLException xSLException) {
                    this.env.requestProcessed();
                    Document document9 = null;
                    return document9;
                }
                catch (Exception exception) {
                    this.env.requestProcessed();
                    Document document10 = null;
                    return document10;
                }
                this.env.requestProcessed();
                return document;
            }
        }
        document = this.XMLDoc;
        return document;
    }
}

