/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLErrorWriter;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;

public abstract class XSQLPageRequestImpl
implements XSQLPageRequest {
    protected PrintWriter out = null;
    protected PrintWriter err = null;
    protected String styleURI = null;
    protected String pageurl = null;
    private Hashtable parameters = null;
    protected Hashtable _pageParameters = null;
    protected Hashtable _styleParams = null;
    protected boolean errorHeader = false;
    protected String requestedPageEncoding;
    protected XSQLConnection conn = null;
    boolean usingExistingNamedConnection = false;
    boolean isIncluded = false;
    private String connNameRequested = null;
    protected Document postedDocument = null;

    public boolean printedErrorHeader() {
        return this.errorHeader;
    }

    public void setPrintedErrorHeader(boolean bl) {
        this.errorHeader = bl;
    }

    public XSQLPageRequestImpl() {
    }

    public XSQLPageRequestImpl(String string, Hashtable hashtable) {
        this.pageurl = string;
        this.parameters = hashtable;
    }

    public XSQLPageRequestImpl(Hashtable hashtable) {
        this.parameters = hashtable;
        this.pageurl = this.getParameter("url");
        this.setupWriter();
        this.setupErrorWriter();
    }

    protected void setupWriter() {
        this.out = new PrintWriter(System.out);
    }

    protected void setupErrorWriter() {
        this.err = new PrintWriter(System.out);
    }

    public String getParameter(String string) {
        String string2 = this.getPageParam(string);
        if (string2 != null) {
            return string2;
        }
        return this.parameters != null ? (String)this.parameters.get(string) : null;
    }

    public String getSourceDocumentURI() {
        return this.pageurl;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public PrintWriter getErrorWriter() {
        return this.err;
    }

    public boolean useConnectionPooling() {
        return true;
    }

    public String getUserAgent() {
        String string = this.getParameter("useragent");
        return string == null ? "programmatic" : string;
    }

    public void setContentType(String string) {
        this.setupWriter();
        this.setupErrorWriter();
    }

    public boolean useHTMLErrors() {
        return false;
    }

    public String translateURL(String string) {
        return string;
    }

    public void setStylesheetURI(String string) {
        this.styleURI = string;
    }

    public String getStylesheetURI() {
        return this.styleURI;
    }

    public Document getRequestParamsAsXMLDocument() {
        return XSQLUtil.DictionaryOfParamsAsXMLDocument(this.parameters);
    }

    public void setPostedDocument(Document document) {
        this.postedDocument = document;
    }

    public Document getPostedDocument() {
        return this.postedDocument;
    }

    public void setStylesheetParameter(String string, String string2) {
        if (string != null && string2 != null) {
            if (this._styleParams == null) {
                this._styleParams = new Hashtable(5);
            }
            this._styleParams.put(string, string2);
        }
    }

    public Enumeration getStylesheetParameters() {
        if (this._styleParams == null) {
            return null;
        }
        return this._styleParams.keys();
    }

    public String getStylesheetParameter(String string) {
        return (String)this._styleParams.get(string);
    }

    public void setPageEncoding(String string) {
        this.requestedPageEncoding = string;
    }

    public String getPageEncoding() {
        return this.requestedPageEncoding;
    }

    public void setConnectionName(String string) throws SQLException {
        this.connNameRequested = string;
        if (string != null && !string.equals("")) {
            if (this.conn == null || this.conn != null && !this.conn.getConnectionName().equals(string)) {
                try {
                    this.conn = XSQLConnectionManager.getManager().getConnection(string, this);
                }
                catch (SQLException sQLException) {
                    XSQLErrorWriter xSQLErrorWriter = new XSQLErrorWriter(Res.getString(7), sQLException.getMessage(), (XSQLPageRequest)this);
                    xSQLErrorWriter.print();
                    throw sQLException;
                }
            } else {
                this.usingExistingNamedConnection = true;
            }
        } else {
            XSQLConfigManager.getManager();
            XSQLConfigManager.insureConfigurationIsLoaded(this);
        }
    }

    public Connection getJDBCConnection() {
        return this.conn != null ? this.conn.getJDBCConnection() : null;
    }

    public XSQLConnection getXSQLConnection() {
        return this.conn;
    }

    public void setIncludingRequest(XSQLPageRequest xSQLPageRequest) {
        this.freeConnection();
        this.conn = xSQLPageRequest.getXSQLConnection();
        this.isIncluded = true;
    }

    public String getConnectionName() {
        return this.conn != null ? this.conn.getConnectionName() : null;
    }

    public void requestProcessed() {
        this.freeConnection();
    }

    public boolean isOracleDriver() {
        return this.conn != null ? this.conn.isOracleDriver() : false;
    }

    private void freeConnection() {
        if (this.conn != null && this.connNameRequested != null && !this.usingExistingNamedConnection) {
            XSQLConnectionManager.getManager().releaseConnection(this.conn, this);
        }
    }

    public boolean isIncludedRequest() {
        return this.isIncluded;
    }

    public void setPageParam(String string, String string2) {
        if (this._pageParameters == null) {
            this._pageParameters = new Hashtable(5);
        }
        this._pageParameters.put(string, string2);
    }

    protected String getPageParam(String string) {
        return this._pageParameters != null ? (String)this._pageParameters.get(string) : null;
    }

    public abstract XSQLPageRequest createNestedRequest(URL var1, Dictionary var2);

    public abstract String getRequestType();
}

