/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import oracle.xml.xsql.XSQLPageProcessor;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLURLPageRequest;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class XSQLRequest {
    PrintWriter out = null;
    PrintWriter err = null;
    Dictionary params = null;
    URL url = null;
    XSQLPageRequest callingReq = null;
    Document postedXML = null;

    public XSQLRequest(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public XSQLRequest(URL uRL, XSQLPageRequest xSQLPageRequest) {
        this.url = uRL;
        this.callingReq = xSQLPageRequest;
    }

    public XSQLRequest(String string, XSQLPageRequest xSQLPageRequest) throws MalformedURLException {
        this.url = new URL(string);
        this.callingReq = xSQLPageRequest;
    }

    public XSQLRequest(URL uRL) {
        this.url = uRL;
    }

    public void setPostedDocument(Document document) {
        this.postedXML = document;
    }

    public void process(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
        this.process();
    }

    public void process(Dictionary dictionary, PrintWriter printWriter, PrintWriter printWriter2) {
        this.params = dictionary;
        this.out = printWriter;
        this.err = printWriter2;
        this.process();
    }

    public void process(Dictionary dictionary) {
        this.params = dictionary;
        this.process();
    }

    public void process() {
        if (this.out == null) {
            this.out = new PrintWriter(System.out);
        }
        if (this.err == null) {
            this.err = new PrintWriter(System.err);
        }
        XSQLURLPageRequest xSQLURLPageRequest = new XSQLURLPageRequest(this.url, this.params, this.out, this.err);
        if (this.postedXML != null) {
            xSQLURLPageRequest.setPostedDocument(this.postedXML);
        }
        if (this.callingReq != null) {
            xSQLURLPageRequest.setIncludingRequest(this.callingReq);
        }
        XSQLPageProcessor xSQLPageProcessor = new XSQLPageProcessor(xSQLURLPageRequest);
        try {
            xSQLPageProcessor.process();
        }
        catch (SAXParseException sAXParseException) {
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
    }

    public Document processToXML(PrintWriter printWriter) {
        this.out = this.out;
        this.err = printWriter;
        return this.processToXML();
    }

    public Document processToXML(Dictionary dictionary, PrintWriter printWriter) {
        this.params = dictionary;
        this.out = this.out;
        this.err = printWriter;
        return this.processToXML();
    }

    public Document processToXML(Dictionary dictionary) {
        this.params = dictionary;
        return this.processToXML();
    }

    public Document processToXML() {
        if (this.err == null) {
            this.err = new PrintWriter(System.err);
        }
        XSQLPageRequest xSQLPageRequest = null;
        xSQLPageRequest = this.callingReq != null ? this.callingReq.createNestedRequest(this.url, this.params) : new XSQLURLPageRequest(this.url, this.params, this.err);
        if (this.callingReq != null) {
            xSQLPageRequest.setIncludingRequest(this.callingReq);
        }
        XSQLPageProcessor xSQLPageProcessor = new XSQLPageProcessor(xSQLPageRequest);
        try {
            Document document = xSQLPageProcessor.processToXML();
            return document;
        }
        catch (SAXParseException sAXParseException) {
            Document document = null;
            return document;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Document document = null;
            return document;
        }
    }
}

