/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public final class XSQLIncludeXMLHandler
extends XSQLActionHandlerImpl {
    private static final String HREF = "href";
    URL dataUrl = null;
    String href = null;
    String translatedHRef = null;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.translatedHRef = this.href = this.getAttributeAllowingParam(HREF, element);
        if (this.href != null && !this.href.equals("")) {
            this.translatedHRef = xSQLPageRequest.translateURL(this.href);
        }
    }

    public void handleAction(Node node) throws SQLException {
        if (this.href == null || this.href.equals("")) {
            this.reportMissingAttribute(node, HREF);
            return;
        }
        try {
            this.dataUrl = new URL(this.translatedHRef);
        }
        catch (MalformedURLException malformedURLException) {
            this.reportError(node, Res.format(5, this.href));
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Document document = XSQLParserHelper.parse(this.dataUrl, printWriter);
            Element element = document.getDocumentElement();
            document.removeChild(element);
            node.appendChild(element);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.reportError(node, Res.format(6, this.href));
        }
        catch (SAXParseException sAXParseException) {
            this.reportError(node, Res.format(7, this.href));
        }
        catch (Exception exception) {
            this.reportError(node, exception.getMessage());
        }
    }
}

