/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLRequest;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLIncludeXSQLHandler
extends XSQLActionHandlerImpl {
    private static final String HREF = "href";
    private static final String REPARSE = "reparse";
    URL dataUrl = null;
    String href = null;
    boolean reparse = false;
    String translatedHRef = null;
    Hashtable params = null;
    String queryString;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.href = this.getAttributeAllowingParam(HREF, element);
        String string = this.getAttributeAllowingParam(REPARSE, element);
        this.reparse = string != null && (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes"));
        this.translatedHRef = this.href;
        if (this.href != null && !this.href.equals("")) {
            this.translatedHRef = xSQLPageRequest.translateURL(this.href);
        }
    }

    public void handleAction(Node node) throws SQLException {
        if (this.href == null || this.href.equals("")) {
            this.reportMissingAttribute(node, HREF);
            return;
        }
        int n = this.translatedHRef.indexOf(63);
        if (n >= 0) {
            this.queryString = this.translatedHRef.substring(n + 1);
            this.translatedHRef = this.translatedHRef.substring(0, n);
        }
        if (this.queryString != null && !this.queryString.equals("")) {
            this.params = this.parseQueryString(this.queryString);
        }
        try {
            this.dataUrl = new URL(this.translatedHRef);
        }
        catch (MalformedURLException malformedURLException) {
            this.reportError(node, Res.format(5, this.href));
            return;
        }
        try {
            Object object;
            Object object2;
            Document document = null;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            XSQLRequest xSQLRequest = new XSQLRequest(this.dataUrl, this.getPageRequest());
            if (this.reparse) {
                object2 = new StringWriter();
                object = new PrintWriter((Writer)object2);
                if (this.params != null) {
                    xSQLRequest.process(this.params, (PrintWriter)object, printWriter);
                } else {
                    xSQLRequest.process((PrintWriter)object, printWriter);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((StringWriter)object2).toString().getBytes());
                document = XSQLParserHelper.parse(byteArrayInputStream, null, printWriter);
            } else {
                document = this.params != null ? xSQLRequest.processToXML(this.params, printWriter) : xSQLRequest.processToXML(printWriter);
            }
            object2 = stringWriter.toString();
            if (!((String)object2).equals("")) {
                this.reportErrorIncludingStatement(node, Res.format(9, this.href), (String)object2);
                return;
            }
            if (document != null) {
                object = document.getDocumentElement();
                document.removeChild((Node)object);
                node.appendChild((Node)object);
            } else {
                this.reportError(node, Res.format(7, this.translatedHRef));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.reportError(node, exception.getMessage());
        }
    }

    private Hashtable parseQueryString(String string) {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string3 = this.parseName(string2.substring(0, n), stringBuffer);
            String string4 = this.parseName(string2.substring(n + 1, string2.length()), stringBuffer);
            if (hashtable.containsKey(string3)) {
                String[] stringArray2 = (String[])hashtable.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            hashtable.put(string3, stringArray);
        }
        return hashtable;
    }

    private String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

