/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLInsertRequestHandler
extends XSQLActionHandlerImpl {
    private static final String TABLE = "table";
    private static final String TRANSFORM = "transform";
    private static final String DATEFORMAT = "date-format";
    private static final String INS_STATUS_ELT = "insert-request";
    private OracleXMLSave oxs = null;
    private String tablename = null;
    private String transform = null;
    private String dateformat = null;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.tablename = this.getAttributeAllowingParam(TABLE, element);
        this.transform = this.getAttributeAllowingParam(TRANSFORM, element);
        this.dateformat = this.getAttributeAllowingParam(DATEFORMAT, element);
        this.transform = this.transform != null && !this.transform.equals("") ? xSQLPageRequest.translateURL(this.transform) : null;
    }

    public void handleAction(Node node) throws SQLException {
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        if (this.tablename == null || this.tablename.equals("")) {
            this.reportMissingAttribute(node, TABLE);
            return;
        }
        Document document = this.getPageRequest().getPostedDocument();
        Document document2 = null;
        if (document != null) {
            try {
                document2 = this.transform != null && !this.transform.equals("") ? XSQLStylesheetProcessor.processToDocument(document, this.transform, this.getPageRequest()) : document;
                OracleXMLSave oracleXMLSave = new OracleXMLSave(this.getPageRequest().getJDBCConnection(), this.tablename);
                oracleXMLSave.setIgnoreCase(true);
                if (this.dateformat != null && !this.dateformat.equals("")) {
                    oracleXMLSave.setDateFormat(this.dateformat);
                }
                int n = oracleXMLSave.insertXML(document2);
                this.getPageRequest().getJDBCConnection().commit();
                this.reportStatus(node, "rows", String.valueOf("").concat(String.valueOf(n)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportError(node, Res.format(11, this.transform));
            }
            catch (IOException iOException) {
                this.reportError(node, Res.format(11, this.transform));
            }
            catch (SQLException sQLException) {
                this.reportError(node, sQLException.getMessage());
            }
            catch (OracleXMLSQLException oracleXMLSQLException) {
                this.reportError(node, oracleXMLSQLException.getMessage());
            }
            catch (Exception exception) {}
        } else {
            this.reportStatus(node, "result", Res.getString(13));
        }
    }
}

