/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import oracle.jdbc.driver.OracleStatement;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.sql.OracleXMLSQLNoRowsException;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLQueryHandler
extends XSQLActionHandlerImpl {
    private static String STYLE_PI = "xml-stylesheet";
    private String sqlStatement = null;
    private String stylesheet = null;
    private String maxrowsParam = null;
    private String skiprowsParam = null;
    private String resultsetTag = null;
    private String resultrowTag = null;
    private String idAttrName = null;
    private String fetchSize = null;
    private int rowprefetch = -1;
    private String idAttrColumn = null;
    private String nullIndicator = null;
    private String tagCase = null;
    private int maxrows = -1;
    private int skiprows = 0;
    private Element errorQueryNode = null;
    private Vector queryPIs = null;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.stylesheet = this.getAttributeAllowingParam("stylesheet", element);
        this.maxrowsParam = this.getAttributeAllowingParam("max-rows", element);
        this.skiprowsParam = this.getAttributeAllowingParam("skip-rows", element);
        this.resultsetTag = this.getAttributeAllowingParam("rowset-element", element);
        if (this.resultsetTag == null) {
            this.resultsetTag = this.getAttributeAllowingParam("doc-element", element);
        }
        this.resultrowTag = this.getAttributeAllowingParam("row-element", element);
        this.idAttrName = this.getAttributeAllowingParam("id-attribute", element);
        this.idAttrColumn = this.getAttributeAllowingParam("id-attribute-column", element);
        this.fetchSize = this.getAttributeAllowingParam("fetch-size", element);
        this.nullIndicator = this.getAttributeAllowingParam("null-indicator", element);
        this.tagCase = this.getAttributeAllowingParam("tag-case", element);
    }

    /*
     * Unable to fully structure code
     */
    public void handleAction(Node var1_1) {
        block39: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            if (!this.requiredConnectionProvided(var1_1)) {
                return;
            }
            var5_5 = this.getPageRequest().getJDBCConnection();
            this.sqlStatement = this.getActionElementContent();
            if (this.sqlStatement == null || this.sqlStatement.equals("")) {
                this.reportError(var1_1, Res.getString(14));
                return;
            }
            if (this.maxrowsParam != null) {
                try {
                    this.maxrows = Integer.parseInt(this.maxrowsParam);
                }
                catch (Exception var6_6) {
                    this.maxrows = -1;
                }
            }
            if (this.skiprowsParam != null) {
                try {
                    this.skiprows = Integer.parseInt(this.skiprowsParam);
                }
                catch (Exception var6_7) {
                    this.skiprows = 0;
                }
            }
            try {
                var4_4 = var5_5.createStatement();
                if (this.getPageRequest().isOracleDriver()) {
                    if (this.fetchSize != null) {
                        try {
                            this.rowprefetch = Integer.parseInt(this.fetchSize);
                        }
                        catch (Exception var6_9) {
                            this.rowprefetch = -1;
                        }
                    }
                    if (this.rowprefetch == -1) {
                        this.rowprefetch = this.getDefaultFetchSize();
                    }
                    if (this.maxrows >= 1 && this.skiprows >= 0 && this.rowprefetch > this.maxrows + this.skiprows) {
                        this.rowprefetch = this.maxrows + this.skiprows;
                    }
                    if (this.rowprefetch > 1) {
                        var6_8 = (OracleStatement)var4_4;
                        var6_8.setRowPrefetch(this.rowprefetch);
                    }
                }
                var3_3 = var4_4.executeQuery(this.sqlStatement);
            }
            catch (SQLException var6_10) {
                this.reportErrorIncludingStatement(var1_1, this.sqlStatement, var6_10.getMessage());
                this.closeThings(var3_3, var4_4);
                return;
            }
            var2_2 = new OracleXMLQuery(var5_5, var3_3);
            if (this.maxrows >= 0) {
                var2_2.setMaxRows(this.maxrows);
            }
            if (this.skiprows > 0) {
                var2_2.setSkipRows(this.skiprows);
            }
            if (this.resultsetTag != null) {
                var2_2.setRowsetTag(this.resultsetTag);
            }
            if (this.resultrowTag != null) {
                var2_2.setRowTag(this.resultrowTag);
            }
            if (this.stylesheet != null && !this.stylesheet.equals("")) {
                var2_2.setStyleSheet(this.stylesheet);
            }
            if (this.nullIndicator != null && !this.nullIndicator.equals("")) {
                if (this.nullIndicator.equalsIgnoreCase("Y") || this.nullIndicator.equalsIgnoreCase("yes")) {
                    var2_2.useNullAttributeIndicator(true);
                } else if (this.nullIndicator.equalsIgnoreCase("N") || this.nullIndicator.equalsIgnoreCase("no")) {
                    var2_2.useNullAttributeIndicator(false);
                }
            }
            if (this.tagCase != null && !this.tagCase.equals("")) {
                if (this.tagCase.equalsIgnoreCase("upper")) {
                    var2_2.useUpperCaseTagNames();
                } else if (this.tagCase.equalsIgnoreCase("lower")) {
                    var2_2.useLowerCaseTagNames();
                }
            }
            if (this.idAttrColumn != null) {
                var2_2.setRowIdColumn(this.idAttrColumn);
            }
            if (this.idAttrName != null) {
                var2_2.setRowIdAttrName(this.idAttrName);
            }
            if ((var6_8 = this.getActionElement().getChildNodes()) != null) {
                var7_11 = var6_8.getLength();
                var8_15 = 0;
                while (var8_15 < var7_11) {
                    var9_17 = var6_8.item(var8_15);
                    if (var9_17.getNodeType() == 1 && ((XMLElement)var9_17).getLocalName().equals("no-rows-query")) {
                        var2_2.setRaiseNoRowsException(true);
                        this.errorQueryNode = (Element)var9_17;
                        break;
                    }
                    ++var8_15;
                }
            }
            if (this.errorQueryNode == null) {
                var7_12 = var2_2.getXMLDOM(var1_1);
                this.closeThings(var3_3, var4_4);
                return;
            }
            try {
                var7_13 = var2_2.getXMLDOM(var1_1);
                this.closeThings(var3_3, var4_4);
                return;
            }
            catch (OracleXMLSQLNoRowsException var7_14) {
                this.closeThings(var3_3, var4_4);
                var8_16 = new XSQLQueryHandler();
                var8_16.init(this.getPageRequest(), this.errorQueryNode);
                var9_17 = var1_1.getChildNodes();
                if (var9_17 == null) break block39;
                var10_18 = var9_17.getLength();
                var11_19 = 0;
                ** while (var11_19 < var10_18)
            }
lbl-1000:
            // 1 sources

            {
                var1_1.removeChild(var9_17.item(0));
                ++var11_19;
                continue;
            }
        }
        var8_16.handleAction(var1_1);
    }

    private void closeThings(ResultSet resultSet, Statement statement) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

