/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.actions.Res;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLRefCursorFunctionHandler
extends XSQLActionHandlerImpl {
    private String maxrowsParam = null;
    private String skiprowsParam = null;
    private String resultsetTag = null;
    private String resultrowTag = null;
    private String idAttrName = null;
    private String idAttrColumn = null;
    private String nullIndicator = null;
    private String tagCase = null;
    private int maxrows = -1;
    private int skiprows = 0;

    public void init(XSQLPageRequest xSQLPageRequest, Element element) {
        super.init(xSQLPageRequest, element);
        this.maxrowsParam = this.getAttributeAllowingParam("max-rows", element);
        this.skiprowsParam = this.getAttributeAllowingParam("skip-rows", element);
        this.resultsetTag = this.getAttributeAllowingParam("rowset-element", element);
        this.resultrowTag = this.getAttributeAllowingParam("row-element", element);
        this.idAttrName = this.getAttributeAllowingParam("id-attribute", element);
        this.idAttrColumn = this.getAttributeAllowingParam("id-attribute-column", element);
        this.nullIndicator = this.getAttributeAllowingParam("null-indicator", element);
        this.tagCase = this.getAttributeAllowingParam("tag-case", element);
    }

    public void handleAction(Node node) throws SQLException {
        int n;
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        String string = this.getActionElementContent();
        if (string == null || string.equals("")) {
            this.reportError(node, Res.getString(15));
            return;
        }
        char c = (string = string.trim()).charAt((n = string.length()) - 1);
        if (c != ';') {
            string = String.valueOf(string).concat(String.valueOf(";"));
        }
        Statement statement = null;
        OracleXMLQuery oracleXMLQuery = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getPageRequest().getJDBCConnection();
            statement = connection.prepareCall(String.valueOf(String.valueOf("begin ? := ").concat(String.valueOf(string))).concat(String.valueOf(" end;")));
            statement.registerOutParameter(1, -10);
            statement.execute();
            resultSet = ((OracleCallableStatement)statement).getCursor(1);
            oracleXMLQuery = new OracleXMLQuery(connection, resultSet);
            if (this.maxrowsParam != null) {
                try {
                    this.maxrows = Integer.parseInt(this.maxrowsParam);
                }
                catch (Exception exception) {
                    this.maxrows = -1;
                }
            }
            if (this.skiprowsParam != null) {
                try {
                    this.skiprows = Integer.parseInt(this.skiprowsParam);
                }
                catch (Exception exception) {
                    this.skiprows = 0;
                }
            }
            if (this.maxrows >= 0) {
                oracleXMLQuery.setMaxRows(this.maxrows);
            }
            if (this.skiprows > 0) {
                oracleXMLQuery.setSkipRows(this.skiprows);
            }
            if (this.resultsetTag != null) {
                oracleXMLQuery.setRowsetTag(this.resultsetTag);
            }
            if (this.resultrowTag != null) {
                oracleXMLQuery.setRowTag(this.resultrowTag);
            }
            if (this.nullIndicator != null && !this.nullIndicator.equals("")) {
                if (this.nullIndicator.equalsIgnoreCase("Y") || this.nullIndicator.equalsIgnoreCase("yes")) {
                    oracleXMLQuery.useNullAttributeIndicator(true);
                } else if (this.nullIndicator.equalsIgnoreCase("N") || this.nullIndicator.equalsIgnoreCase("no")) {
                    oracleXMLQuery.useNullAttributeIndicator(false);
                }
            }
            if (this.tagCase != null && !this.tagCase.equals("")) {
                if (this.tagCase.equalsIgnoreCase("upper")) {
                    oracleXMLQuery.useUpperCaseTagNames();
                } else if (this.tagCase.equalsIgnoreCase("lower")) {
                    oracleXMLQuery.useLowerCaseTagNames();
                }
            }
            if (this.idAttrColumn != null) {
                oracleXMLQuery.setRowIdColumn(this.idAttrColumn);
            }
            if (this.idAttrName != null) {
                oracleXMLQuery.setRowIdAttrName(this.idAttrName);
            }
            oracleXMLQuery.getXMLDOM(node);
            oracleXMLQuery.close();
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            if (oracleXMLQuery != null) {
                try {
                    oracleXMLQuery.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
            this.reportErrorIncludingStatement(node, string, sQLException.getMessage());
        }
    }
}

