/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.core;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.util.RepConversion;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.OracleXMLSQLNoRowsException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLTimer;
import oracle.xml.sql.dataset.OracleXMLDataSet;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dataset.OracleXMLDataSetGenJdbc;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.name.OracleADTName;
import oracle.xml.sql.name.OracleCollectionName;
import oracle.xml.sql.name.OracleColumnName;
import oracle.xml.sql.name.OracleCursorName;
import oracle.xml.sql.name.OracleScalarName;

public class OracleXMLConvert {
    static final String VERSION_TARGET = "xml";
    static final String VERSION_NUM = "1.0";
    static final String VERSION_DATA = "version=\"1.0\"";
    static final String STYLESHEET_TARGET = "xml-stylesheet";
    static final String STYLESHEET_TYPE_DATA = "text/xsl";
    static final String FOOTER = "</>";
    static final String WHITESPACE = " ";
    static final String NULL_ATTR_ID = "NULL";
    static final String NULL_ATTR_VAL = " (TRUE|FALSE) \"FALSE\">\n";
    static final String NULL_ATTR_VAL2 = " (TRUE|FALSE) #FIXED \"FALSE\">\n";
    static final String COLL_ITEM_TAG = "_ITEM";
    static final String COLL_ID_ATTR_TAG = "itemNo";
    public static final String ROWCOUNT = "num";
    public static final String ROWSET_TAG = "ROWSET";
    public static final String ROW_TAG = "ROW";
    public static final String ERROR_TAG = "ERROR";
    public static final String REFATTRNAME = "REFTYPE";
    public static final String ELEMENT_NAME = "<!ELEMENT ";
    public static final String ATTLIST_NAME = "<!ATTLIST ";
    public static final String PCDATA_NAME = " (#PCDATA)>\n";
    public static final String SCHEMA_T = "schema";
    public static final String ELEMID = "name";
    public static final String ELEM = "element";
    public static final String ATTR = "attribute";
    public static final String TYPE = "type";
    public static final String NMSPC = "xmlns";
    public static final String MINO = "minOccurs";
    public static final String MAXO = "maxOccurs";
    public static final String W3CDT = "dt";
    public static final String DOC_T = "DOCUMENT";
    public static final String W3CSFS = "urn:schema-w3c-org:xml-schema-v1";
    public static final String W3CSFDT = "urn:schema-w3c-org:xml-datatypes-v1";
    public static final String DTSTRING = "String";
    public static final String DTBINHEX = "Bin.hex";
    public static final String DTNUMBER = "Number";
    public static final String DTFLOAT = "Float";
    public static final String DTDATETIME = "DateTime";
    public static final String DTROWID = "ROWID";
    public static final String DTBFILE = "BFILE";
    public static final String DTNAMEDTYPE = "Named Type";
    static final int SQLXml = 0;
    static final int SQLXmlWithDTD = 1;
    public static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int DEFAULT_CASE = 0;
    public static final int MAXROWS_NONE = 0;
    public static final int MAXROWS_ALL = -1;
    public static final int MAXROWS_DEFAULT = -1;
    public static final int SKIPROWS_NONE = 0;
    public static final int SKIPROWS_ALL = -1;
    public static final int SKIPROWS_DEFAULT = 0;
    public static final int NONE = 0;
    int metaType = 0;
    public static final int DTD = 1;
    public static final int SCHEMA = 2;
    int docType = 1;
    public static final int XML = 1;
    public static final int VER = 2;
    int miscFlags = 0;
    public static final int ICPUT = 1;
    public static final int PUT = 2;
    public Reader metaHeader = null;
    public Reader dataHeader = null;
    private String DTDString = null;
    private int tagCase = 0;
    String rowCountStr = "num";
    String rowSepTag = "ROW";
    String rowSetTag = "ROWSET";
    String errTag = "ERROR";
    String collItemTag = "_ITEM";
    String collIdAttrName = null;
    String refAttrName = "REFTYPE";
    String nullAttrId = "NULL";
    public String docTag = null;
    private boolean objClosed = false;
    private int rowIdColNum = 0;
    private String rowIdColName = null;
    private int rowIdAttrDt = 2;
    private boolean keepCursor = false;
    private boolean rootNodeSupplied = false;
    private boolean useColumnLabelAsRoot = false;
    private OracleColumnName[] colNames;
    private Hashtable colNamesHash = null;
    private String qstring = null;
    private ResultSet rset = null;
    private OracleXMLDataSet dset = null;
    private int maxRows = -1;
    private int skipRows = 0;
    private String styleSheetType = null;
    private String styleSheetURI = null;
    boolean noRowsException = false;
    boolean raiseException = false;
    boolean useNullAttrId = false;
    private Connection conn;
    private OracleXMLTimer tim = null;
    private boolean collectTimingInfo = false;
    private String thisUser = null;
    int rowCount = 1;
    Exception extException = null;
    boolean dsetIsExt = false;
    boolean rsetIsExt = false;
    public static XSUMesg msg = new XSUMesg();
    boolean namesValid = false;
    String dateFormat = null;
    boolean updateDateFormat = false;

    public OracleXMLConvert(Connection connection) {
        this.conn = connection;
    }

    public OracleXMLConvert(Connection connection, String string) {
        this.conn = connection;
        this.qstring = string;
    }

    public OracleXMLConvert(Connection connection, ResultSet resultSet) {
        this.conn = connection;
        this.rset = resultSet;
        this.rsetIsExt = true;
    }

    public OracleXMLConvert(Connection connection, OracleXMLDataSet oracleXMLDataSet) {
        this.conn = connection;
        this.dset = oracleXMLDataSet;
        this.dsetIsExt = true;
        this.colNamesHash = new Hashtable(20);
    }

    public static StringBuffer ReaderToStrBuf(Reader reader, StringBuffer stringBuffer) throws IOException {
        int n;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(100);
        }
        char[] cArray = new char[100];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void To_XML(OracleXMLDocGen oracleXMLDocGen, int n) {
        block19: {
            try {
                block18: {
                    try {
                        if (this.extException != null) {
                            throw this.extException;
                        }
                        if (this.objClosed) {
                            throw new OracleXMLSQLException(msg.getMessage1("XSUE-0004", "keepObjectOpen()"), this.errTag);
                        }
                        if (this.dset == null) {
                            if (this.qstring != null) {
                                this.dset = this.conn.getClass().getName().compareTo("oracle.jdbc.driver.OracleConnection") == 0 ? new OracleXMLDataSetExtJdbc(this.conn, this.qstring) : new OracleXMLDataSetGenJdbc(this.conn, this.qstring);
                            } else if (this.rset != null) {
                                this.dset = this.conn.getClass().getName().compareTo("oracle.jdbc.driver.OracleConnection") == 0 ? (this.rset instanceof OracleResultSet ? new OracleXMLDataSetExtJdbc(this.conn, (OracleResultSet)this.rset) : new OracleXMLDataSetGenJdbc(this.conn, this.rset)) : new OracleXMLDataSetGenJdbc(this.conn, this.rset);
                            }
                            if (this.rowIdColName != null) {
                                this.setRowIdAttrValue(this.rowIdColName);
                            }
                        } else {
                            if (this.dataHeader != null) {
                                this.dataHeader.reset();
                            }
                            if (this.metaHeader != null) {
                                this.metaHeader.reset();
                            }
                        }
                        if (this.updateDateFormat) {
                            this.dset.setDateFormat(this.dateFormat);
                            this.updateDateFormat = false;
                        }
                        this.metaType = n;
                        oracleXMLDocGen.createNewDocument(false);
                        if (n == 0 && this.docType == 0) {
                            Object var4_3 = null;
                            if (this.keepCursor) return;
                            break block18;
                        }
                        this.getXML(oracleXMLDocGen);
                        break block19;
                    }
                    catch (OracleXMLSQLNoRowsException oracleXMLSQLNoRowsException) {
                        throw (OracleXMLSQLNoRowsException)oracleXMLSQLNoRowsException.fillInStackTrace();
                    }
                    catch (Exception exception) {
                        if (this.raiseException) {
                            if (!(exception instanceof OracleXMLSQLException)) throw new OracleXMLSQLException(exception, this.errTag);
                            throw (OracleXMLSQLException)exception.fillInStackTrace();
                        }
                        this.createErrorDocument(oracleXMLDocGen, exception.toString());
                        Object var4_4 = null;
                        if (this.keepCursor) return;
                        this.close(oracleXMLDocGen);
                        return;
                    }
                }
                this.close(oracleXMLDocGen);
                return;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.keepCursor) throw throwable;
                this.close(oracleXMLDocGen);
                throw throwable;
            }
        }
        Object var4_5 = null;
        if (this.keepCursor) return;
        this.close(oracleXMLDocGen);
    }

    public void close() {
        this.close(null);
    }

    private void close(OracleXMLDocGen oracleXMLDocGen) {
        this.objClosed = true;
        try {
            if (this.dset != null && !this.dsetIsExt) {
                this.dset.close();
            }
            if (this.rset != null && !this.rsetIsExt) {
                this.rset.close();
            }
        }
        catch (SQLException sQLException) {
            if (!this.raiseException) {
                if (oracleXMLDocGen != null) {
                    this.createErrorDocument(oracleXMLDocGen, sQLException.getMessage());
                }
            }
            throw new OracleXMLSQLException(sQLException, this.errTag);
        }
    }

    public void collectTimingInfo(boolean bl) {
        this.collectTimingInfo = bl;
    }

    private String convCase(String string) {
        if (string == null) {
            return string;
        }
        if (this.tagCase == 0) {
            return string;
        }
        if (this.tagCase == 2) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    void convertADTObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        Object[] objectArray = this.dset.getStructAttributes(object);
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            OracleColumnName oracleColumnName2 = oracleADTName.getAttributeName(n4);
            this.convertObject(oracleColumnName2.getColumnType(), oracleColumnName2, objectArray[n4], oracleXMLDocGen, n + 1, -1);
            ++n4;
        }
        oracleXMLDocGen.endElement(object2);
    }

    private void convertBFileObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        BFILE bFILE = (BFILE)object;
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        bFILE.openFile();
        byte[] byArray = bFILE.getBytes(1L, (int)bFILE.length());
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, true);
        oracleXMLDocGen.endElement(object2);
    }

    private void convertBlobObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        BLOB bLOB = (BLOB)object;
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        byte[] byArray = bLOB.getBytes(1L, (int)bLOB.length());
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, false);
        oracleXMLDocGen.endElement(object2);
    }

    private static String convertByteToHexString(byte[] byArray) {
        return RepConversion.bArray2String((byte[])byArray);
    }

    private static int convertCharToInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 48;
    }

    private void convertClobObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        CLOB cLOB = (CLOB)object;
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, new Integer(n2).toString());
        }
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        oracleXMLDocGen.addTextValue(string, true);
        oracleXMLDocGen.endElement(object2);
    }

    private void convertCollObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n) throws SQLException {
        Object[] objectArray = this.dset.getCollectionValues(object);
        OracleColumnName oracleColumnName2 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
        int n2 = oracleColumnName2.getColumnType();
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.convertObject(n2, oracleColumnName2, objectArray[n3], oracleXMLDocGen, n + 1, this.collIdAttrName != null ? n3 + 1 : -1);
            ++n3;
        }
        oracleXMLDocGen.endElement(object2);
    }

    private void convertCursorObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        String string;
        OracleCursorName oracleCursorName = (OracleCursorName)oracleColumnName;
        int n3 = oracleCursorName.getColumnCount();
        int n4 = 1;
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        String string2 = string = String.valueOf(oracleColumnName.getLabel()) + "_" + this.convCase(ROW_TAG);
        Object object3 = null;
        while (this.dset.cursorFetchNextRow(object, n4)) {
            object3 = oracleXMLDocGen.startNewElementWithAttr(string2, this.convCase(ROWCOUNT), Integer.toString(n4));
            int n5 = 1;
            while (n5 <= n3) {
                Object object4 = this.dset.cursorGetColumnObject(object, n5);
                this.convertObject(oracleCursorName.getColumnName(n5 - 1).getColumnType(), oracleCursorName.getColumnName(n5 - 1), object4, oracleXMLDocGen, 2, -1);
                ++n5;
            }
            oracleXMLDocGen.endElement(object3);
            ++n4;
        }
        this.dset.cursorClose(object);
        oracleXMLDocGen.endElement(object2);
    }

    public static byte[] convertHexStringToByte(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            int n2 = OracleXMLConvert.convertCharToInt(string.charAt(n));
            Integer n3 = new Integer(0xF0 & n2 << 4);
            byArray[n / 2] = n3.byteValue();
            n2 = OracleXMLConvert.convertCharToInt(string.charAt(n + 1));
            n3 = new Integer(0xF & n2);
            int n4 = n / 2;
            byArray[n4] = (byte)(byArray[n4] | n3.byteValue());
            n += 2;
        }
        return byArray;
    }

    private void convertObject(int n, OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n2, int n3) throws SQLException {
        boolean bl = true;
        Object object2 = null;
        if (object == null) {
            if (!this.useNullAttrId) {
                return;
            }
            object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
            if (n3 != -1) {
                oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
            }
            oracleXMLDocGen.addAttribute(this.nullAttrId, "YES");
            oracleXMLDocGen.endElement(object2);
            return;
        }
        if (n == 1 || n == 12 || n == -1) {
            object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
            if (n3 != -1) {
                oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
            }
            oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
            oracleXMLDocGen.endElement(object2);
        } else if (n >= 2 && n <= 8) {
            bl = false;
            object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
            if (n3 != -1) {
                oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
            }
            oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
            oracleXMLDocGen.endElement(object2);
        } else if (n >= 91 && n <= 93) {
            bl = false;
            object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
            if (n3 != -1) {
                oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
            }
            oracleXMLDocGen.addTextValue(this.dset.getDateString(object), bl);
            oracleXMLDocGen.endElement(object2);
        } else {
            switch (n) {
                case 2002: {
                    this.convertADTObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2003: {
                    this.convertCollObject(oracleColumnName, object, oracleXMLDocGen, n2);
                    break;
                }
                case 2004: {
                    this.convertBlobObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2005: {
                    this.convertClobObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -8: {
                    this.convertRowIdObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -10: {
                    this.convertCursorObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case 2006: {
                    this.convertREFObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -13: {
                    this.convertBFileObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.convertRawObject(oracleColumnName, object, oracleXMLDocGen, n2, n3);
                    break;
                }
                default: {
                    object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
                    if (n3 != -1) {
                        oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n3));
                    }
                    oracleXMLDocGen.addTextValue(this.dset.getScalarStrValue(object), bl);
                    oracleXMLDocGen.endElement(object2);
                    break;
                }
            }
        }
    }

    private void convertREFObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        REF rEF = (REF)object;
        String string = rEF.getBaseTypeName();
        byte[] byArray = rEF.getBytes();
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (this.metaType == 0 || !oracleXMLDocGen.supportMetatype(this.metaType)) {
            oracleXMLDocGen.addAttribute(this.refAttrName, (String)oracleColumnName.getBaseTypeObj());
        }
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        String string2 = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string2, false);
        oracleXMLDocGen.endElement(object2);
    }

    private void convertRawObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        byte[] byArray = null;
        if (object instanceof RAW) {
            byArray = ((RAW)object).getBytes();
        } else if (object instanceof byte[]) {
            byArray = (byte[])object;
        }
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        String string = OracleXMLConvert.convertByteToHexString(byArray);
        oracleXMLDocGen.addTextValue(string, false);
        oracleXMLDocGen.endElement(object2);
    }

    private void convertRow(OracleXMLDataSet oracleXMLDataSet, OracleXMLDocGen oracleXMLDocGen) throws SQLException {
        int n = oracleXMLDataSet.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            this.convertObject(this.colNames[n2 - 1].getColumnType(), this.colNames[n2 - 1], oracleXMLDataSet.getObject(n2), oracleXMLDocGen, 2, -1);
            ++n2;
        }
    }

    private void convertRowIdObject(OracleColumnName oracleColumnName, Object object, OracleXMLDocGen oracleXMLDocGen, int n, int n2) throws SQLException {
        byte[] byArray = ((ROWID)object).getBytes();
        Object object2 = oracleXMLDocGen.startNewElement(oracleColumnName.getLabel());
        if (n2 != -1) {
            oracleXMLDocGen.addAttribute(this.collIdAttrName, Integer.toString(n2));
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n3 = 0;
        while (n3 < byArray.length) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        oracleXMLDocGen.addTextValue(stringBuffer.toString(), false);
        oracleXMLDocGen.endElement(object2);
    }

    OracleColumnName createADTName(String string, Object object) throws SQLException {
        int n;
        Vector<Integer> vector;
        Vector<Object> vector2;
        Vector<String> vector3;
        OracleADTName oracleADTName = null;
        OracleColumnName oracleColumnName = (OracleColumnName)this.colNamesHash.get(object);
        if (oracleColumnName == null) {
            vector3 = new Vector<String>(5, 5);
            vector2 = new Vector<Object>(5, 5);
            vector = new Vector<Integer>(5, 5);
            this.dset.getStructMetaData(object, vector3, vector2, vector);
            oracleADTName = new OracleADTName(string, object, vector3.size(), this.miscFlags);
        } else {
            n = ((OracleADTName)oracleColumnName).getAttributeCount();
            vector3 = new Vector(n);
            vector2 = new Vector(n);
            vector = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                OracleColumnName oracleColumnName2 = ((OracleADTName)oracleColumnName).getAttributeName(n2);
                vector3.addElement(oracleColumnName2.getLabel());
                vector2.addElement(oracleColumnName2.getBaseTypeObj());
                vector.addElement(new Integer(oracleColumnName2.getColumnType()));
                ++n2;
            }
            oracleADTName = new OracleADTName(string, object, vector3.size(), this.miscFlags);
        }
        n = 0;
        while (n < vector3.size()) {
            OracleColumnName oracleColumnName3 = this.createColName((Integer)vector.elementAt(n), this.convCase((String)vector3.elementAt(n)), (String)vector2.elementAt(n));
            oracleADTName.setAttributeName(n, oracleColumnName3);
            ++n;
        }
        if (oracleColumnName != null) {
            this.colNamesHash.put(object, oracleADTName);
        }
        return oracleADTName;
    }

    private OracleColumnName createColName(int n, String string, Object object) throws SQLException {
        OracleColumnName oracleColumnName;
        if (this.collectTimingInfo) {
            if (n == 2002) {
                this.tim.start(" ADT Object DTD (" + string + ")", 0);
            } else if (n == -10) {
                this.tim.start(" Cursor Object DTD (" + string + ")", 0);
            } else if (n == 2003) {
                this.tim.start(" Collection Object DTD (" + string + ")", 0);
            } else if (n == 2006) {
                this.tim.start(" REF Object DTD (" + string + ")", 0);
            } else {
                this.tim.start(" Object DTD (" + string + ")", 0);
            }
        }
        switch (n) {
            case 2002: {
                oracleColumnName = this.createADTName(string, object);
                break;
            }
            case -10: {
                oracleColumnName = this.createCursorName(string, object);
                break;
            }
            case 2006: {
                oracleColumnName = this.createREFName(string, object);
                break;
            }
            case 2003: {
                oracleColumnName = this.createCollName(string, object);
                break;
            }
            default: {
                oracleColumnName = new OracleScalarName(string, n, object);
            }
        }
        if (this.collectTimingInfo) {
            this.tim.stop();
        }
        return oracleColumnName;
    }

    public void createColNames() throws SQLException {
        int n = this.dset.getColumnCount();
        if (this.colNames == null) {
            this.colNames = new OracleColumnName[n];
            this.colNamesHash = new Hashtable(n * 2);
            int n2 = 1;
            while (n2 <= n) {
                this.colNames[n2 - 1] = this.createColName(this.dset.getColumnType(n2), this.convCase(this.dset.getColumnLabel(n2)), this.dset.getColumnTypeObject(n2));
                ++n2;
            }
        }
    }

    private OracleColumnName createCollName(String string, Object object) throws SQLException {
        Object object2;
        Object object3;
        OracleCollectionName oracleCollectionName = null;
        Object object4 = null;
        String string2 = String.valueOf(string) + this.collItemTag;
        OracleColumnName oracleColumnName = (OracleColumnName)this.colNamesHash.get(object);
        if (oracleColumnName == null) {
            object3 = new int[1];
            Object[] objectArray = new Object[1];
            this.dset.getCollectionMetaData(object, objectArray, (int[])object3);
            object4 = objectArray[0];
            object2 = object3[0];
        } else {
            object3 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
            object4 = ((OracleColumnName)object3).getBaseTypeObj();
            object2 = ((OracleColumnName)object3).getColumnType();
        }
        if (object2 == 2002) {
            object3 = this.createColName(2002, string2, object4);
            oracleCollectionName = new OracleCollectionName(string, object, (OracleColumnName)object3);
        } else {
            oracleCollectionName = new OracleCollectionName(string, object, new OracleScalarName(string2, (int)object2, object4));
        }
        if (oracleColumnName == null) {
            this.colNamesHash.put(object, oracleCollectionName);
        }
        return oracleCollectionName;
    }

    private OracleColumnName createCursorName(String string, Object object) throws SQLException {
        OracleCursorName oracleCursorName = null;
        Vector vector = new Vector(5, 5);
        Vector vector2 = new Vector(5, 5);
        Vector vector3 = new Vector(5, 5);
        this.dset.cursorGetMetaData(object, vector, vector2, vector3);
        oracleCursorName = new OracleCursorName(string, object, vector.size());
        int n = 0;
        while (n < vector.size()) {
            OracleColumnName oracleColumnName = this.createColName((Integer)vector3.elementAt(n), this.convCase((String)vector.elementAt(n)), vector2.elementAt(n));
            oracleCursorName.setColumnName(n, oracleColumnName);
            ++n;
        }
        if (oracleCursorName != null) {
            this.colNamesHash.put(object, oracleCursorName);
        }
        return oracleCursorName;
    }

    private void createErrorDocument(OracleXMLDocGen oracleXMLDocGen, String string) {
        oracleXMLDocGen.createNewDocument(true);
        oracleXMLDocGen.setVersion(VERSION_NUM);
        oracleXMLDocGen.addTextElement(this.errTag, string, false);
    }

    private OracleColumnName createREFName(String string, Object object) throws SQLException {
        return new OracleScalarName(string, 2006, object);
    }

    private void genSchDTInfo(OracleXMLDocGen oracleXMLDocGen, OracleColumnName oracleColumnName) {
        int n = oracleColumnName.getColumnType();
        if (n == 2002 || n == 2003) {
            Object object = oracleColumnName.getBaseTypeObj();
            String string = this.dset.getTypesSchema(object);
            if (string.compareTo(this.thisUser) != 0) {
                oracleXMLDocGen.addNamespace(string, "#schema@name=" + string);
                oracleXMLDocGen.addAttribute(TYPE, String.valueOf(string) + ":" + this.dset.getTypesName(object));
            } else {
                oracleXMLDocGen.addAttribute(TYPE, this.dset.getTypesName(object));
            }
        } else {
            oracleXMLDocGen.addAttribute(TYPE, "dt:" + this.getSchDT(n));
        }
    }

    private void getADTObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = oracleColumnName.getLabel();
        OracleADTName oracleADTName = (OracleADTName)oracleColumnName;
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        int n2 = oracleADTName.getAttributeCount();
        int n3 = 0;
        while (n3 < n2) {
            OracleColumnName oracleColumnName2 = oracleADTName.getAttributeName(n3);
            stringBuffer.append(oracleColumnName2.getLabel());
            if (!this.useNullAttrId) {
                stringBuffer.append("?");
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        if (this.useNullAttrId) {
            stringBuffer.append(")?>\n");
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        } else {
            stringBuffer.append(")>\n");
        }
        int n4 = 0;
        while (n4 < n2) {
            OracleColumnName oracleColumnName3 = oracleADTName.getAttributeName(n4);
            this.getObjectDTD(oracleColumnName3, true, stringBuffer, n + 1);
            ++n4;
        }
    }

    public OracleColumnName[] getColNames() {
        return this.colNames;
    }

    private void getCollObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = oracleColumnName.getLabel();
        String string2 = String.valueOf(string) + this.collItemTag;
        OracleColumnName oracleColumnName2 = ((OracleCollectionName)oracleColumnName).getBaseColumnName();
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(string2);
        stringBuffer.append(")*>\n");
        if (this.collIdAttrName != null) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string2);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.collIdAttrName);
            stringBuffer.append(" CDATA #REQUIRED>\n");
        }
        if (this.useNullAttrId) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        if (oracleColumnName2.getColumnType() == 2006) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string2);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.refAttrName);
            stringBuffer.append(" NMTOKEN #FIXED ");
            stringBuffer.append("\"");
            stringBuffer.append(oracleColumnName2.getLabel());
            stringBuffer.append("\"");
            stringBuffer.append(">\n");
        }
        if (oracleColumnName2.getColumnType() == 2002) {
            this.getObjectDTD(oracleColumnName2, true, stringBuffer, n + 1);
        } else {
            stringBuffer.append(ELEMENT_NAME);
            stringBuffer.append(string2);
            stringBuffer.append(PCDATA_NAME);
            if (this.useNullAttrId) {
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string2);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.nullAttrId);
                stringBuffer.append(NULL_ATTR_VAL);
            }
        }
    }

    private void getCursorObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = oracleColumnName.getLabel();
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(" (");
        String string2 = String.valueOf(string) + "_" + this.convCase(ROW_TAG);
        stringBuffer.append(string2);
        stringBuffer.append(")*>\n");
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string2);
        stringBuffer.append(" (");
        OracleCursorName oracleCursorName = (OracleCursorName)oracleColumnName;
        int n2 = oracleCursorName.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            OracleColumnName oracleColumnName2 = oracleCursorName.getColumnName(n3);
            stringBuffer.append(oracleColumnName2.getLabel());
            if (!this.useNullAttrId) {
                stringBuffer.append("?");
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        if (this.useNullAttrId) {
            stringBuffer.append(")?>\n");
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        } else {
            stringBuffer.append(")>\n");
        }
        if (this.rowCountStr != null) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string2);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.convCase(ROWCOUNT));
            stringBuffer.append(" CDATA #REQUIRED>\n");
        }
        int n4 = 0;
        while (n4 < n2) {
            this.getObjectDTD(oracleCursorName.getColumnName(n4), true, stringBuffer, n + 1);
            ++n4;
        }
    }

    public String getDTD(OracleXMLDocGen oracleXMLDocGen) throws SQLException {
        int n;
        if (this.DTDString != null) {
            oracleXMLDocGen.appendDTD(this.DTDString);
            return this.DTDString;
        }
        int n2 = this.dset.getColumnCount();
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(1000);
        try {
            if (this.metaHeader != null) {
                OracleXMLConvert.ReaderToStrBuf(this.metaHeader, stringBuffer);
            } else if (this.useColumnLabelAsRoot) {
                stringBuffer.append("<!DOCTYPE ");
                stringBuffer.append(this.convCase(this.colNames[0].getLabel()));
                stringBuffer.append(" [\n");
            } else {
                stringBuffer.append("<!DOCTYPE ");
                stringBuffer.append(this.rowSetTag);
                stringBuffer.append(" [\n");
            }
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException, this.errTag);
        }
        if (!this.useColumnLabelAsRoot) {
            stringBuffer.append(ELEMENT_NAME);
            stringBuffer.append(this.rowSetTag);
            stringBuffer.append(" (");
            if (this.rowSepTag != null) {
                stringBuffer.append(this.rowSepTag);
                stringBuffer.append(")*>\n");
                stringBuffer.append(ELEMENT_NAME);
                stringBuffer.append(this.rowSepTag);
                stringBuffer.append(" (");
            }
            stringBuffer.append(this.convCase(this.dset.getColumnLabel(1)));
            if (n2 > 1 && !this.useNullAttrId && this.dset.isNullable(1) == 1) {
                stringBuffer.append("?");
            }
            n = 2;
            while (n <= n2) {
                stringBuffer.append(", ");
                stringBuffer.append(this.convCase(this.dset.getColumnLabel(n)));
                if (!this.useNullAttrId && this.dset.isNullable(n) == 1) {
                    stringBuffer.append("?");
                }
                ++n;
            }
            if (this.rowSepTag == null) {
                stringBuffer.append(")*>\n");
            } else {
                stringBuffer.append(")>\n");
                if (this.rowCountStr != null) {
                    stringBuffer.append(ATTLIST_NAME);
                    stringBuffer.append(this.rowSepTag);
                    stringBuffer.append(WHITESPACE);
                    stringBuffer.append(this.rowCountStr);
                    stringBuffer.append(" CDATA #REQUIRED>\n");
                }
            }
        }
        n = 1;
        while (n <= n2) {
            this.getObjectDTD(this.colNames[n - 1], this.dset.isNullable(n) == 1, stringBuffer, 1);
            ++n;
        }
        stringBuffer.append("]>\n");
        this.DTDString = stringBuffer.toString();
        oracleXMLDocGen.appendDTD(this.DTDString);
        return this.DTDString;
    }

    private void getObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        int n2 = oracleColumnName.getColumnType();
        switch (n2) {
            case 2002: {
                this.getADTObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case -10: {
                this.getCursorObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case 2006: {
                this.getREFObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            case 2003: {
                this.getCollObjectDTD(oracleColumnName, bl, stringBuffer, n);
                break;
            }
            default: {
                String string = oracleColumnName.getLabel();
                stringBuffer.append(ELEMENT_NAME);
                stringBuffer.append(string);
                stringBuffer.append(PCDATA_NAME);
                if (!this.useNullAttrId) break;
                stringBuffer.append(ATTLIST_NAME);
                stringBuffer.append(string);
                stringBuffer.append(WHITESPACE);
                stringBuffer.append(this.nullAttrId);
                if (bl) {
                    stringBuffer.append(NULL_ATTR_VAL);
                    break;
                }
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        if (this.collectTimingInfo) {
            this.tim.stop();
        }
    }

    private void getREFObjectDTD(OracleColumnName oracleColumnName, boolean bl, StringBuffer stringBuffer, int n) throws SQLException {
        String string = oracleColumnName.getLabel();
        stringBuffer.append(ELEMENT_NAME);
        stringBuffer.append(string);
        stringBuffer.append(PCDATA_NAME);
        if (this.useNullAttrId) {
            stringBuffer.append(ATTLIST_NAME);
            stringBuffer.append(string);
            stringBuffer.append(WHITESPACE);
            stringBuffer.append(this.nullAttrId);
            if (bl) {
                stringBuffer.append(NULL_ATTR_VAL);
            } else {
                stringBuffer.append(NULL_ATTR_VAL2);
            }
        }
        stringBuffer.append(ATTLIST_NAME);
        stringBuffer.append(string);
        stringBuffer.append(WHITESPACE);
        stringBuffer.append(this.refAttrName);
        stringBuffer.append(" NMTOKEN #FIXED ");
        stringBuffer.append("\"");
        stringBuffer.append(oracleColumnName.getBaseTypeObj());
        stringBuffer.append("\"");
        stringBuffer.append(">\n");
    }

    private String getSchDT(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return DTSTRING;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2006: {
                return DTBINHEX;
            }
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return DTNUMBER;
            }
            case 6: 
            case 7: 
            case 8: {
                return DTFLOAT;
            }
            case 91: 
            case 92: 
            case 93: {
                return DTDATETIME;
            }
            case -8: {
                return DTROWID;
            }
            case -13: {
                return DTBFILE;
            }
            case 2002: 
            case 2003: {
                return DTNAMEDTYPE;
            }
        }
        return null;
    }

    public void getSchema(OracleXMLDocGen oracleXMLDocGen) throws SQLException, OracleXMLSQLException {
        OracleXMLDocGen oracleXMLDocGen2;
        Object object;
        OracleColumnName oracleColumnName;
        Object object2;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Hashtable<Object, OracleXMLDocGen> hashtable = new Hashtable<Object, OracleXMLDocGen>(4);
        this.thisUser = this.dset.getConnUser();
        int n = this.dset.getColumnCount();
        OracleXMLDocGen oracleXMLDocGen3 = oracleXMLDocGen.newDocGenDoc(true);
        Object object6 = oracleXMLDocGen3.startNewElementWithAttr(SCHEMA_T, ELEMID, this.thisUser);
        hashtable.put(this.thisUser, oracleXMLDocGen3);
        oracleXMLDocGen3.addAttribute(NMSPC, W3CSFS);
        oracleXMLDocGen3.addNamespace(W3CDT, W3CSFDT);
        if (this.rowSetTag != null) {
            object4 = oracleXMLDocGen3.startNewElementWithAttr(ELEM, ELEMID, new String(this.rowSetTag));
        }
        if (this.rowSepTag != null) {
            object5 = oracleXMLDocGen3.startNewElementWithAttr(ELEM, ELEMID, new String(this.rowSepTag));
            oracleXMLDocGen3.addAttribute(MINO, "0");
            oracleXMLDocGen3.addAttribute(MAXO, "*");
            if (this.rowCountStr != null) {
                object2 = oracleXMLDocGen3.startNewElementWithAttr(ATTR, ELEMID, new String(this.rowCountStr));
                oracleXMLDocGen3.addAttribute(TYPE, "dt:" + this.getSchDT(this.rowIdAttrDt));
                oracleXMLDocGen3.endElement(object2);
            }
        }
        if (this.rowSetTag != null && this.rowSepTag == null && n == 1) {
            object3 = oracleXMLDocGen3.startNewElementWithAttr(ELEM, ELEMID, this.colNames[0].getLabel());
            this.genSchDTInfo(oracleXMLDocGen3, this.colNames[0]);
            oracleXMLDocGen3.addAttribute(MINO, "0");
            oracleXMLDocGen3.addAttribute(MAXO, "*");
            oracleXMLDocGen3.endElement(object3);
        } else {
            int n2 = 0;
            while (n2 < n) {
                oracleColumnName = this.colNames[n2];
                object3 = oracleXMLDocGen3.startNewElementWithAttr(ELEM, ELEMID, oracleColumnName.getLabel());
                this.genSchDTInfo(oracleXMLDocGen3, oracleColumnName);
                oracleXMLDocGen3.addAttribute(MINO, "0");
                oracleXMLDocGen3.endElement(object3);
                ++n2;
            }
        }
        if (this.rowSepTag != null) {
            oracleXMLDocGen3.endElement(object5);
        }
        if (this.rowSetTag != null) {
            oracleXMLDocGen3.endElement(object4);
        }
        object2 = this.colNamesHash.elements();
        while (object2.hasMoreElements()) {
            OracleColumnName oracleColumnName2;
            oracleColumnName = (OracleColumnName)object2.nextElement();
            Object object7 = oracleColumnName.getBaseTypeObj();
            object = this.dset.getTypesSchema(object7);
            oracleXMLDocGen2 = (OracleXMLDocGen)hashtable.get(object);
            if (oracleXMLDocGen2 == null) {
                oracleXMLDocGen2 = oracleXMLDocGen.newDocGenDoc(true);
                hashtable.put(object, oracleXMLDocGen2);
                oracleXMLDocGen2.startNewElementWithAttr(SCHEMA_T, ELEMID, (String)object);
                oracleXMLDocGen2.addAttribute(NMSPC, W3CSFS);
                oracleXMLDocGen2.addNamespace(W3CDT, W3CSFDT);
            }
            oracleXMLDocGen2.startNewElementWithAttr(TYPE, ELEMID, this.dset.getTypesName(object7));
            if (oracleColumnName.getColumnType() == 2002) {
                oracleColumnName2 = (OracleADTName)oracleColumnName;
                int n3 = 0;
                while (n3 < ((OracleADTName)oracleColumnName2).getAttributeCount()) {
                    oracleColumnName = ((OracleADTName)oracleColumnName2).getAttributeName(n3);
                    object3 = oracleXMLDocGen2.startNewElementWithAttr(ELEM, ELEMID, oracleColumnName.getLabel());
                    this.genSchDTInfo(oracleXMLDocGen2, oracleColumnName);
                    oracleXMLDocGen2.endElement(object3);
                    ++n3;
                }
            } else {
                oracleColumnName2 = (OracleCollectionName)oracleColumnName;
                oracleColumnName = ((OracleCollectionName)oracleColumnName2).getBaseColumnName();
                oracleXMLDocGen2.startNewElementWithAttr(ELEM, ELEMID, String.valueOf(this.dset.getTypesName(object7)) + COLL_ITEM_TAG);
                this.genSchDTInfo(oracleXMLDocGen2, oracleColumnName);
                oracleXMLDocGen2.addAttribute(MAXO, "*");
                if (this.collIdAttrName != null) {
                    oracleXMLDocGen2.startNewElementWithAttr(ATTR, ELEMID, new String(this.collIdAttrName));
                    oracleXMLDocGen2.addAttribute(TYPE, "dt:Number");
                    oracleXMLDocGen2.endElement(null);
                }
                oracleXMLDocGen2.endElement(null);
            }
            oracleXMLDocGen2.endElement(null);
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            oracleXMLDocGen2 = (OracleXMLDocGen)object.nextElement();
            oracleXMLDocGen2.endElement(null);
            oracleXMLDocGen.docAppend(oracleXMLDocGen2);
        }
    }

    public String getTimingInfo() {
        if (this.tim == null) {
            return "No timing result to display. Execute getXML first before";
        }
        return this.tim.getResult();
    }

    private void getXML(OracleXMLDocGen oracleXMLDocGen) {
        boolean bl = false;
        boolean bl2 = this.noRowsException ^ true;
        try {
            int n = this.dset.getColumnCount();
            if (!this.rootNodeSupplied || this.dataHeader != null) {
                if (this.rowSetTag == null && this.rowSepTag != null) {
                    if (n != 1) {
                        throw new OracleXMLSQLException(msg.getMessage0("XSUE-0005"), this.errTag);
                    }
                    this.useColumnLabelAsRoot = true;
                } else if (this.rowSetTag == null) {
                    this.rowSetTag = this.rowSepTag;
                    this.rowSepTag = null;
                    this.rowCountStr = null;
                }
            }
            if (!this.rootNodeSupplied && this.docType != 0) {
                oracleXMLDocGen.setVersion(VERSION_NUM);
            }
            if (this.styleSheetURI != null) {
                oracleXMLDocGen.createProcessingInstruction(STYLESHEET_TARGET, "href=\"" + this.styleSheetURI + "\" type=\"" + this.styleSheetType + "\"");
            }
            if (this.tim == null) {
                this.tim = new OracleXMLTimer();
            }
            if (this.collectTimingInfo) {
                this.tim.start("TOTAL GENERATION TIME ----", 0);
                this.tim.start("DTD generation (getDTD)", 0);
            }
            if (this.metaType != 0 || !this.dset.isEmpty()) {
                this.createColNames();
                this.validateNames();
            }
            if (this.metaType == 1 && oracleXMLDocGen.supportMetatype(this.metaType) && !this.rootNodeSupplied) {
                this.getDTD(oracleXMLDocGen);
            }
            if (this.collectTimingInfo) {
                this.tim.stop();
            }
            Object object = null;
            Object object2 = null;
            if (this.metaType == 2) {
                object = oracleXMLDocGen.startNewElement(DOC_T);
                this.getSchema(oracleXMLDocGen);
            }
            if (this.dataHeader != null && this.docType == 1) {
                object2 = oracleXMLDocGen.startNewElement(this.docTag);
                oracleXMLDocGen.insertXMLFragment(this.dataHeader);
            }
            if (this.collectTimingInfo) {
                this.tim.start("Row to XML conversion", 0);
            }
            if (this.docType == 1) {
                Object object3 = null;
                if (this.rowSetTag != null) {
                    object3 = oracleXMLDocGen.startNewElement(this.rowSetTag);
                }
                if (this.skipRows != -1 && this.maxRows != 0 && !this.dset.isEmpty()) {
                    Object object4 = null;
                    int n2 = 0;
                    while (n2 < this.skipRows && this.dset.fetchNextRow()) {
                        ++this.rowCount;
                        ++n2;
                    }
                    n2 = 1;
                    while ((this.maxRows == -1 || n2 <= this.maxRows) && this.dset.fetchNextRow()) {
                        if (n2 > 1) {
                            if (this.useColumnLabelAsRoot) {
                                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0005"), this.errTag);
                            }
                            if (this.rowSepTag == null && n > 1) {
                                throw new OracleXMLSQLException(msg.getMessage0("XSUE-0006"), this.errTag);
                            }
                        }
                        if (this.rowSepTag != null) {
                            if (this.rowCountStr != null) {
                                int n3;
                                String string = this.rowIdColNum != 0 && this.dset.getObject(this.rowIdColNum) != null ? ((n3 = this.colNames[this.rowIdColNum - 1].getColumnType()) >= 91 && n3 <= 93 ? this.dset.getDateString(this.dset.getObject(this.rowIdColNum)) : this.dset.getScalarStrValue(this.dset.getObject(this.rowIdColNum))) : Integer.toString(this.rowCount);
                                object4 = oracleXMLDocGen.startNewElementWithAttr(this.rowSepTag, this.rowCountStr, string);
                            } else {
                                object4 = oracleXMLDocGen.startNewElement(this.rowSepTag);
                            }
                        }
                        this.convertRow(this.dset, oracleXMLDocGen);
                        bl2 = true;
                        if (this.rowSepTag != null) {
                            oracleXMLDocGen.endElement(object4);
                        }
                        ++this.rowCount;
                        ++n2;
                    }
                }
                if (this.rowSetTag != null) {
                    oracleXMLDocGen.endElement(object3);
                }
            }
            if (this.collectTimingInfo) {
                this.tim.stop();
                this.tim.stop();
            }
            if (!bl2) {
                throw new OracleXMLSQLNoRowsException(this.errTag);
            }
            if (this.dataHeader != null && this.docType == 1) {
                oracleXMLDocGen.endElement(object2);
            }
            if (this.metaType == 2) {
                oracleXMLDocGen.endElement(object);
            }
        }
        catch (OracleXMLSQLNoRowsException oracleXMLSQLNoRowsException) {
            throw (OracleXMLSQLNoRowsException)oracleXMLSQLNoRowsException.fillInStackTrace();
        }
        catch (Exception exception) {
            if (exception instanceof OracleXMLSQLException) {
                throw (OracleXMLSQLException)exception.fillInStackTrace();
            }
            throw new OracleXMLSQLException(exception, this.errTag);
        }
    }

    public void keepObjectOpen(boolean bl) {
        this.keepCursor = bl;
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
            XSUMesg xSUMesg = new XSUMesg();
            throw new OracleXMLSQLException("parse: " + xSUMesg.getMessage1("XSUE-0001", xSUMesg.getMessage0("XSUE-0007")));
        }
        int n = string.length();
        int n2 = string.indexOf("\"");
        int n3 = string.indexOf("\"", n2 + 1);
        int n4 = -1;
        if (n2 < 0) {
            n4 = string.indexOf(".");
            if (n4 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n4);
            stringArray2[0] = string.substring(n4 + 1);
            return true;
        }
        if (n2 == 0) {
            if (n3 == n - 1) {
                stringArray2[0] = string.substring(n2 + 1, n3);
                return false;
            }
            n4 = string.indexOf(".", n3);
            stringArray[0] = string.substring(n2 + 1, n3);
            n2 = string.indexOf("\"", n4);
            n3 = string.indexOf("\"", n2 + 1);
            if (n2 < 0) {
                stringArray2[0] = string.substring(n4 + 1);
                return true;
            }
            stringArray2[0] = string.substring(n2 + 1, n3);
            return true;
        }
        n4 = string.indexOf(".");
        stringArray[0] = string.substring(0, n4);
        stringArray2[0] = string.substring(n2 + 1, n3);
        return true;
    }

    private int parseDotedStr(String string, String[] stringArray) {
        int n = 0;
        int n2 = string.indexOf(46);
        int n3 = 0;
        while (n2 != -1 && n3 < stringArray.length) {
            stringArray[n3++] = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        if (n < string.length() && n3 < stringArray.length) {
            stringArray[n3++] = string.substring(n, string.length() - 1);
        }
        return n3;
    }

    public void setColNames(OracleColumnName[] oracleColumnNameArray) {
        this.colNames = oracleColumnNameArray;
    }

    public void setCollIdAttrName(String string) {
        this.collIdAttrName = string == null || string.length() == 0 ? null : string;
    }

    public void setDataHeader(Reader reader, String string) {
        this.dataHeader = reader;
        String string2 = this.docTag = string == null ? DOC_T : string;
        if (this.dataHeader == null) {
            return;
        }
        try {
            this.dataHeader.mark(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            this.setException(iOException);
        }
    }

    public void setDateFormat(String string) {
        this.dateFormat = string == null || string.length() == 0 ? null : string;
        this.updateDateFormat = true;
    }

    public void setDocType(int n) {
        this.docType = n;
    }

    public void setErrorTag(String string) {
        if (string != null && string.length() != 0) {
            this.errTag = string;
        }
    }

    public void setException(Exception exception) {
        this.extException = exception;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setMetaHeader(Reader reader) {
        this.metaHeader = reader;
        this.DTDString = null;
        if (this.metaHeader == null) {
            return;
        }
        try {
            this.metaHeader.mark(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            this.setException(iOException);
        }
    }

    public void setMiscFlags(int n) {
        this.miscFlags = n;
    }

    public void setRaiseException(boolean bl) {
        this.raiseException = bl;
    }

    public void setRaiseNoRowsException(boolean bl) {
        this.noRowsException = bl;
    }

    public void setRootNodeSupplied(boolean bl) {
        this.rootNodeSupplied = bl;
    }

    public void setRowIdAttrName(String string) {
        this.rowCountStr = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setRowIdAttrValue(String string) {
        this.rowIdColName = null;
        if (string == null || string.length() == 0) {
            this.rowIdColNum = 0;
            return;
        }
        if (this.dset == null) {
            this.rowIdColName = string;
            return;
        }
        try {
            int n = this.dset.getColumnCount();
            while (n > 0) {
                if (this.dset.getColumnName(n).compareTo(string) == 0) {
                    this.rowIdAttrDt = this.dset.getColumnType(n);
                    if (this.rowIdAttrDt != 1 && this.rowIdAttrDt != 12 && this.rowIdAttrDt != 2 && this.rowIdAttrDt != 3 && this.rowIdAttrDt != 4 && this.rowIdAttrDt != 91 && this.rowIdAttrDt != 93) {
                        throw new OracleXMLSQLException(msg.getMessage1("XSUE-0002", string), this.errTag);
                    }
                    this.rowIdColNum = n;
                    return;
                }
                --n;
            }
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException, this.errTag);
        }
        throw new OracleXMLSQLException(msg.getMessage1("XSUE-0003", string), this.errTag);
    }

    public void setRowTag(String string) {
        this.rowSepTag = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setRowsetTag(String string) {
        this.rowSetTag = string == null || string.length() == 0 ? null : string;
        this.namesValid = false;
    }

    public void setSkipRows(int n) {
        this.skipRows = n;
    }

    public void setStylesheetHeader(String string) {
        this.styleSheetURI = string;
        this.styleSheetType = STYLESHEET_TYPE_DATA;
    }

    public void setStylesheetHeader(String string, String string2) {
        this.styleSheetURI = string;
        this.styleSheetType = string2;
    }

    public void setTagNameCase(int n) {
        if (n != this.tagCase) {
            this.tagCase = n;
            this.errTag = this.convCase(this.errTag);
            this.rowSetTag = this.convCase(this.rowSetTag);
            this.rowSepTag = this.convCase(this.rowSepTag);
            this.docTag = this.convCase(this.docTag);
            this.rowCountStr = this.convCase(this.rowCountStr);
            this.refAttrName = this.convCase(this.refAttrName);
            this.collIdAttrName = this.convCase(this.collIdAttrName);
            this.collItemTag = this.convCase(this.collItemTag);
            this.nullAttrId = this.convCase(this.nullAttrId);
            this.DTDString = null;
            this.colNames = null;
            this.colNamesHash = null;
        }
    }

    public void useNullAttrId(boolean bl) {
        if (this.useNullAttrId != bl) {
            this.DTDString = null;
            this.colNames = null;
            this.colNamesHash = null;
            this.useNullAttrId = bl;
        }
    }

    public static void validateName(String string) {
        if (string == null) {
            return;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                throw new OracleXMLSQLException(new XSUMesg().getMessage1("XSUE-0008", string.substring(n, n + 1)));
            }
            --n;
        }
    }

    private void validateNames() {
        if (this.namesValid) {
            return;
        }
        OracleXMLConvert.validateName(this.rowCountStr);
        OracleXMLConvert.validateName(this.rowSetTag);
        OracleXMLConvert.validateName(this.rowSepTag);
    }
}

