/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.core;

import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenDOM;
import oracle.xml.sql.docgen.OracleXMLDocGenString;
import oracle.xml.sql.name.OracleColumnName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OracleXMLUtil {
    Connection conn;
    DOMParser parser = null;
    OracleColumnName[] colNames = null;
    OracleXMLDataSetExtJdbc dset = null;
    OracleXMLConvert conv = null;

    public OracleXMLUtil(Connection connection) {
        this.conn = connection;
        this.colNames = new OracleColumnName[1];
        this.dset = new OracleXMLDataSetExtJdbc(connection);
        this.conv = new OracleXMLConvert(connection, this.dset);
        this.conv.setMiscFlags(2);
    }

    public STRUCT getStructFromXML(InputStream inputStream, String string) {
        try {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)string, (Connection)this.conn);
            if (this.parser == null) {
                this.parser = new DOMParser();
                this.parser.setErrorStream((OutputStream)System.err);
                this.parser.showWarnings(false);
            }
            this.parser.parse(inputStream);
            XMLDocument xMLDocument = this.parser.getDocument();
            Element element = xMLDocument.getDocumentElement();
            return this.getStructFromXML(element, string);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public STRUCT getStructFromXML(String string, String string2) {
        return this.getStructFromXML(new ByteArrayInputStream(string.getBytes()), string2);
    }

    public STRUCT getStructFromXML(Node node, String string) {
        try {
            this.colNames[0] = this.conv.createADTName(string, string);
            OracleXMLSave oracleXMLSave = new OracleXMLSave(this.conn, this.colNames);
            return oracleXMLSave.getStructVal(node, this.colNames[0]);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public CLOB getXMLClobFromStruct(STRUCT sTRUCT, String string) {
        try {
            String string2 = "DBMS_LOB.SESSION";
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(" declare x CLOB := null;  begin dbms_lob.createtemporary(x,FALSE," + string2 + ");" + " ? := x; end;");
            oracleCallableStatement.registerOutParameter(1, 2005);
            oracleCallableStatement.execute();
            CLOB cLOB = oracleCallableStatement.getCLOB(1);
            OutputStream outputStream = cLOB.getAsciiOutputStream();
            this.getXMLStrmFromStruct(sTRUCT, string, outputStream);
            oracleCallableStatement.close();
            return cLOB;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public XMLDocument getXMLDOMFromStruct(STRUCT sTRUCT, String string) {
        try {
            OracleXMLDocGenDOM oracleXMLDocGenDOM = new OracleXMLDocGenDOM();
            this.getXMLFromStruct(oracleXMLDocGenDOM, sTRUCT, string);
            return (XMLDocument)oracleXMLDocGenDOM.getXMLDocumentDOM();
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public void getXMLFromStruct(STRUCT sTRUCT, Node node, String string) {
        try {
            OracleXMLDocGenDOM oracleXMLDocGenDOM = new OracleXMLDocGenDOM(node);
            this.getXMLFromStruct(oracleXMLDocGenDOM, sTRUCT, string);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    private void getXMLFromStruct(OracleXMLDocGen oracleXMLDocGen, STRUCT sTRUCT, String string) throws Exception {
        String string2 = sTRUCT.getSQLTypeName();
        if (string == null) {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            stringArray[0] = null;
            stringArray2[0] = null;
            OracleXMLConvert.parse(string2, stringArray, stringArray2);
            string = stringArray2[0];
        }
        oracleXMLDocGen.createNewDocument(false);
        oracleXMLDocGen.setVersion("1.0");
        this.colNames[0] = this.conv.createADTName(string, string2);
        this.conv.convertADTObject(this.colNames[0], sTRUCT, oracleXMLDocGen, 1, -1);
    }

    public String getXMLStringFromStruct(STRUCT sTRUCT, String string) {
        try {
            OracleXMLDocGenString oracleXMLDocGenString = new OracleXMLDocGenString();
            this.getXMLFromStruct(oracleXMLDocGenString, sTRUCT, string);
            return oracleXMLDocGenString.getXMLDocumentString();
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public void getXMLStrmFromStruct(STRUCT sTRUCT, String string, OutputStream outputStream) {
        try {
            XMLDocument xMLDocument = this.getXMLDOMFromStruct(sTRUCT, string);
            xMLDocument.print(outputStream);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            throw (OracleXMLSQLException)oracleXMLSQLException.fillInStackTrace();
        }
        catch (Exception exception) {
            throw new OracleXMLSQLException(exception, "ERROR");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection("jdbc:oracle:oci8:@", "scott", "tiger");
        if (stringArray.length > 0) {
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            string2 = "/tmp/emp";
            string = "EMP_T";
        }
        FileReader fileReader = new FileReader(string2);
        char[] cArray = new char[1000];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1000);
        while ((n = fileReader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        OracleXMLUtil oracleXMLUtil = new OracleXMLUtil(connection);
        STRUCT sTRUCT = oracleXMLUtil.getStructFromXML(stringBuffer.toString(), string);
        CLOB cLOB = oracleXMLUtil.getXMLClobFromStruct(sTRUCT, null);
        char[] cArray2 = new char[(int)cLOB.length()];
        cLOB.getChars(1L, (int)cLOB.length(), cArray2);
        System.out.println("returned XML (CLOB) is " + new String(cArray2));
        System.out.println("returned XML is " + oracleXMLUtil.getXMLStringFromStruct(sTRUCT, "ENCL_TAG"));
    }
}

