/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ACPOptions
extends AdminProp {
    static final int PR_ACP_DEFAULT = 0x803000;
    static final int PR_ACP_CUSTOM = 8400897;
    public Boolean m_defaultacp;
    public Boolean m_customacp;
    public Server m_server;
    public AdminProp m_holder;

    public ACPOptions(Server server, AdminProp adminProp) {
        this.m_server = server;
        this.m_holder = adminProp;
        this.m_defaultacp = new Boolean(true);
        this.m_customacp = new Boolean(false);
        try {
            this.init();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_defaultacp.booleanValue()) {
            this.m_server.setAcpOption(new Integer(0));
        } else if (this.m_customacp.booleanValue()) {
            this.m_server.setAcpOption(new Integer(1));
        }
        this.m_server.getServerList().getCfgFile().saveData();
        SaveChangeException saveChangeException = new SaveChangeException(LDAPLang.getStrWarnPreferences());
        saveChangeException.setNotice();
        this.m_holder.makeInvalid();
        throw saveChangeException;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x803000, LDAPLang.getStrACPPref1(), LDAPLang.getStrACPPref1());
        this.registerProp(8400897, LDAPLang.getStrACPPref2(), LDAPLang.getStrACPPref2());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "setacpmngmnt";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                return null;
            }
            case 0x110001: {
                return LDAPLang.getStrACPConfiguration();
            }
            case 2032706: {
                return null;
            }
            case 3080204: {
                return new Integer(8192);
            }
            case 2687386: {
                return new Integer(0x200000);
            }
            case 0x803000: {
                return this.m_defaultacp;
            }
            case 8400897: {
                return this.m_customacp;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x803000: {
                this.m_defaultacp = (Boolean)object;
                return;
            }
            case 8400897: {
                this.m_customacp = (Boolean)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void init() throws PropertyException {
        int n = 0;
        if (this.m_server != null) {
            n = this.m_server.getAcpOption();
        }
        if (n == 0) {
            this.m_defaultacp = new Boolean(true);
            return;
        }
        this.m_customacp = new Boolean(true);
    }
}

