/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.ACPsMgmt;
import oracle.ldap.admin.AccessCtrlPoints;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.PathSelector;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class ACPsSearch
extends AdminProp {
    static final int PR_SEARCH_ROOT = 0x103000;
    static final int PR_SEARCH_ROOT_READONLY = 1454081;
    static final int PR_SIZELIMIT = 0x203002;
    static final int PR_TIMELIMIT = 0x203003;
    static final int PR_SEARCH_TYPE = 1060868;
    static final int PR_SEARCH_TYPE_READONLY = 1454085;
    public static String[] m_searchTypes = null;
    Root m_parent;
    ACPsMgmt m_manager;
    AccessCtrlPoints m_acps;
    String m_searchRoot;
    int m_sizeLimit = 200;
    int m_timeLimit = 360;
    String m_searchType;

    public ACPsSearch(Root root, AccessCtrlPoints accessCtrlPoints) {
        this.m_parent = root;
        this.m_acps = accessCtrlPoints;
        try {
            this.m_searchType = (String)accessCtrlPoints.getProp(1060866);
            this.m_searchRoot = accessCtrlPoints.getBasedn();
            this.m_sizeLimit = accessCtrlPoints.getSizeLimit();
            this.m_timeLimit = accessCtrlPoints.getTimeLimit();
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.registerProp(1454081, LDAPLang.getStrBasednPlbl(), LDAPLang.getStrBasednPdsc());
        this.registerProp(1454085, LDAPLang.getStrSearchTypePlbl(), LDAPLang.getStrSearchTypePdsc());
    }

    public ACPsSearch(Root root, ACPsMgmt aCPsMgmt) {
        this.m_parent = root;
        this.m_manager = aCPsMgmt;
        if (m_searchTypes == null) {
            m_searchTypes = new String[2];
            ACPsSearch.m_searchTypes[0] = LDAPLang.getStrSrctypeOnelevel();
            ACPsSearch.m_searchTypes[1] = LDAPLang.getStrSrctypeSubtree();
        }
        this.m_searchType = m_searchTypes[0];
        this.registerProp(0x103000, LDAPLang.getStrBasednPlbl(), LDAPLang.getStrBasednPdsc());
        this.registerPropListOfValues(0x103000, new PathSelector(this.m_parent));
        this.registerProp(1060868, LDAPLang.getStrSearchTypePlbl(), LDAPLang.getStrSearchTypePdsc());
        this.registerPropListOfValues(1060868, m_searchTypes);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "setacpsearch";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3080204: {
                return new Integer(16);
            }
            case 2687386: {
                Integer n2 = (Integer)super.getProp(n);
                if (n2 != null) {
                    return new Integer((int)(n2 | 0x100000));
                }
                return new Integer(0x100000);
            }
            case 3081366: {
                return new Integer(12);
            }
            case 2031768: {
                return LDAPLang.getStrConfigureACPsSearch();
            }
            case 0x103000: {
                return this.m_searchRoot;
            }
            case 1454081: {
                if (this.m_searchRoot == null || this.m_searchRoot.length() == 0) {
                    return "DSE Root";
                }
                return this.m_searchRoot;
            }
            case 0x203002: {
                return new Integer(this.m_sizeLimit);
            }
            case 0x203003: {
                return new Integer(this.m_timeLimit);
            }
            case 1060868: 
            case 1454085: {
                return this.m_searchType;
            }
            case 2163876: {
                return new Integer(50);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x103000: {
                this.m_searchRoot = (String)object;
                return;
            }
            case 0x203002: {
                this.m_sizeLimit = (Integer)object;
                return;
            }
            case 0x203003: {
                this.m_timeLimit = (Integer)object;
                return;
            }
            case 1060868: {
                this.m_searchType = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x203002, LDAPLang.getStrMaxResultsPlbl(), LDAPLang.getStrMaxResultsPdsc());
        this.registerProp(0x203003, LDAPLang.getStrMaxTimePlbl(), LDAPLang.getStrMaxTimePdsc());
        this.registerPropRange(0x203003, 25, 3600);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_searchRoot == null) {
            this.m_searchRoot = "";
        }
        try {
            if (this.m_manager != null) {
                String string = this.m_searchRoot;
                if (this.m_searchRoot == null || this.m_searchRoot.length() == 0) {
                    string = "DSE Root";
                }
                String string2 = String.valueOf(this.m_searchType) + " " + LDAPLang.getStrACPsUnder() + "\"" + string + "\"";
                AccessCtrlPoints accessCtrlPoints = new AccessCtrlPoints(this.m_parent, string2, this.m_searchRoot, this.m_sizeLimit, this.m_timeLimit, this.m_searchType);
                accessCtrlPoints.loadACPs();
                this.m_manager.addChild(accessCtrlPoints);
                this.m_manager.sendAdminPropertyChangeEvents(273612805, null);
                this.m_manager.sendAdminPropertyChangeEvents(273219601, null);
                Server server = this.m_parent.getCurrentServer();
                server.addAcpsSearch(accessCtrlPoints.toLine());
                this.m_parent.saveData();
            }
            if (this.m_acps != null) {
                this.m_acps.setSizeLimit(this.m_sizeLimit);
                this.m_acps.setTimeLimit(this.m_timeLimit);
                this.m_acps.setProp(1060866, (Object)this.m_searchType);
                this.m_acps.refresh();
                return;
            }
        }
        catch (PropertyException propertyException) {
            throw new SaveChangeException(propertyException);
        }
    }
}

