/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import oracle.ldap.admin.AccessList;
import oracle.ldap.admin.ByWhomPermission;
import oracle.ldap.admin.ByWhomPermissions;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SelectAccessByWhom;
import oracle.ldap.admin.SelectAccessPermissions;
import oracle.ldap.admin.SelectAccessToWhat;
import oracle.ldap.admin.StructBindMode;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AccessItem
extends AdminProp
implements ICommandParent {
    static final int PR_TO_WHAT = 0x103001;
    static final int PR_FILTER = 1060866;
    static final int PR_BY_WHOM = 0x113100;
    static final int PR_ACCESS_RIGHT = 1126912;
    static final int PR_USER_RIGHTS = 0x113300;
    static final int PR_USERS = 0x103301;
    static final int PR_ATTRIBUTE = 1061634;
    static final int PR_BINDMODES = 0x113303;
    static final int PR_RIGHTS = 1061636;
    static final int PR_LDIF = 12006149;
    static final int DELETE_CMD = -9;
    static final int SHOW_LDIF_CMD = 16;
    AccessList m_accessList;
    SelectAccessToWhat m_toWhat;
    ByWhomPermissions m_bySubjects;
    String m_userRights;
    String m_orgACIStr;
    boolean debug;
    Root m_parent;
    private boolean m_convertOk = true;

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103001, LDAPLang.getStrToWhatPlbl(), LDAPLang.getStrToWhatPdsc());
        this.registerProp(0x113100, LDAPLang.getStrByWhomPlbl(), LDAPLang.getStrByWhomPdsc());
        this.registerProp(1126912, LDAPLang.getStrAccessRightPlbl(), LDAPLang.getStrAccessRightPdsc());
        this.registerProp(0x113300, LDAPLang.getStrUserRightsPlbl(), LDAPLang.getStrUserRightsPdsc());
        this.registerProp(0x103301, LDAPLang.getStrByWhomPlbl(), LDAPLang.getStrUserRightsPdsc());
        this.registerProp(0x113303, LDAPLang.getStrBindmodesPlbl(), LDAPLang.getStrBindmodesPdsc());
        this.registerProp(1061636, LDAPLang.getStrAccessRightPlbl(), LDAPLang.getStrRightsPdsc());
        this.registerProp(12006149, LDAPLang.getStrLdifPlbl(), LDAPLang.getStrLdifPdsc());
    }

    public AccessItem() {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
    }

    public AccessItem(Root root, AccessList accessList) {
        this.setParent(root);
        this.init(root, accessList);
        this.m_toWhat = new SelectAccessToWhat(this, null, this.m_bySubjects);
    }

    public AccessItem(Root root, String string, int[] nArray, AccessList accessList) {
        this.setParent(root);
        this.init(root, accessList);
        this.m_orgACIStr = string;
        this.parseAccessDefinition(nArray, string, false);
    }

    public String getThisEntry() {
        return this.m_accessList.getThisEntry();
    }

    void init(Root root, AccessList accessList) {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
        this.m_accessList = accessList;
        this.m_bySubjects = new ByWhomPermissions(root, this);
    }

    public Root getParent() {
        return this.m_parent;
    }

    public void setParent(Root root) {
        this.m_parent = root;
    }

    public Object getProp(int n) throws PropertyException {
        int n2 = 0;
        switch (n) {
            case 1048745: {
                return "adding_and_modifying_access_control_items";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/ldapaci.gif";
            }
            case 2031768: {
                return "Access Item";
            }
            case 4784130: {
                return this.m_parent;
            }
            case 0x110001: {
                return this.toString();
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                return new Integer(3178502);
            }
            case 2163790: {
                return new Integer(0);
            }
            case 273612805: {
                return this.m_bySubjects.getProp(273219601);
            }
            case 272630352: {
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_toWhat, this.m_bySubjects};
                return iAdminPropArray;
            }
            case 275776081: {
                GridBagConstraints[] gridBagConstraintsArray = new GridBagConstraints[3];
                n2 = 0;
                gridBagConstraintsArray[n2] = new GridBagConstraints();
                gridBagConstraintsArray[n2].gridx = 1;
                gridBagConstraintsArray[n2].gridy = n2;
                gridBagConstraintsArray[n2].weighty = 0.0;
                gridBagConstraintsArray[n2].weightx = 1.0;
                gridBagConstraintsArray[n2].fill = 1;
                gridBagConstraintsArray[n2].anchor = 18;
                gridBagConstraintsArray[n2].gridwidth = 0;
                gridBagConstraintsArray[++n2] = new GridBagConstraints();
                gridBagConstraintsArray[n2].gridx = 1;
                gridBagConstraintsArray[n2].gridy = n2;
                gridBagConstraintsArray[n2].weighty = 1.0;
                gridBagConstraintsArray[n2].weightx = 1.0;
                gridBagConstraintsArray[n2].fill = 1;
                gridBagConstraintsArray[n2].anchor = 18;
                gridBagConstraintsArray[n2].gridwidth = 0;
                gridBagConstraintsArray[n2].gridheight = -1;
                gridBagConstraintsArray[++n2] = new GridBagConstraints();
                gridBagConstraintsArray[n2].gridx = 1;
                gridBagConstraintsArray[n2].gridy = n2;
                gridBagConstraintsArray[n2].weighty = 0.0;
                gridBagConstraintsArray[n2].weightx = 1.0;
                gridBagConstraintsArray[n2].fill = 2;
                gridBagConstraintsArray[n2].anchor = 18;
                gridBagConstraintsArray[n2].gridwidth = 0;
                gridBagConstraintsArray[n2].gridheight = 0;
                return gridBagConstraintsArray;
            }
            case 2687386: {
                return new Integer(48);
            }
            case 12006149: {
                return this.toLDIF();
            }
            case 2687130: {
                return new Integer(this.m_bySubjects.countChildren() + 1);
            }
            case 2032714: {
                return "\n";
            }
            case 1060866: {
                return this.m_toWhat.getFilter();
            }
            case 1061634: {
                return this.m_toWhat.getAttribute();
            }
            case 0x103001: {
                return this.m_toWhat.toString();
            }
            case 0x103301: {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                int n4 = this.m_bySubjects.countChildren();
                while (n3 < n4) {
                    ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n3);
                    String string = (String)byWhomPermission.getProp(1585152);
                    stringBuffer.append("by " + string);
                    if (n3 + 1 < n4) {
                        stringBuffer.append("\n");
                    }
                    ++n3;
                }
                return stringBuffer.toString();
            }
            case 0x113303: {
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = 0;
                int n6 = this.m_bySubjects.countChildren();
                while (n5 < n6) {
                    ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n5);
                    String string = (String)byWhomPermission.getProp(1650690);
                    stringBuffer.append(string);
                    if (n5 + 1 < n6) {
                        stringBuffer.append("\n");
                    }
                    ++n5;
                }
                return stringBuffer.toString();
            }
            case 1061636: {
                if (this.m_bySubjects == null) {
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n7 = 0;
                int n8 = this.m_bySubjects.countChildren();
                while (n7 < n8) {
                    ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n7);
                    String string = (String)byWhomPermission.getProp(1585153);
                    stringBuffer.append(string);
                    if (n7 + 1 < n8) {
                        stringBuffer.append("\n");
                    }
                    ++n7;
                }
                return stringBuffer.toString();
            }
            case 0x113300: {
                return this.m_userRights;
            }
            case 273613891: {
                IAdminProp[] iAdminPropArray = new IAdminProp[1];
                iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrDeleteLabel2(), LDAPLang.getStrDeleteDesc1(), "images/delete.gif");
                iAdminPropArray[n2 - 1].setProp(1639168, "Please confirm deletion.");
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    public String[] getUsers() {
        int n = this.m_bySubjects.countChildren();
        if (n == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n2);
            try {
                String string;
                stringArray[n2] = string = (String)byWhomPermission.getProp(1585152);
            }
            catch (Exception exception) {
                stringArray[n2] = "*";
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getBindModes() {
        int n = this.m_bySubjects.countChildren();
        if (n == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n2);
            try {
                stringArray[n2] = (String)byWhomPermission.getProp(1650690);
            }
            catch (Exception exception) {
                stringArray[n2] = StructBindMode.DEFAULT_BIND_MODE;
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getUserPermissions() {
        int n = this.m_bySubjects.countChildren();
        if (n == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n2);
            try {
                stringArray[n2] = (String)byWhomPermission.getProp(1585153);
            }
            catch (Exception exception) {
                stringArray[n2] = "";
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getAttributes() {
        return this.m_toWhat.getAttributes();
    }

    public String getAttrOp() {
        return this.m_toWhat.getAttrOp();
    }

    public String getAccessRights() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.m_bySubjects.countChildren();
        while (n < n2) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n);
            try {
                String string = (String)byWhomPermission.getProp(1585153);
                stringBuffer.append(string);
                if (n + 1 < n2) {
                    stringBuffer.append(",");
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getFilter() {
        return this.m_toWhat.getFilter();
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 2163220: 
            case 2163740: {
                this.m_bySubjects = new ByWhomPermissions(this.m_parent, this);
                this.m_toWhat = new SelectAccessToWhat(this, null, this.m_bySubjects);
                int[] nArray = new int[]{0};
                if (this.m_orgACIStr != null) {
                    this.parseAccessDefinition(nArray, this.m_orgACIStr, false);
                    this.update();
                }
                return;
            }
        }
        super.setProp(n, object);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -9: {
                try {
                    this.m_accessList.deleteItem(this);
                }
                catch (SaveChangeException saveChangeException) {
                    throw new PropertyException(saveChangeException.getMessage());
                }
                this.makeInvalid();
                break;
            }
        }
        return null;
    }

    static boolean isSpace(String string, int n) {
        if (n >= string.length()) {
            return false;
        }
        char c = string.charAt(n);
        return c == ' ' || c == '\t';
    }

    static void skipSpace(String string, int[] nArray) {
        int n = string.length();
        while (AccessItem.isSpace(string, nArray[0]) && nArray[0] < n) {
            nArray[0] = nArray[0] + 1;
        }
    }

    static void skipSpaceBackwards(String string, int[] nArray) {
        while (AccessItem.isSpace(string, nArray[0]) && nArray[0] >= 0) {
            nArray[0] = nArray[0] - 1;
        }
    }

    static void skipNonSpace(String string, int[] nArray) {
        int n = string.length();
        while (!AccessItem.isSpace(string, nArray[0]) && nArray[0] < n) {
            nArray[0] = nArray[0] + 1;
        }
    }

    static void skipNonSpaceBackwards(String string, int[] nArray) {
        while (!AccessItem.isSpace(string, nArray[0]) && nArray[0] >= 0) {
            nArray[0] = nArray[0] - 1;
        }
    }

    static String getNextToken(String string, int[] nArray) {
        AccessItem.skipSpace(string, nArray);
        int n = nArray[0];
        AccessItem.skipNonSpace(string, nArray);
        int n2 = nArray[0];
        if (n == n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    static String getLastToken(String string, int[] nArray) {
        AccessItem.skipSpaceBackwards(string, nArray);
        int n = nArray[0];
        AccessItem.skipNonSpaceBackwards(string, nArray);
        int n2 = nArray[0];
        if (n == n2) {
            return "";
        }
        return string.substring(n2, n);
    }

    boolean canConvertOk() {
        return this.m_convertOk;
    }

    void setConvertOk(boolean bl) {
        this.m_convertOk = bl;
    }

    void parseAccessDefinition(int[] nArray, String string, boolean bl) {
        try {
            if (this.debug) {
                this.debugMessageLn("access item is " + string);
            }
            AccessItem.skipSpace(string, nArray);
            String string2 = AccessItem.getNextToken(string, nArray);
            if (!string2.equalsIgnoreCase("access")) {
                return;
            }
            string2 = AccessItem.getNextToken(string, nArray);
            if (!string2.equalsIgnoreCase("to")) {
                return;
            }
            AccessItem.skipSpace(string, nArray);
            int n = string.indexOf("by", nArray[0]);
            if (n > nArray[0]) {
                String string3 = string.substring(nArray[0], n);
                nArray[0] = n;
                string3 = string3.trim();
                this.setProp(0x103001, (Object)string3);
                this.m_toWhat = bl ? new SelectAccessToWhat(this, string3, this.m_bySubjects, true) : new SelectAccessToWhat(this, string3, this.m_bySubjects);
                if (this.debug) {
                    this.debugMessageLn("to what is " + string3);
                }
            } else {
                return;
            }
            this.m_userRights = string.substring(nArray[0]);
            if (this.debug) {
                this.debugMessageLn("m_userRights = " + this.m_userRights);
            }
            while (true) {
                string2 = AccessItem.getNextToken(string, nArray);
                if (!(string2 = string2.toLowerCase()).equalsIgnoreCase("by")) {
                    return;
                }
                int n2 = nArray[0];
                int n3 = 0;
                boolean bl2 = false;
                if (this.debug) {
                    this.debugMessageLn("before while....");
                }
                boolean bl3 = false;
                while (true) {
                    AccessItem.skipSpace(string, nArray);
                    string2 = string.substring(nArray[0]);
                    string2 = string2.toLowerCase();
                    if (this.debug) {
                        this.debugMessageLn("   token = " + string2);
                    }
                    if (string2.length() == 0 || string2.startsWith("by")) {
                        bl2 = true;
                        string2 = AccessItem.getLastToken(string, nArray);
                        n3 = nArray[0];
                        break;
                    }
                    String string4 = "dnattr";
                    if (string2.startsWith("dnattr")) {
                        bl3 = true;
                    } else {
                        string4 = "(";
                        if (string2.startsWith("(")) {
                            if (!bl3) {
                                n3 = nArray[0] - 1;
                                if (!this.debug) break;
                                this.debugMessageLn("lastOffset = " + n3);
                                break;
                            }
                            bl3 = false;
                        }
                    }
                    nArray[0] = nArray[0] + string4.length();
                }
                if (this.debug) {
                    this.debugMessageLn("after while...");
                }
                String string5 = string.substring(n2, n3);
                string5 = string5.trim();
                if (this.debug) {
                    this.debugMessageLn("by whom is " + string5);
                }
                if (this.debug) {
                    this.debugMessageLn("before while...");
                }
                n2 = nArray[0];
                do {
                    string2 = AccessItem.getNextToken(string, nArray);
                    if (!this.debug) continue;
                    this.debugMessageLn("token = " + string2);
                } while (!bl2 && !string2.endsWith(")"));
                n3 = nArray[0];
                if (this.debug) {
                    this.debugMessageLn("after while...  beginOffset =" + n2 + "  lastOffset=" + n3 + " value length=" + string.length());
                }
                String string6 = string.substring(n2, n3);
                string6 = string6.trim();
                if (this.debug) {
                    this.debugMessageLn("access is " + string6);
                }
                this.setProp(1126912, (Object)string6);
                this.setProp(0x113100, (Object)string5);
                if (bl) continue;
                ByWhomPermission byWhomPermission = new ByWhomPermission(this, string5, string6);
                this.m_bySubjects.addChild(byWhomPermission);
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    public String toLDIF() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("access to ");
        String string = this.m_toWhat.toString();
        stringBuffer.append(String.valueOf(string) + "\n");
        int n = this.m_bySubjects.countChildren();
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n2);
            String string2 = byWhomPermission.toString();
            stringBuffer.append("        " + string2 + "\n");
            ++n2;
        }
        if (this.debug) {
            this.debugMessageLn("AccessItem::toString():   val = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public boolean isStructureAccess() {
        return this.m_toWhat.isStructureAccess();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("access to ");
        String string = this.m_toWhat.toString();
        stringBuffer.append(string);
        int n = this.m_bySubjects.countChildren();
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.m_bySubjects.nthChild(n2);
            String string2 = byWhomPermission.toString();
            stringBuffer.append(" " + string2);
            ++n2;
        }
        if (this.debug) {
            this.debugMessageLn("AccessItem::toString():   val = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void copyTo(IAdminProp iAdminProp) throws PropertyException {
        if (iAdminProp instanceof AccessItem) {
            AccessItem accessItem = (AccessItem)iAdminProp;
            accessItem.m_orgACIStr = this.m_orgACIStr;
            int[] nArray = new int[]{0};
            accessItem.parseAccessDefinition(nArray, accessItem.m_orgACIStr, false);
        }
    }

    public void reset() {
        try {
            this.setProp(0x103001, (Object)"");
            this.setProp(0x113100, (Object)"");
            this.setProp(1126912, (Object)"");
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void update() throws PropertyException {
        this.m_accessList.update();
        if (!this.m_accessList.saveAccessList()) {
            throw new PropertyException(LDAPLang.getStrCannotUpdateServer());
        }
    }

    public boolean isEntry() {
        return this.m_toWhat.isEntry();
    }

    public boolean isAttr() {
        return this.m_toWhat.isAttr();
    }

    public void saveChanges(int n) throws SaveChangeException {
    }

    public void cleanup() {
        this.m_parent = null;
        this.m_accessList = null;
        this.m_toWhat = null;
        this.m_bySubjects = null;
        this.m_userRights = null;
        this.m_orgACIStr = null;
    }

    public static void main(String[] stringArray) {
        Root.debugAccessItemEntry = true;
        AccessItem accessItem = new AccessItem();
        new SelectAccessToWhat();
        SelectAccessByWhom selectAccessByWhom = new SelectAccessByWhom();
        new SelectAccessPermissions();
        int[] nArray = new int[1];
        String[] stringArray2 = new String[]{"access to entry by BindMode=Anonymous * (read)", "access to entry by BindMode=SimplePassword * (read)", "access to entry by BindMode=SSLClientAuthentication * (read)", "access to entry by self (read)", "access to entry by dn=\"c=us\" (read)", "access to entry by dnAttr=manager (read)", "access to entry by group=\"c=us\" (read)", "access to entry by * (read)", "access to entry by dn=\".*,dc=us,dc=tools\" (read)", "access to entry by dn=\".*,dc=us,dc=tools,dc=sedona\" (write)", "access to entry by dn = \"c=us\" (read)", "access to entry by group= \"c=us\" (read)", "access to entry by dnAttr = ( manager) (read)"};
        accessItem.setDebug(true);
        int n = 0;
        while (n < stringArray2.length) {
            accessItem.debugMessageLn("+++++++++++++++++++++++++++++++++++++++++++");
            nArray[0] = 0;
            accessItem.debugMessage("in >");
            accessItem.debugMessageLn(stringArray2[n]);
            accessItem.parseAccessDefinition(nArray, stringArray2[n], true);
            try {
                selectAccessByWhom.parse((String)accessItem.getProp(0x113100));
                selectAccessByWhom.setDebug(true);
                selectAccessByWhom.debugMessageLn("   bindMode = " + selectAccessByWhom.getProp(1650696));
                selectAccessByWhom.debugMessageLn("   type = " + selectAccessByWhom.getProp(1585152));
                selectAccessByWhom.debugMessageLn("   dn = " + selectAccessByWhom.getProp(1585153));
                selectAccessByWhom.debugMessageLn("   dnAttr = " + selectAccessByWhom.getProp(1585158));
                selectAccessByWhom.debugMessageLn("   group = " + selectAccessByWhom.getProp(1585159));
                selectAccessByWhom.reset();
            }
            catch (PropertyException propertyException) {
                System.out.println(propertyException.getMessage());
            }
            accessItem.reset();
            ++n;
        }
    }
}

