/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.AccessCtrlPoint;
import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.List;
import oracle.ldap.admin.NewAccessItem;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AccessList
extends List
implements ICommandParent {
    static final String ORCLACI = "orclaci";
    static final String ORCLENTRYLEVELACI = "orclentrylevelaci";
    static final int CMD_NEW = -8;
    String m_subACLDn;
    String m_attrType;
    Entry m_entry;
    static AccessItem m_sampleAccessItem = new AccessItem();
    AccessCtrlPoint m_acp;

    public String getDn() {
        return this.m_subACLDn;
    }

    public void setDn(String string) {
        this.m_subACLDn = string;
    }

    public AccessList() {
    }

    public AccessList(Root root, String string) {
        super(root, null);
        this.init(root, string);
    }

    public AccessList(Root root, String string, String string2, Entry entry) {
        super(root, null);
        this.init(root, string);
        this.m_attrType = string2;
        this.m_entry = entry;
    }

    public String getThisEntry() {
        return this.m_entry.getDn();
    }

    void init(Root root, String string) {
        this.setSampleChild(m_sampleAccessItem);
        this.m_subACLDn = string;
        try {
            this.setProp(0x110001, (Object)string);
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "controlling_access_to_the_directory";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/ldapacl.gif";
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle4();
            }
            case 2686979: {
                return new Integer(35);
            }
            case 5177493: {
                return new NewAccessItem(this, this.m_parent);
            }
            case 3080204: {
                return new Integer(2 | (this.m_children != null && this.m_children.size() != 0 ? 0x100000 : 0) | 0x200000 | 0x40 | (this.m_parent.isConnected() ? 4 : 0));
            }
            case 2162725: {
                return new Integer(2);
            }
            case 273220108: {
                if (!this.isConnected()) {
                    return null;
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int n2 = 0;
                iAdminPropArray[n2++] = new CommandProp(this, -10, LDAPLang.getStrCreateLikeLabel1(), LDAPLang.getStrCreateLikeDescp1(), "images/createlike.gif", 1, 1);
                iAdminPropArray[n2++] = new CommandProp(this, -9, LDAPLang.getStrDeleteLabel4(), LDAPLang.getStrDeleteDescp1(), "images/delete.gif", 1, 0);
                iAdminPropArray[n2 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete1());
                return iAdminPropArray;
            }
            case 273613313: {
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int n3 = 0;
                iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrNewLabel(), LDAPLang.getStrNewDescp(), "images/create.gif");
                iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), LDAPLang.getStrRefreshDescp(), "images/refresh.gif");
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    public boolean areThereDuplicates(Vector vector, int n, Object object) {
        if (vector == null) {
            vector = this.m_children;
        }
        return AdminProp.count(vector, n, object, 2) > 1;
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == -8) {
                return (IAdminProp)this.getProp(5177493);
            }
            if (n == -10) {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                IAdminProp iAdminProp2 = (IAdminProp)this.getProp(5177493);
                ((AdminProp)iAdminPropArray[0]).copyTo(iAdminProp2);
                return iAdminProp2;
            }
            if (n == -9) {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                int n2 = 1;
                while (n2 < iAdminPropArray.length) {
                    this.m_children.removeElement(iAdminPropArray[n2]);
                    ++n2;
                }
                try {
                    if (this.countChildren() == 1) {
                        if (this.m_attrType.equalsIgnoreCase(ORCLACI)) {
                            this.m_entry.removeOrclACI();
                        } else {
                            this.m_entry.removeOrclEntryACI();
                        }
                    } else {
                        this.deleteItem((AccessItem)iAdminPropArray[0]);
                    }
                }
                catch (SaveChangeException saveChangeException) {
                    this.m_parent.updateACL(this);
                    throw new PropertyException(saveChangeException);
                }
                return null;
            }
            if (n == -5) {
                this.m_parent.updateACL(this);
                return null;
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    void addAccessItem(AdminProp adminProp) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        this.m_children.addElement(adminProp);
    }

    public Vector getAccessItem() {
        return this.m_children;
    }

    public void setAccessCtrlPoint(AccessCtrlPoint accessCtrlPoint) {
        this.m_acp = accessCtrlPoint;
    }

    public void saveNewAccessItem(NewAccessItem newAccessItem) throws Exception {
        this.setStatusMessage(String.valueOf(LDAPLang.getStrSaving()) + " " + newAccessItem);
        this.m_parent.setErrorMessage("");
        if (this.m_parent.saveNewSchemaObject(newAccessItem.toString(), this.m_subACLDn, this.m_attrType)) {
            int[] nArray = new int[1];
            this.addChild(new AccessItem(this.m_parent, newAccessItem.toString(), nArray, this));
            this.update();
        }
        this.setStatusMessage(LDAPLang.getStrReady());
    }

    public void addChild(Object object) {
        super.addChild(object);
        if (this.m_acp != null) {
            this.m_acp.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    public boolean saveAccessList() {
        try {
            if (!this.m_parent.isBound()) {
                this.setStatusMessage("Not bound");
                return false;
            }
            String[] stringArray = SubSchema.getSchemaValueArray(this.getAccessItem());
            int n = this.m_parent.m_serverAccess.replaceAttributeValue(this.m_subACLDn, this.m_attrType, stringArray);
            return n == 2;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return false;
        }
    }

    public String getErrorMessage() {
        return this.m_parent.getErrorMessage();
    }

    public void deleteItem(AccessItem accessItem) throws SaveChangeException {
        this.removeChild(accessItem);
        if (!this.saveAccessList()) {
            throw new SaveChangeException(this.getErrorMessage());
        }
        if (this.m_acp != null) {
            this.m_acp.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    public void update() {
        super.update();
        if (this.m_acp != null) {
            this.m_acp.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    public AdminProp getEntry() {
        return this.m_entry;
    }

    public void cleanup() {
        super.cleanup();
        this.m_acp = null;
        m_sampleAccessItem = null;
        this.m_subACLDn = null;
        this.m_attrType = null;
        this.m_entry = null;
        this.m_parent = null;
        if (this.m_children != null) {
            int n = 0;
            while (n < this.m_children.size()) {
                ((AccessItem)this.m_children.elementAt(n)).cleanup();
                ++n;
            }
            this.m_children.removeAllElements();
        }
        this.m_children = null;
    }
}

