/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.ACPStructList;
import oracle.ldap.admin.AttrFilter;
import oracle.ldap.admin.AttrPermissions;
import oracle.ldap.admin.AttrSelector;
import oracle.ldap.admin.AttrUser;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class AttrAccessItem
extends StructAccessItem {
    static final int PR_ACCESS_READ = 0x103100;
    static final int PR_ACCESS_SEARCH = 0x103101;
    static final int PR_ACCESS_WRITE = 1061122;
    static final int PR_ACCESS_SELFWRITE = 0x103103;
    static final int PR_ACCESS_COMPARE = 1061124;
    String m_attr;
    String m_op;
    AttrSelector m_attrSelectObj;
    AttrPermissions m_attrPermObj;
    static final String[][] m_attrConflicts = new String[][]{{"read", "noread"}, {"write", "nowrite"}, {"search", "nosearch"}, {"selfwrite", "noselfwrite"}, {"compare", "nocompare"}};
    String m_attr_backup;
    String m_op_backup;
    AttrSelector m_attrSelectObj_backup;
    AttrPermissions m_attrPermObj_backup;

    public AttrAccessItem() {
    }

    public AttrAccessItem(ACPStructList aCPStructList, String string, String string2, String string3, String string4, String string5) {
        super(aCPStructList, string, string3, string4, string5);
        this.m_attr = string2;
    }

    public AttrAccessItem(ACPStructList aCPStructList, String string, String string2, String string3, String string4, String string5, String string6) {
        this(aCPStructList, string, string2, string4, string5, string6);
        this.m_op = string3;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(1060868, LDAPLang.getStrPartialEntry(), LDAPLang.getStrAttributePdsc());
        this.registerProp(0x103003, LDAPLang.getStrAttrOpPlbl2(), LDAPLang.getStrEmptyString());
    }

    public String getAttribute() {
        return this.m_attr;
    }

    public String getOp() {
        if (this.m_op == null || this.m_op.length() == 0) {
            this.m_op = "=";
        }
        return this.m_op;
    }

    public void setOp(String string) {
        this.m_op = string;
    }

    public void setAttribute(String string) {
        this.m_attr = string;
        this.m_ai.setDirty(true);
        this.sendAdminPropertyChangeEvents(1060868, string);
    }

    public void setAttribute(String string, String string2) {
        this.m_attr = string;
        this.m_op = string2;
        this.m_ai.setDirty(true);
        this.sendAdminPropertyChangeEvents(1060868, string);
    }

    public void setAccessRights(String string) {
        this.m_accessRights = string;
        this.m_ai.setDirty(true);
        this.sendAdminPropertyChangeEvents(0x103101, null);
        this.sendAdminPropertyChangeEvents(0x103100, null);
        this.sendAdminPropertyChangeEvents(1061122, null);
        this.sendAdminPropertyChangeEvents(0x103103, null);
        this.sendAdminPropertyChangeEvents(1061124, null);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 2031768: {
                return LDAPLang.getStrTitle1();
            }
            case 0x110001: {
                return String.valueOf(this.m_filter) + " " + this.m_op + " " + this.m_attr + " " + this.m_user + " " + this.m_accessRights;
            }
            case 1060868: {
                return this.m_attr;
            }
            case 0x103003: {
                return this.m_op;
            }
            case 272695330: {
                if (this.m_filterObj == null) {
                    this.m_filterObj = new AttrFilter(this, this.m_filter);
                }
                if (this.m_userObj == null) {
                    this.m_userObj = new AttrUser(this, this.m_user, this.m_bindMode);
                }
                if (this.m_attrSelectObj == null) {
                    this.m_attrSelectObj = new AttrSelector(this, this.m_attr, this.m_op);
                }
                if (this.m_attrPermObj == null) {
                    this.m_attrPermObj = new AttrPermissions(this, this.m_accessRights);
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_filterObj, this.m_userObj, this.m_attrSelectObj, this.m_attrPermObj};
                return iAdminPropArray;
            }
            case 0x103100: {
                return this.getAccessColumn(this.m_accessRights, "noread", "read");
            }
            case 1061122: {
                return this.getAccessColumn(this.m_accessRights, "nowrite", "write");
            }
            case 0x103101: {
                return this.getAccessColumn(this.m_accessRights, "nosearch", "search");
            }
            case 0x103103: {
                return this.getAccessColumn(this.m_accessRights, "noselfwrite", "selfwrite");
            }
            case 1061124: {
                return this.getAccessColumn(this.m_accessRights, "nocompare", "compare");
            }
        }
        return super.getProp(n);
    }

    public boolean equals(Object object) {
        if (object instanceof AttrAccessItem && super.equals(object)) {
            AttrAccessItem attrAccessItem = (AttrAccessItem)object;
            return this.compare(this.getAttribute(), attrAccessItem.getAttribute()) && this.compare(this.getOp(), attrAccessItem.getOp());
        }
        return false;
    }

    public boolean conflicts(Object object) {
        if (object instanceof AttrAccessItem) {
            AttrAccessItem attrAccessItem = (AttrAccessItem)object;
            return this.compare(this.getFilter(), attrAccessItem.getFilter()) && this.compare(this.getUser(), attrAccessItem.getUser()) && this.compare(this.getBindMode(), attrAccessItem.getBindMode()) && this.compare(this.getAttribute(), attrAccessItem.getAttribute()) && this.compare(this.getOp(), attrAccessItem.getOp()) && this.conflicts(this.getAccessRights(), attrAccessItem.getAccessRights(), m_attrConflicts);
        }
        return false;
    }

    public void backup() {
        super.backup();
        this.m_attr_backup = this.m_attr;
        this.m_op_backup = this.m_op;
        this.m_attrSelectObj_backup = this.m_attrSelectObj;
        this.m_attrPermObj_backup = this.m_attrPermObj;
    }

    public void recover() {
        super.recover();
        this.m_attr = this.m_attr_backup;
        this.m_op = this.m_op_backup;
        this.m_attrSelectObj = this.m_attrSelectObj_backup;
        this.m_attrPermObj = this.m_attrPermObj_backup;
    }
}

