/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.AttrPermissions;
import oracle.ldap.admin.EntryPermissions;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SelectAccessByWhom;
import oracle.ldap.admin.SelectAccessPermissions;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class ByWhomPermission
extends AdminProp {
    static final int PR_BYWHOM = 1585152;
    static final int PR_BINDMODE = 1650690;
    static final int PR_PERMISSION = 1585153;
    SelectAccessByWhom m_byWhom;
    SelectAccessPermissions m_access;
    String m_orgByWhom;
    String m_orgPermission;
    String m_orgBindMode;
    boolean debug;

    void init(AccessItem accessItem, String string, String string2) {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
        this.m_orgPermission = string2;
        if (accessItem.isEntry()) {
            this.m_access = new EntryPermissions(accessItem, string2);
        } else if (accessItem.isAttr()) {
            this.m_access = new AttrPermissions(accessItem, string2);
        }
        this.m_byWhom = new SelectAccessByWhom(accessItem, string, this.m_access);
        try {
            this.m_orgBindMode = (String)this.m_byWhom.getProp(1650696);
            this.m_orgByWhom = this.m_byWhom.getByWhoWithoutBindMode();
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(1585152, LDAPLang.getStrBywhomPlbl(), LDAPLang.getStrBywhomPdsc());
        this.registerProp(1585153, LDAPLang.getStrPermissionPlbl(), LDAPLang.getStrPermissionPdsc());
        this.registerProp(1650690, LDAPLang.getStrBindmodesPlbl(), LDAPLang.getStrEmptyString());
    }

    public ByWhomPermission() {
    }

    public ByWhomPermission(AccessItem accessItem) {
        this.init(accessItem, null, null);
    }

    public ByWhomPermission(AccessItem accessItem, String string, String string2) {
        this.init(accessItem, string, string2);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "adding_and_modifying_user_permissions";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/ldapaci.gif";
            }
            case 0x110001: {
                return String.valueOf(this.m_orgByWhom) + " " + this.m_orgPermission;
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle3();
            }
            case 3080204: {
                return new Integer(131078);
            }
            case 272630384: {
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_byWhom, this.m_access};
                return iAdminPropArray;
            }
            case 1585152: {
                return this.m_byWhom.toString();
            }
            case 1585153: {
                return this.m_access.toString();
            }
            case 1650690: {
                return this.m_byWhom.getProp(1650696);
            }
        }
        return super.getProp(n);
    }

    public String toString() {
        try {
            String string = this.m_byWhom.toString();
            String string2 = this.m_access.toString();
            String string3 = (String)this.m_byWhom.getProp(1650696);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("by ");
            String string4 = string3.trim();
            if (!string4.equalsIgnoreCase("None")) {
                stringBuffer.append("BindMode=" + string4);
            }
            stringBuffer.append(" " + string + " " + string2);
            if (this.debug) {
                this.debugMessageLn("ByWhomPermissions::toString():   val=" + stringBuffer);
            }
            return stringBuffer.toString();
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return null;
        }
    }

    boolean isEntryPermission() {
        return this.m_access instanceof EntryPermissions;
    }

    boolean isAttrPermission() {
        return this.m_access instanceof AttrPermissions;
    }

    public void saveChanges(int n) throws SaveChangeException {
    }
}

