/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.ByWhomPermission;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewByWhomPermission;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class ByWhomPermissions
extends AdminList
implements ICommandParent {
    AccessItem m_aci;
    boolean m_change = false;

    public ByWhomPermissions(Root root, AccessItem accessItem) {
        super(root);
        this.m_aci = accessItem;
        this.setSampleChild(new ByWhomPermission());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "adding_and_modifying_user_permissions";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return LDAPLang.getStrUserGroupsPerm();
            }
            case 2032706: {
                return LDAPLang.getStrUsersGroupsPerm();
            }
            case 2032708: {
                return LDAPLang.getStrAllAccessRules();
            }
            case 273220108: {
                int n2 = 0;
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrCreateLabel1(), LDAPLang.getStrCreateDesc1(), "images/create.gif");
                iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrDeleteLabel3(), LDAPLang.getStrDeleteDesc2(), "images/delete.gif");
                iAdminPropArray[n2 - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
                return iAdminPropArray;
            }
            case 273613891: {
                int n3 = 0;
                IAdminProp[] iAdminPropArray = new IAdminProp[1];
                iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, -42, "Show LDIF", " ", "images/context.gif");
                return iAdminPropArray;
            }
            case 282001424: {
                int[] nArray = new int[]{1585152, 1585153};
                return nArray;
            }
        }
        return super.getProp(n);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -8: {
                this.m_change = true;
                return new NewByWhomPermission(this.m_aci, this);
            }
            case -9: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    return null;
                }
                int n2 = 0;
                while (n2 < iAdminPropArray.length) {
                    this.removeChild(iAdminPropArray[n2]);
                    ++n2;
                }
                this.update();
                this.m_change = true;
                this.m_aci.sendAdminPropertyChangeEvents(12006149, null);
            }
        }
        return null;
    }

    boolean isChanged() {
        return this.m_change;
    }

    boolean hasEntryPermissions() {
        int n = this.countChildren();
        if (n <= 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.nthChild(n2);
            if (byWhomPermission.isEntryPermission()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasAttrPermissions() {
        int n = this.countChildren();
        if (n <= 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            ByWhomPermission byWhomPermission = (ByWhomPermission)this.nthChild(n2);
            if (byWhomPermission.isAttrPermission()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void saveChanges(int n) throws SaveChangeException {
    }
}

