/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.ServerList;

class ConfigFile {
    static final String CONFIG_FILE = "osdadmin.ini";
    static final String SEPARATOR_MARK = "@";
    static final String NEW_LINE = "\n";
    static final String VALUE_SEPARATOR = ":";
    static final String HOST_PREFIX = "host:";
    static final String PORT_PREFIX = "port:";
    static final String SIZE_LIMIT_PREFIX = "size:";
    static final String TIME_LIMIT_PREFIX = "time:";
    static final String ACP_OPT_PREFIX = "acp:";
    static final String ACP_SEARCH_PREFIX = "search:";
    static final String DEFAULT_PREFIX = "default:";
    static boolean loaded;
    Vector m_optionlist;
    String m_cfgfilename = "osdadmin.ini";
    File m_cfgfile;
    ServerList m_slist;

    public ConfigFile(String string, ServerList serverList) {
        this.m_cfgfilename = string;
        this.m_optionlist = new Vector();
        this.m_slist = serverList;
    }

    public Vector loadData() {
        File file = this.getConfigFile(this.m_cfgfilename);
        if (file.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                Server server = null;
                Integer n = new Integer(25);
                Integer n2 = new Integer(200);
                Integer n3 = new Integer(0);
                String string2 = null;
                Integer n4 = new Integer(389);
                Vector<String> vector = null;
                int n5 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#")) continue;
                    if (string.startsWith(HOST_PREFIX)) {
                        bl = true;
                        string2 = string.substring(5).trim();
                        continue;
                    }
                    if (string.startsWith(PORT_PREFIX)) {
                        n4 = Integer.valueOf(string.substring(5).trim());
                        continue;
                    }
                    if (string.startsWith(TIME_LIMIT_PREFIX)) {
                        n = Integer.valueOf(string.substring(5).trim());
                        continue;
                    }
                    if (string.startsWith(SIZE_LIMIT_PREFIX)) {
                        n2 = Integer.valueOf(string.substring(5).trim());
                        continue;
                    }
                    if (string.startsWith(ACP_OPT_PREFIX)) {
                        n3 = Integer.valueOf(string.substring(4).trim());
                        continue;
                    }
                    if (string.startsWith(ACP_SEARCH_PREFIX)) {
                        if (vector == null) {
                            vector = new Vector<String>();
                        }
                        vector.addElement(string.substring(7).trim());
                        continue;
                    }
                    n5 = string.indexOf(SEPARATOR_MARK);
                    if (n5 >= 0) {
                        if (bl2 && !bl) {
                            server = new Server(this.m_slist, string2, n4);
                            if (bl3) {
                                server.setDefaultServer();
                                bl3 = false;
                            }
                            this.m_optionlist.addElement(server);
                        } else if (bl2 & bl) {
                            server = new Server(this.m_slist, string2, n4, n2, n, n3, vector);
                            if (bl3) {
                                server.setDefaultServer();
                                bl3 = false;
                            }
                            this.m_optionlist.addElement(server);
                            vector = null;
                        } else {
                            bl2 = true;
                        }
                        string2 = string.substring(0, n5).trim();
                        n4 = Integer.valueOf(string.substring(n5 + 1));
                        continue;
                    }
                    if (!string.startsWith(DEFAULT_PREFIX) || !string.substring(8).trim().equalsIgnoreCase("true")) continue;
                    bl3 = true;
                }
                if (bl) {
                    server = new Server(this.m_slist, string2, n4, n2, n, n3, vector);
                    if (bl3) {
                        server.setDefaultServer();
                        bl3 = false;
                    }
                    this.m_optionlist.addElement(server);
                } else if (bl2) {
                    bl2 = false;
                    server = new Server(this.m_slist, string2, n4);
                    if (bl3) {
                        server.setDefaultServer();
                        bl3 = false;
                    }
                    this.m_optionlist.addElement(server);
                }
                return this.m_optionlist;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public boolean saveData() {
        block9: {
            Object object;
            File file = this.getConfigFile(this.m_cfgfilename);
            if (file.exists()) {
                object = this.getConfigPath();
                File file2 = new File((String)object, String.valueOf(this.m_cfgfilename) + ".bak");
                try {
                    if (!file2.exists() || file2.delete()) {
                        file.renameTo(file2);
                    }
                }
                catch (Exception exception) {}
            }
            if ((file = this.getConfigFile(this.m_cfgfilename)).exists()) break block9;
            try {
                object = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                int n = this.m_slist.countChildren();
                int n2 = 0;
                while (n2 < n) {
                    Server server = (Server)this.m_slist.nthChild(n2);
                    ((Writer)object).write(String.valueOf(server.getHost()) + SEPARATOR_MARK + server.getPort() + NEW_LINE);
                    ((Writer)object).write(HOST_PREFIX + server.getHost() + NEW_LINE);
                    ((Writer)object).write(PORT_PREFIX + server.getPort() + NEW_LINE);
                    ((Writer)object).write(SIZE_LIMIT_PREFIX + server.getSizeLimit() + NEW_LINE);
                    ((Writer)object).write(TIME_LIMIT_PREFIX + server.getTimeLimit() + NEW_LINE);
                    ((Writer)object).write(ACP_OPT_PREFIX + server.getAcpOption() + NEW_LINE);
                    ((Writer)object).write(DEFAULT_PREFIX + server.isDefaultServer() + NEW_LINE);
                    int n3 = server.getSearchCount();
                    int n4 = 0;
                    while (n4 < n3) {
                        ((Writer)object).write(ACP_SEARCH_PREFIX + server.getSearchStringAt(n4) + NEW_LINE);
                        ++n4;
                    }
                    ++n2;
                }
                ((BufferedWriter)object).flush();
                ((BufferedWriter)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public String getConfigPath() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (string == null) {
            string = ".";
        }
        return string.trim();
    }

    public File getConfigFile(String string) {
        String string2 = this.getConfigPath();
        return new File(string2, string);
    }
}

